/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.GoodsQueryDTO;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goods"})
public class GoodsController {
    private static final Logger log = LoggerFactory.getLogger(GoodsController.class);
    @Resource
    private GoodsService goodsService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private UserService userService;

    @GetMapping
    public PageInfo<Goods> index(@RequestHeader(value="merchantId") Integer merchantId, GoodsQueryDTO goodsQueryDTO) {
        PageContext.startPage();
        goodsQueryDTO.setMerchantId(merchantId);
        List list = this.goodsService.findByCondition((Object)goodsQueryDTO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            try {
                UserDiscountDTO userDiscountDTO;
                Config config = this.configService.findSysConfig(merchantId);
                User user = (User)SecurityContext.getUser();
                if (config != null && user != null && config.getPriceDisplay().equals(1) && (userDiscountDTO = this.userService.getUserDiscountInfo(user)) != null && userDiscountDTO.getDiscount() != null) {
                    list.forEach(hotGoods -> hotGoods.setVipPrice(hotGoods.getSalePrice().multiply(userDiscountDTO.getDiscount()).setScale(2, 4)));
                }
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u4f1a\u5458\u4ef7\u663e\u793a\u5931\u8d25msg:[{}],[{}]", (Object)e.getMessage(), (Object)e);
            }
        }
        return new PageInfo(list);
    }
}

