/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.controller.CouponController;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.CouponService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"coupons"})
@PreAuthorize(value="hasRole('USER')")
public class CouponController {
    @Resource
    private CouponService couponService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersServiceImpl;

    @GetMapping
    public List<CouponDTO> getCoupons() {
        User user = (User)SecurityContext.getUser();
        return this.couponService.findByCondition((Serializable)CouponDTO.builder().userNo(user.getUserNo()).merchantId(user.getBrandId()).build());
    }

    @PostMapping(value={"mine-box"})
    public Map<String, Object> getMyCoupon(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders createObject) {
        Integer pageIndex = PageContext.pageIndex();
        User user = (User)SecurityContext.getUser();
        createObject.setMerchantId(merchantId);
        createObject.setUserNo(user.getUserNo());
        createObject.setMerchantId(merchantId);
        createObject.setUserId(user.getUserId());
        createObject.setAppid(appid);
        createObject.setWechatUnionId(user.getUnionid());
        return this.couponService.findMineCoupons(CouponDTO.builder().userNo(user.getUserNo()).merchantId(user.getBrandId()).build(), pageIndex, createObject);
    }

    @PostMapping(value={"mine"})
    public Map<String, Object> pickupCoupon(CouponDTO couponDTO) {
        User user = (User)SecurityContext.getUser();
        1 map = new /* Unavailable Anonymous Inner Class!! */;
        return this.couponService.addCoupon((Map)map);
    }

    @GetMapping(value={"mine/{id}"})
    public CouponDTO getDetailById(@PathVariable Integer id) {
        return (CouponDTO)this.couponService.findById(id);
    }
}

