/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.BizvaneRole;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.open.service.MiniprogramUserService;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationFilter;
import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"token"})
public class AuthencationTokenController {
    private static final Logger log = LoggerFactory.getLogger(AuthencationTokenController.class);
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private JwtAuthenticationFilter jwtAuthenticationFilter;
    @Resource
    private MiniprogramUserService miniprogramUserService;

    @GetMapping(value={"getAuthencationToken"})
    public String getTokenByCode(@RequestParam(value="unionid") String unionid, @RequestParam(value="memberCode") String memberCode, @RequestParam(value="brandId") Integer brandId) {
        if (StringUtils.isEmpty((Object)unionid)) {
            return "Unionid\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)memberCode)) {
            return "UserNo\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)brandId)) {
            return "MerchantId\u4e3a\u7a7a";
        }
        User user = new User();
        user.setUnionid(unionid);
        user.setUserNo(memberCode);
        user.setMerchantId(brandId);
        try {
            user = this.bizvaneInterface.getMemberInfo(user);
            user.setAppid("wx2c6a6ee11bf89d43");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f";
        }
        if (user == null) {
            return "\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f";
        }
        ArrayList<GrantedAuthority & Serializable> authorities = new ArrayList<GrantedAuthority & Serializable>();
        authorities.add(() -> ((BizvaneRole)BizvaneRole.USER).role());
        user.setAuthorities(authorities);
        log.info("user\u4fe1\u606f:[{}],appid:[{}]", JSONObject.toJSON((Object)user), (Object)user.getAppid());
        return this.jwtAuthenticationFilter.getJsonWebTokenHandler().generateToken((UserDetails)user);
    }
}

