/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.AssembleService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"assemble"})
public class AssembleController {
    private static final Logger log = LoggerFactory.getLogger(AssembleController.class);
    @Autowired
    private AssembleService assembleService;
    @Resource
    private UserService userService;
    @Resource
    private UserCommissionService userCommissionService;

    @GetMapping(value={"getActivityGoodList"})
    public List<MarketActivityGoods> getActivityGoodList(@RequestHeader(value="merchantId") Integer merchantId) {
        return this.assembleService.getActivityGoodList(merchantId);
    }

    @GetMapping(value={"getActivityGoodListByMe"})
    public List<MarketActivityGoods> getActivityGoodListByMe(@RequestHeader(value="merchantId") Integer merchantId) {
        User user = (User)SecurityContext.getUser();
        return this.assembleService.getActivityGoodListByMe(user.getUserNo(), merchantId);
    }

    @GetMapping(value={"getOrdersDetail"})
    public MarketActivityOrders getOrdersDetail(@RequestParam(value="activityOrdersId") Integer activityOrdersId) {
        return this.assembleService.getOrdersDetail(activityOrdersId);
    }

    @GetMapping(value={"getGoodsDetail"})
    public Map getGoodsDetail(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="marketActivityNo") String marketActivityNo) {
        User user = (User)SecurityContext.getUser();
        return this.assembleService.getGoodsDetail(goodsNo, merchantId, marketActivityNo, user.getUserNo());
    }

    @PostMapping(value={"confirm"})
    public Orders confirm(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Orders orders) {
        log.info("POST...method:\u62fc\u56e2 confirm....params===>{}", (Object)JSONObject.toJSONString((Object)orders));
        User user = (User)SecurityContext.getUser();
        orders.setUserId(user.getUserId());
        orders.setUserNo(user.getUserNo());
        orders.setWechatUnionId(user.getUnionid());
        orders.setMerchantId(merchantId);
        return this.assembleService.confirm(orders);
    }

    @PostMapping(value={"confirmOk"})
    public Map confirmOk(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders createObject) {
        User user = (User)SecurityContext.getUser();
        User queryUser = (User)this.userService.findOneByCondition((Serializable)user);
        createObject.setWechatOpenid(user.getOpenid());
        createObject.setUserNo(user.getUserNo());
        createObject.setMerchantId(merchantId);
        createObject.setUserId(user.getUserId());
        createObject.setUserName(queryUser.getFullName());
        createObject.setAppid(appid);
        Boolean parentState = this.userCommissionService.findParentState(queryUser.getUserNo());
        createObject.setEnabledCommission(parentState);
        createObject.setWechatUnionId(queryUser.getUnionid());
        return this.assembleService.addOrders(createObject);
    }

    @GetMapping(value={"getAssemblePicUrl"})
    public Map getAssemblePicUrl(@RequestHeader(value="merchantId") Integer merchantId) {
        return this.assembleService.getAssemblePicUrl(merchantId);
    }
}

