/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.builder;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.builder.OrdersBuilder;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.dto.FreightCalcResponse;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.DateUtil;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.RedisTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class OrdersBuilder {
    private static final Logger log = LoggerFactory.getLogger(OrdersBuilder.class);
    private Orders orders;

    public Orders getOrders() {
        if (this.orders == null) {
            throw new IllegalArgumentException("missing orders source");
        }
        return this.orders;
    }

    public static OrdersBuilder getBuilder(Orders orders) {
        OrdersBuilder ordersBuilder = new OrdersBuilder();
        ordersBuilder.orders = orders;
        ordersBuilder.init();
        return ordersBuilder;
    }

    private void init() {
        Orders thisOrders = this.getOrders();
        if (thisOrders.getGmtCreate() != null) {
            return;
        }
        Date now = new Date();
        thisOrders.setPayStatus(PayStatusEnum.UN_PAY);
        thisOrders.setRepayCount(Integer.valueOf(0));
        thisOrders.setIsVisable(Boolean.valueOf(true));
        thisOrders.setIsComment(Boolean.valueOf(false));
        thisOrders.setOrderStatus(OrdersStatusEnum.TRADE);
        thisOrders.setLogisticsStatus(LogisticsStatusEnum.UN_SEND);
        thisOrders.setGmtCreate(now);
        thisOrders.setOrderAmount(BigDecimal.ZERO);
        thisOrders.setPayAmount(BigDecimal.ZERO);
        thisOrders.setActiveDeduction(BigDecimal.ZERO);
        thisOrders.setUserDeduction(BigDecimal.ZERO);
        thisOrders.setCouponDeduction(BigDecimal.ZERO);
        thisOrders.setCommission(BigDecimal.ZERO);
        List orderItems = thisOrders.getItems();
        for (OrderItems orderItem : orderItems) {
            orderItem.setRefundStatus(RefundStatus.NONE);
            orderItem.setGmtCreate(thisOrders.getGmtCreate());
            orderItem.setShippingFee(BigDecimal.ZERO);
            orderItem.setItemsShippingDeduction(BigDecimal.ZERO);
            orderItem.setCouponDiscount(BigDecimal.ONE);
            orderItem.setUserDiscount(BigDecimal.ONE);
            orderItem.setActiveDiscount(BigDecimal.ONE);
            orderItem.setItemsCouponDeduction(BigDecimal.ZERO);
            orderItem.setItemsPointDeduction(BigDecimal.ZERO);
            orderItem.setItemsUserDeduction(BigDecimal.ZERO);
            orderItem.setCommission(BigDecimal.ZERO);
        }
    }

    public Orders build() {
        Orders thisOrders = this.getOrders();
        thisOrders.setOrderNo(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)10));
        return this.orders;
    }

    private BigDecimal filterZero(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal;
    }

    private BigDecimal scale(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2, 6);
    }

    public OrdersBuilder fromSku(List<GoodsSkuDetail> dbSkuInfo, ActivityGoodsMapper activityGoodsMapper, List<Goods> discountInfo, RedisTemplate redisTemplate) {
        List activityIds;
        Orders thisOrders = this.getOrders();
        List orderItems = thisOrders.getItems();
        for (OrderItems items : orderItems) {
            GoodsSkuDetail skuDetail = this.extractSkuInfo(items, dbSkuInfo);
            items.setGoodsId(skuDetail.getGoodsId());
            items.setGoodsName(skuDetail.getGoodsName());
            items.setGoodsImg(skuDetail.getSkuImg());
            items.setGoodsSkuNo(skuDetail.getSkuNo());
            items.setGoodsSkuName(skuDetail.getSpecNames());
            items.setMarketPrice(skuDetail.getMarketPrice());
            items.setSalePrice(skuDetail.getSalesPrice());
            items.setGoodsNo(skuDetail.getGoodsNo());
            items.setShippingMode(skuDetail.getShippingMode());
            items.setCommission(thisOrders.getEnabledCommission() != null && thisOrders.getEnabledCommission() != false ? skuDetail.getCommission() : BigDecimal.ZERO);
            items.setItemsAmount(items.getSalePrice().multiply(BigDecimal.valueOf(items.getSaleQuantity().intValue())));
            items.setItemsPayAmount(items.getItemsAmount());
            log.info(items.getGoodsSkuNo() + " \u5546\u54c1\u4ed8\u6b3e\u91d1\u989d {}", (Object)items.getItemsPayAmount());
            thisOrders.setOrderAmount(thisOrders.getOrderAmount().add(items.getItemsAmount()));
            thisOrders.setCommission(thisOrders.getCommission().add(items.getCommission()));
        }
        log.info("\u73b0\u5728\u8ba2\u5355\u660e\u7ec6\u8be6\u60c5:{}", (Object)JSONObject.toJSONString((Object)orderItems));
        if (discountInfo != null && (activityIds = activityGoodsMapper.selectDistinctActivityIds(discountInfo, thisOrders.getMerchantId())) != null) {
            ArrayList<OrderItems> goodsids = new ArrayList<OrderItems>();
            ArrayList<Integer> activeGoodsIds = new ArrayList<Integer>();
            for (Integer activityId : activityIds) {
                List goodsIds = activityGoodsMapper.selectActivityGoodsIdsByActivityId(activityId);
                for (OrderItems items : orderItems) {
                    if (!goodsIds.contains(items.getGoodsId())) continue;
                    goodsids.add(items);
                    activeGoodsIds.add(items.getGoodsId());
                }
                thisOrders.setActiveGoodsIds(activeGoodsIds);
            }
            OrderItems activeOrdersItems = new OrderItems();
            for (int i = 0; i < goodsids.size(); ++i) {
                if (i + 1 > goodsids.size() - 1) continue;
                log.info("\u5f00\u59cb\u5904\u7406\u6d3b\u52a8\u4e2d\u7684\u5546\u54c1\u3002\u3002\u3002");
                BeanUtils.copyProperties(goodsids.get(i + 1), (Object)activeOrdersItems);
                activeOrdersItems.setSalePrice(((OrderItems)goodsids.get(i + 1)).getSalePrice().multiply(BigDecimal.valueOf(((OrderItems)goodsids.get(i + 1)).getSaleQuantity().intValue())).add(((OrderItems)goodsids.get(i)).getSalePrice()));
                activeOrdersItems.setMarketPrice(((OrderItems)goodsids.get(i + 1)).getMarketPrice().multiply(BigDecimal.valueOf(((OrderItems)goodsids.get(i + 1)).getSaleQuantity().intValue())).add(((OrderItems)goodsids.get(i)).getMarketPrice().multiply(BigDecimal.valueOf(((OrderItems)goodsids.get(i)).getSaleQuantity().intValue()))));
                activeOrdersItems.setItemsAmount(((OrderItems)goodsids.get(i + 1)).getItemsAmount().add(((OrderItems)goodsids.get(i)).getItemsAmount()));
            }
            if (goodsids.size() > 1) {
                log.info("\u5c06\u6d3b\u52a8\u4e2d\u7684\u8ba2\u5355\u8be6\u60c5\u5b58\u5165\u5230redis\u4e2d\u3002\u3002\u3002");
                redisTemplate.opsForValue().set((Object)"active_orderItems", (Object)activeOrdersItems);
            }
            log.info("\u6d3b\u52a8\u5904\u7406\u540e\u7684\u8ba2\u5355\u660e\u7ec6\u8be6\u60c5:{}", (Object)JSONObject.toJSONString((Object)orderItems));
        }
        log.info("\u521d\u59cb\u8ba2\u5355\u91d1\u989d {}", (Object)thisOrders.getPayAmount());
        return this;
    }

    private GoodsSkuDetail extractSkuInfo(OrderItems items, List<GoodsSkuDetail> goodsSkuDetailList) {
        for (GoodsSkuDetail gsd : goodsSkuDetailList) {
            if (!gsd.getSkuNo().equals(items.getGoodsSkuNo()) || !gsd.getGoodsId().equals(items.getGoodsId())) continue;
            return gsd;
        }
        throw new IllegalArgumentException("\u672a\u80fd\u627e\u5230\u5546\u54c1[" + items.getGoodsSkuNo() + " " + items.getGoodsName() + "]");
    }

    public OrdersBuilder fromActiveDiscount(List<Goods> discountInfo) {
        Orders thisOrders = this.getOrders();
        List orderItems = thisOrders.getItems();
        log.info("from active ...");
        for (OrderItems items : orderItems) {
            Goods discountGoodsInfo = this.extractActiveDiscountInfo(items, discountInfo);
            if (discountGoodsInfo.getDiscount().compareTo(BigDecimal.ONE) > 0) {
                throw new IllegalArgumentException("\u6298\u6263\u4fe1\u606f\u5f02\u5e38\uff1a" + discountGoodsInfo.getDiscount());
            }
            items.setActiveDiscount(discountGoodsInfo.getDiscount());
            items.setItemsActiveDeduction(this.scale(items.getItemsAmount().multiply(BigDecimal.ONE.subtract(items.getActiveDiscount()))));
            items.setItemsPayAmount(items.getItemsPayAmount().subtract(this.filterZero(items.getItemsActiveDeduction())));
            log.info("SKU_NO " + items.getGoodsSkuNo() + " \u6d3b\u52a8\u6298\u6263  {}, \u6d3b\u52a8\u62b5\u6263\u91d1\u989d {} ,\u5546\u54c1\u4ed8\u6b3e\u91d1\u989d {}", new Object[]{items.getActiveDiscount(), items.getItemsActiveDeduction(), items.getItemsPayAmount()});
            thisOrders.setActiveDeduction(thisOrders.getActiveDeduction().add(items.getItemsActiveDeduction()));
            thisOrders.setPayAmount(thisOrders.getPayAmount().subtract(items.getItemsActiveDeduction()));
            log.info("\u5f53\u524d\u8ba2\u5355\u5b9e\u9645\u652f\u4ed8\u91d1\u989d {}, \u6d3b\u52a8\u62b5\u6263 {}", (Object)thisOrders.getPayAmount(), (Object)thisOrders.getActiveDeduction());
        }
        return this;
    }

    private Goods extractActiveDiscountInfo(OrderItems items, List<Goods> activeGoodsInfo) {
        for (Goods goods : activeGoodsInfo) {
            if (!items.getGoodsId().equals(goods.getId())) continue;
            return goods;
        }
        throw new IllegalArgumentException("\u672a\u80fd\u627e\u5230\u5546\u54c1[" + items.getGoodsSkuNo() + " " + items.getGoodsName() + "]");
    }

    public OrdersBuilder fromUserDiscount(UserDiscountDTO userDiscountDTO) {
        Orders thisOrders = this.getOrders();
        List orderItems = thisOrders.getItems();
        log.info("from user discount ...");
        for (OrderItems items : orderItems) {
            BigDecimal goodsDiscountForMarket = items.getMarketPrice().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : items.getSalePrice().divide(items.getMarketPrice(), 2, 6);
            if (userDiscountDTO.getDiscountRange().equals((Object)UserDiscountDTO.DiscountRange.ALL)) {
                this.settingUserDiscountInfo(userDiscountDTO, items);
            } else {
                if (!this.isValidDiscountRange(goodsDiscountForMarket, userDiscountDTO.getDiscountMin(), userDiscountDTO.getDiscountMax())) {
                    log.info(items.getGoodsName() + "\u7684\u6298\u6263\u4e3a" + goodsDiscountForMarket + ",\u4e0d\u5728\u6253\u6298\u8303\u56f4" + userDiscountDTO.getDiscountMin() + "~" + userDiscountDTO.getDiscountMax());
                    continue;
                }
                this.settingUserDiscountInfo(userDiscountDTO, items);
            }
            items.setItemsPayAmount(items.getItemsPayAmount().subtract(this.filterZero(items.getItemsUserDeduction())));
            if (items.getItemsPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
                BigDecimal decimal = new BigDecimal("0.01");
                items.setItemsPayAmount(decimal);
                items.setItemsUserDeduction(items.getItemsUserDeduction().subtract(decimal));
            }
            log.info(items.getGoodsSkuNo() + " \u4f1a\u5458\u6298\u6263  {}, \u4f1a\u5458\u62b5\u6263\u91d1\u989d {} ,\u5546\u54c1\u4ed8\u6b3e\u91d1\u989d {}", new Object[]{items.getUserDiscount(), items.getItemsUserDeduction(), items.getItemsPayAmount()});
            thisOrders.setUserDeduction(thisOrders.getUserDeduction().add(items.getItemsUserDeduction()));
            thisOrders.setPayAmount(thisOrders.getPayAmount().subtract(items.getItemsUserDeduction()));
            log.info("\u5f53\u524d\u8ba2\u5355\u5b9e\u9645\u652f\u4ed8\u91d1\u989d {}, \u4f1a\u5458\u62b5\u6263 {}", (Object)thisOrders.getPayAmount(), (Object)thisOrders.getUserDeduction());
        }
        return this;
    }

    public static void main(String[] args) {
        Orders orders = (Orders)JSONObject.parseObject((String)"{\"activeDeduction\":899.55,\"couponDeduction\":0,\"couponNo\":\"2538530\",\"gmtCreate\":1540878285007,\"isComment\":false,\"isVisable\":true,\"items\":[{\"activeDiscount\":0.85,\"couponDiscount\":1,\"gifts\":[],\"gmtCreate\":1540878285007,\"goodsId\":199,\"goodsImg\":\"\",\"goodsName\":\"\u5fbd\u7ae0\u77ed\u68c9\u8884\",\"goodsSkuName\":\"\u7ea2,S\",\"goodsSkuNo\":\"206\",\"itemsActiveDeduction\":899.55,\"itemsAmount\":5997.00,\"itemsCouponDeduction\":0,\"itemsPayAmount\":3568.21,\"itemsPointDeduction\":0,\"itemsShippingDeduction\":0,\"itemsUserDeduction\":1529.24,\"marketPrice\":2199.00,\"merchantId\":96,\"refundStatus\":\"NONE\",\"salePrice\":1999.00,\"saleQuantity\":3,\"shippingFee\":0,\"userDiscount\":0.7}],\"logisticsStatus\":\"UN_SEND\",\"merchantId\":96,\"orderAmount\":5997.00,\"orderStatus\":\"TRADE\",\"payAmount\":3568.21,\"payStatus\":\"UN_PAY\",\"repayCount\":0,\"shippingAddress\":\"\u4e3a\u5565\u603b\u4e0d\u80fd\",\"shippingCity\":\"\u5317\u4eac\u5e02\",\"shippingDeduction\":0,\"shippingDistrict\":\"\u4e1c\u57ce\u533a\",\"shippingFee\":0,\"shippingMobile\":\"13333333333\",\"shippingName\":\"\u82f9\u679cx\",\"shippingProvince\":\"\u5317\u4eac\u5e02\",\"userComments\":\"\",\"userDeduction\":1529.24,\"userId\":268548,\"userNo\":\"e3f7794ca9ce4afa\",\"wechatUnionId\":\"or4ga0jvwFFdoGY02huXcT7W92FE\"}\n", Orders.class);
        JSONObject data = JSONObject.parseObject((String)"{\"couponDefinitionPO\":{\"couponDefinitionId\":818.0,\"sysCompanyId\":3841.0,\"sysBrandId\":96.0,\"couponDefinitionCode\":\"nAPdQtsd\",\"couponDefinitionType\":1.0,\"couponName\":\"\u6298\u6263\u8d2d\u4e70\u9650\u5236\",\"useChannel\":3.0,\"preferentialType\":2.0,\"discount\":8.0,\"validType\":1.0,\"validDateStart\":\"2018-10-30 00:00:00\",\"validDateEnd\":\"2018-11-10 23:59:59\",\"isRealName\":false,\"isTransfer\":false,\"isSuperposition\":true,\"isTagPriceLimit\":false,\"minConsume\":2000.0,\"maxPreferential\":500.0,\"minDiscount\":7.0,\"applianceCommodityType\":1.0,\"applianceStoreType\":1.0,\"info\":\"\u80fd\u53e0\u52a0\",\"status\":true,\"createUserId\":12831.0,\"createUserName\":\"\u6c64\u658c\",\"createDate\":\"2018-10-30 10:46:40\",\"valid\":true,\"superpositionMemberCard\":true},\"couponEntityPO\":{\"couponEntityId\":2538534.0,\"sysCompanyId\":3841.0,\"sysBrandId\":96.0,\"couponCode\":\"TtLyk7qZ\",\"couponDefinitionId\":\"818\",\"couponBatchSendRecordId\":1236.0,\"memberCode\":\"e3f7794ca9ce4afa\",\"couponName\":\"\u6298\u6263\u8d2d\u4e70\u9650\u5236\",\"discount\":8.0,\"info\":\"\u80fd\u53e0\u52a0\",\"bindStatus\":false,\"validDateStart\":\"2018-10-30 00:00:00\",\"validDateEnd\":\"2018-11-10 23:59:59\",\"isLock\":false,\"sendType\":\"85\",\"sendBusinessId\":1407.0,\"isUse\":false,\"couponStatus\":20.0,\"barcodeUrl\":\"https://qi.test.bizvane.cn//6a4d4006fd6a424e8c3f9179f779b76d\",\"createUserId\":12831.0,\"createUserName\":\"\u9ad8\u8def\u5357\",\"createDate\":\"2018-10-30 10:47:02\",\"valid\":true,\"preferentialType\":2.0},\"couponStatusLogList\":[],\"wxChannelInfoVo\":{\"version\":14.0,\"mbrMemberId\":268548.0,\"memberCode\":\"e3f7794ca9ce4afa\",\"cardNo\":\"17327752131\",\"offlineCardNo\":\"17327752131\",\"name\":\"\",\"phone\":\"17327752131\",\"gender\":\"2\",\"birthdayMd\":\"1019\",\"province\":\"\",\"city\":\"\",\"county\":\"\",\"address\":\"\",\"headPortraits\":\"https://wx.qlogo.cn/mmopen/vi_32/B7kswZ0CJnumqnKRblrJHBA2RL5aciaHOxJLwlaT80TCjfdfBRNicqaqMfxVf1jaN43UpLtTQrP7j6H7DqyoBTbw/132\",\"memberSysId\":18.0,\"sysCompanyId\":3841.0,\"brandId\":96.0,\"openCardTime\":\"2018-10-19 00:00:00\",\"bindCardTime\":\"2018-10-19 19:35:15\",\"effectiveTime\":\"2038-10-19 00:00:00\",\"openCardChannelId\":2.0,\"allChannelIds\":\"2,1\",\"generalizeChannel\":\"0\",\"openCardStoreId\":2.0,\"serviceStoreId\":5.0,\"wxOpenId\":\"o19L942CDUobz2avpQpw8orDh5eg\",\"wxUnionId\":\"or4ga0jvwFFdoGY02huXcT7W92FE\",\"wxPublicId\":91.0,\"levelId\":127.0,\"countIntegral\":1538.0,\"distributionState\":0.0,\"cardStatus\":2.0,\"appId\":\"wxdbcca5299c27edff\",\"wxNick\":\"\u5546\u5e06\u82f9\u679cX\",\"focus\":2.0,\"focusTime\":\"2018-10-19 19:35:12\",\"miniProgram\":2.0}}\n");
        CouponDTO couponDTOByDetailData = BizvaneInterface.getCouponDTOByDetailData((JSONObject)data);
        OrdersBuilder ordersBuilder = OrdersBuilder.getBuilder((Orders)orders).fromCoupons(couponDTOByDetailData);
        System.out.println(JSONObject.toJSONString((Object)ordersBuilder.getOrders()));
    }

    public OrdersBuilder fromCoupons(CouponDTO couponDTO) {
        if (couponDTO == null) {
            return this;
        }
        log.info("from coupon discount ...");
        Orders thisOrders = this.getOrders();
        List orderItems = this.getOrders().getItems();
        BigDecimal totalDeduction = BigDecimal.ZERO;
        BigDecimal reallyDiscount = couponDTO.getDiscount();
        BigDecimal maxDeduction = couponDTO.getMaxDiscountAmount();
        block4: for (OrderItems items : orderItems) {
            switch (1.$SwitchMap$com$wmeimob$fastboot$bizvane$dto$CouponDTO$CouponTypeEnum[couponDTO.getCouponType().ordinal()]) {
                case 1: {
                    BigDecimal couponDeduction = items.getItemsPayAmount().divide(thisOrders.getPayAmount(), 1).multiply(couponDTO.getAmount()).setScale(2, 1);
                    if (couponDeduction.compareTo(items.getItemsPayAmount()) >= 0) {
                        log.error("\u8ba2\u5355 {} \u9879 {} \u62b5\u6263\u91d1\u989d{} \u8d85\u8fc7\u4e86\u5b9e\u9645\u4ed8\u6b3e{} ", new Object[]{thisOrders.getOrderNo(), items.getGoodsSkuNo(), couponDeduction, items.getItemsPayAmount()});
                        throw new CustomException("\u60a8\u65e0\u6cd5\u4f7f\u7528\u8be5\u5238");
                    }
                    items.setItemsCouponDeduction(couponDeduction);
                    items.setCouponDiscount(BigDecimal.ONE.subtract(couponDeduction.divide(items.getItemsPayAmount(), 1).setScale(2, 1)));
                    totalDeduction = totalDeduction.add(items.getItemsCouponDeduction());
                    continue block4;
                }
                case 2: {
                    BigDecimal currentMaxDeduction = items.getItemsPayAmount().divide(thisOrders.getPayAmount(), 1).multiply(maxDeduction).setScale(2, 1);
                    BigDecimal currentDeduction = items.getItemsPayAmount().multiply(BigDecimal.ONE.subtract(couponDTO.getDiscount()).setScale(2, 1));
                    log.info("\u6700\u5927\u6298\u6263\uff1a{},\u5f53\u524d\u5206\u644a\u7684\u6700\u5927\u6298\u6263\uff1a{},\u5f53\u524d\u6298\u6263\u7684\u62b5\u6263\u91d1\u989d\uff1a{}", new Object[]{maxDeduction, currentMaxDeduction, currentDeduction});
                    if (currentDeduction.compareTo(currentMaxDeduction) > 0) {
                        log.info("\u77eb\u6b63\u6298\u6263\u548c\u6298\u6263\u7684\u62b5\u6263\u4fe1\u606f");
                        reallyDiscount = BigDecimal.ONE.subtract(currentMaxDeduction.divide(items.getItemsPayAmount(), 2, 6));
                        items.setCouponDiscount(reallyDiscount);
                        items.setItemsCouponDeduction(currentMaxDeduction);
                    } else {
                        items.setCouponDiscount(couponDTO.getDiscount());
                        items.setItemsCouponDeduction(currentDeduction);
                    }
                    totalDeduction = totalDeduction.add(items.getItemsCouponDeduction());
                    continue block4;
                }
            }
            throw new CustomException("\u4e0d\u652f\u6301\u7684\u5238\u7c7b\u578b");
        }
        BigDecimal reallyDeduction = CouponDTO.CouponTypeEnum.CASH.equals((Object)couponDTO.getCouponType()) ? couponDTO.getAmount() : (thisOrders.getPayAmount().multiply(BigDecimal.ONE.subtract(couponDTO.getDiscount())).compareTo(maxDeduction) > 0 ? maxDeduction : this.scale(thisOrders.getPayAmount().multiply(BigDecimal.ONE.subtract(couponDTO.getDiscount()))));
        if (reallyDeduction.compareTo(totalDeduction) != 0) {
            BigDecimal subtract = reallyDeduction.subtract(totalDeduction);
            log.info("\u8ba2\u5355 \u4f18\u60e0\u5238\u6298\u6263\u5c3e\u5dee {} ", (Object)subtract);
            ((OrderItems)orderItems.get(0)).setItemsCouponDeduction(((OrderItems)orderItems.get(0)).getItemsCouponDeduction().add(subtract));
            ((OrderItems)orderItems.get(0)).setCouponDiscount(BigDecimal.ONE.subtract(((OrderItems)orderItems.get(0)).getItemsCouponDeduction().divide(((OrderItems)orderItems.get(0)).getItemsPayAmount(), 2, 4)));
        }
        orderItems.forEach(od -> {
            od.setItemsPayAmount(od.getItemsPayAmount().subtract(this.filterZero(od.getItemsCouponDeduction())));
            thisOrders.setCouponDeduction(thisOrders.getCouponDeduction().add(od.getItemsCouponDeduction()));
            thisOrders.setPayAmount(thisOrders.getPayAmount().subtract(od.getItemsCouponDeduction()));
        });
        thisOrders.setCouponNo(couponDTO.getCode());
        return this;
    }

    private OrderItems settingUserDiscountInfo(UserDiscountDTO userDiscountDTO, OrderItems items) {
        if (BigDecimal.ZERO.compareTo(items.getItemsActiveDeduction()) == 0) {
            log.info("\u65e0\u6d3b\u52a8\u6298\u6263\uff0c\u4f1a\u5458\u6298\u6263{}", (Object)userDiscountDTO.getDiscount());
            items.setUserDiscount(userDiscountDTO.getDiscount());
            BigDecimal yh = this.scale(items.getMarketPrice().multiply(new BigDecimal(items.getSanSaleQuantity())).multiply(BigDecimal.ONE.subtract(items.getUserDiscount())));
            BigDecimal yy = this.scale(items.getMarketPrice().multiply(new BigDecimal(items.getSanSaleQuantity())).multiply(items.getUserDiscount()));
            if (items.getItemsAmount().compareTo(yy) > -1) {
                items.setItemsUserDeduction(items.getItemsAmount().subtract(this.scale(yy)));
            } else {
                items.setItemsUserDeduction(BigDecimal.ZERO);
            }
            items.setItemsPayAmount(items.getItemsAmount().subtract(items.getItemsUserDeduction()));
            return items;
        }
        if (userDiscountDTO.getDiscountMethod().equals((Object)UserDiscountDTO.DiscountMethod.FOLD_UP_THE_FOLD)) {
            log.info("start \u6298\u4e0a\u6298");
            items.setUserDiscount(userDiscountDTO.getFoldUpDiscount());
            items.setItemsUserDeduction(this.scale(items.getItemsAmount().subtract(items.getItemsActiveDeduction()).multiply(BigDecimal.ONE.subtract(items.getUserDiscount()))));
            items.setItemsPayAmount(items.getItemsPayAmount().subtract(items.getItemsUserDeduction()));
        } else {
            log.info("start \u5c31\u4f4e\u539f\u5219");
            BigDecimal marketTotal = items.getMarketPrice().multiply(BigDecimal.valueOf(items.getSanSaleQuantity().intValue()));
            log.info("\u5e02\u573a\u603b\u4ef7\uff1a{}", (Object)marketTotal);
            BigDecimal userDiscountAmount = this.scale(marketTotal.multiply(userDiscountDTO.getDiscount()));
            log.info("\u4f1a\u5458\u6298\u6263\u540e\u552e\u4ef7:{}", (Object)userDiscountAmount);
            if (items.getItemsAmount().subtract(items.getItemsActiveDeduction()).compareTo(userDiscountAmount) >= 0) {
                log.info("\u8ba2\u5355\u660e\u7ec6\u4ef7\u683c{} - \u6d3b\u52a8\u62b5\u6263{} \u5927\u4e8e\u4f1a\u5458\u6298\u6263 {}", new Object[]{items.getItemsAmount(), items.getItemsActiveDeduction(), userDiscountAmount});
                items.setUserDiscount(userDiscountDTO.getDiscount());
                items.setItemsUserDeduction(items.getItemsAmount().subtract(userDiscountAmount));
                Orders thisOrders = this.getOrders();
                items.setItemsPayAmount(userDiscountAmount);
                items.setActiveDiscount(BigDecimal.ONE);
                items.setItemsActiveDeduction(BigDecimal.ZERO);
            }
        }
        return items;
    }

    private boolean isValidDiscountRange(BigDecimal goodsDiscountForMarket, BigDecimal discountMin, BigDecimal discountMax) {
        return goodsDiscountForMarket.compareTo(discountMin) >= 0 && goodsDiscountForMarket.compareTo(discountMax) <= 0;
    }

    public OrdersBuilder fromFreightInfo(FreightCalcResponse freightInfo) {
        Orders thisOrders = this.getOrders();
        thisOrders.setShippingFee(freightInfo.getFreightFee());
        thisOrders.setShippingDeduction(freightInfo.getFreightDeduction());
        return this;
    }

    public OrdersBuilder fromDiscount(List<Goods> discountInfo, UserDiscountDTO userDiscountDTO, RedisTemplate redisTemplate) {
        Orders thisOrders = this.getOrders();
        List orderItems = thisOrders.getItems();
        List activeGoodsIds = thisOrders.getActiveGoodsIds();
        for (OrderItems items : orderItems) {
            Goods discountGoodsInfo;
            boolean flag;
            if ((activeGoodsIds == null || activeGoodsIds.size() <= 1 || !activeGoodsIds.contains(items.getGoodsId())) && (flag = this.handleOrders((discountGoodsInfo = this.extractActiveDiscountInfo(items, discountInfo)).getDiscount(), items, thisOrders, userDiscountDTO))) continue;
        }
        OrderItems activeOrderItems = (OrderItems)redisTemplate.opsForValue().get((Object)"active_orderItems");
        if (activeOrderItems != null) {
            Goods discountGoodsInfo = this.extractActiveDiscountInfo(activeOrderItems, discountInfo);
            this.handleOrders(discountGoodsInfo.getDiscount(), activeOrderItems, thisOrders, userDiscountDTO);
            redisTemplate.delete((Object)"active_orderItems");
            log.info("\u4eceredis\u4e2d\u53d6\u51fa\u7684\u8ba2\u5355\u8be6\u60c5\u4e3a:{}", (Object)JSONObject.toJSONString((Object)activeOrderItems));
        }
        return this;
    }

    private boolean handleOrders(BigDecimal discount, OrderItems items, Orders thisOrders, UserDiscountDTO userDiscountDTO) {
        boolean flag = true;
        log.info("from active ...");
        if (discount.compareTo(BigDecimal.ONE) > 0) {
            throw new IllegalArgumentException("\u6298\u6263\u4fe1\u606f\u5f02\u5e38\uff1a" + discount);
        }
        if (BigDecimal.ONE.compareTo(discount) != 0) {
            items.setActiveDiscount(discount);
            items.setItemsActiveDeduction(this.scale(items.getItemsAmount().multiply(BigDecimal.ONE.subtract(items.getActiveDiscount()))));
            items.setItemsPayAmount(items.getItemsAmount().subtract(this.filterZero(items.getItemsActiveDeduction())));
            log.info("SKU_NO " + items.getGoodsSkuNo() + " \u6d3b\u52a8\u6298\u6263  {}, \u6d3b\u52a8\u62b5\u6263\u91d1\u989d {} ,\u5546\u54c1\u4ed8\u6b3e\u91d1\u989d {}", new Object[]{items.getActiveDiscount(), items.getItemsActiveDeduction(), items.getItemsPayAmount()});
        } else {
            items.setItemsActiveDeduction(BigDecimal.ZERO);
        }
        log.info("from user discount ...");
        BigDecimal goodsDiscountForMarket = items.getMarketPrice().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : items.getSalePrice().divide(items.getMarketPrice(), 2, 6);
        if (userDiscountDTO.getDiscountRange().equals((Object)UserDiscountDTO.DiscountRange.ALL)) {
            this.settingUserDiscountInfo(userDiscountDTO, items);
        } else {
            if (!this.isValidDiscountRange(goodsDiscountForMarket, userDiscountDTO.getDiscountMin(), userDiscountDTO.getDiscountMax())) {
                log.info(items.getGoodsName() + "\u7684\u6298\u6263\u4e3a" + goodsDiscountForMarket + ",\u4e0d\u5728\u6253\u6298\u8303\u56f4" + userDiscountDTO.getDiscountMin() + "~" + userDiscountDTO.getDiscountMax());
                flag = false;
                thisOrders.setPayAmount(thisOrders.getPayAmount().add(items.getItemsPayAmount()));
                thisOrders.setActiveDeduction(thisOrders.getActiveDeduction().add(items.getItemsActiveDeduction()));
                return flag;
            }
            this.settingUserDiscountInfo(userDiscountDTO, items);
        }
        log.info("=======\u4f1a\u5458\u4ed8\u6b3e\u91d1\u989d\u7ecf\u8fc7\u8ba1\u7b97\u540e\u5f97\u5230:{}", (Object)items.getItemsPayAmount());
        log.info(items.getGoodsSkuNo() + " \u4f1a\u5458\u6298\u6263  {}, \u4f1a\u5458\u62b5\u6263\u91d1\u989d {} ,\u5546\u54c1\u4ed8\u6b3e\u91d1\u989d {}", new Object[]{items.getUserDiscount(), items.getItemsUserDeduction(), items.getItemsPayAmount()});
        thisOrders.setUserDeduction(thisOrders.getUserDeduction().add(items.getItemsUserDeduction()));
        thisOrders.setPayAmount(thisOrders.getPayAmount().add(items.getItemsPayAmount()));
        thisOrders.setActiveDeduction(thisOrders.getActiveDeduction().add(items.getItemsActiveDeduction()));
        log.info("\u5f53\u524d\u8ba2\u5355\u5b9e\u9645\u652f\u4ed8\u91d1\u989d {}, \u4f1a\u5458\u62b5\u6263 {}, \u6d3b\u52a8\u62b5\u6263 {}", new Object[]{thisOrders.getPayAmount(), thisOrders.getUserDeduction(), thisOrders.getActiveDeduction()});
        return flag;
    }

    public OrdersBuilder fromSkuToCom(List<GoodsSkuDetail> dbSkuInfo) {
        Orders thisOrders = this.getOrders();
        List orderItems = thisOrders.getItems();
        for (OrderItems items : orderItems) {
            GoodsSkuDetail skuDetail = this.extractSkuInfo(items, dbSkuInfo);
            items.setGoodsId(skuDetail.getGoodsId());
            items.setGoodsName(skuDetail.getGoodsName());
            items.setGoodsImg(skuDetail.getSkuImg());
            items.setGoodsSkuNo(skuDetail.getSkuNo());
            items.setGoodsSkuName(skuDetail.getSpecNames());
            items.setMarketPrice(skuDetail.getMarketPrice());
            items.setSalePrice(skuDetail.getSalesPrice());
            items.setCommission(thisOrders.getEnabledCommission() != null && thisOrders.getEnabledCommission() != false ? skuDetail.getCommission() : BigDecimal.ZERO);
            items.setItemsAmount(items.getSalePrice().multiply(BigDecimal.valueOf(items.getSaleQuantity().intValue())));
            items.setItemsPayAmount(items.getItemsAmount());
            log.info(items.getGoodsSkuNo() + " \u5546\u54c1\u4ed8\u6b3e\u91d1\u989d {}", (Object)items.getItemsPayAmount());
            thisOrders.setOrderAmount(thisOrders.getOrderAmount().add(items.getItemsAmount()));
            thisOrders.setCommission(thisOrders.getCommission().add(items.getCommission()));
        }
        if (orderItems.size() == 1) {
            thisOrders.setOrderAmount(BigDecimal.ZERO);
        }
        log.info("\u7ec4\u5408\u6d3b\u52a8\u7684\u521d\u59cb\u8ba2\u5355\u91d1\u989d {}", (Object)thisOrders.getPayAmount());
        return this;
    }
}

