/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccountLogs;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccounts;
import com.wmeimob.fastboot.bizvane.mapper.UserCommissionAccountLogsMapper;
import com.wmeimob.fastboot.bizvane.mapper.UserCommissionAccountsMapper;
import com.wmeimob.fastboot.bizvane.service.UserCommissionAccountLogsService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.DateUtil;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserCommissionAccountLogServiceImpl
implements UserCommissionAccountLogsService {
    @Autowired
    private UserCommissionAccountLogsMapper userCommissionAccountLogsMapper;
    @Resource
    private UserCommissionService userCommissionService;
    @Autowired
    private UserCommissionAccountsMapper userCommissionAccountsMapper;

    public List<Orders> selectLowerOrderList(UserCommissionAccountLogs condition) {
        UserCommissionAccounts myAccount = (UserCommissionAccounts)this.userCommissionService.findById(condition.getUserNo());
        condition.setUserAccountId(myAccount.getId());
        return this.userCommissionAccountLogsMapper.selectCommissionLowerOrderList(condition);
    }

    public List<UserCommissionAccountLogs> findByCondition(UserCommissionAccountLogs condition) {
        return this.userCommissionAccountLogsMapper.selectLogByUserNo(condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserCommissionAccountLogs add(UserCommissionAccountLogs object) {
        String string = object.getUserNo().intern();
        synchronized (string) {
            InputValidator.checkEmpty((Object)object.getChangeAmount(), (String)"\u63d0\u73b0\u91d1\u989d");
            UserCommissionAccounts user = (UserCommissionAccounts)this.userCommissionService.findById(object.getUserNo());
            if (user.getAmount().compareTo(object.getChangeAmount()) < 0) {
                throw new CustomException("\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u4f59\u989d");
            }
            object.setAccountAmount(user.getAmount());
            user.setAmount(user.getAmount().subtract(object.getChangeAmount()));
            Date date = new Date();
            object.setUserAccountId(user.getId());
            object.setRecordType(Byte.valueOf((byte)0));
            object.setChangedAt(date);
            object.setGmtCreate(date);
            object.setWithdrawType(Byte.valueOf((byte)1));
            object.setChangeType("withdraw");
            object.setWithdrawNo(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)10));
            int result = this.userCommissionAccountLogsMapper.insertSelective((Object)object);
            if (result < 1) {
                throw new CustomException("\u7533\u8bf7\u63d0\u73b0\u5931\u8d25");
            }
            this.userCommissionAccountsMapper.updateByPrimaryKeySelective((Object)user);
            return object;
        }
    }
}

