/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.ReducePriceDto;
import com.wmeimob.fastboot.bizvane.dto.ReducePriceSkuDto;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service(value="marketActivityService")
public class MarketActivityServiceImpl
implements MarketActivityService {
    @Resource
    private MarketActivityMapper marketActivityMapper;
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public PageInfo<ReducePriceDto> queryReducePage(int pageNum, int pageSize) {
        PageInfo<MarketActivity> activitys = this.getActivityPage(pageNum, pageSize);
        return this.getActivitySkuResult(activitys);
    }

    public List<ReducePriceSkuDto> queryActivitySkuInfo(Integer merchantId, String goodsNo, String marketActivityNo) {
        MarketActivityGoods marketActivityGoods = new MarketActivityGoods();
        marketActivityGoods.setMarketActivityNo(marketActivityNo);
        List select = this.marketActivityGoodsMapper.select((Object)marketActivityGoods);
        List goodsSkuDetails = (List)this.chooseSkuByRule(select).get("goodsSku");
        marketActivityGoods = (MarketActivityGoods)this.chooseSkuByRule(select).get("marketActivityGoods");
        String skuNo = marketActivityGoods.getSkuNo();
        return this.obtainResultsWithFlag(goodsSkuDetails, skuNo);
    }

    private List<ReducePriceSkuDto> obtainResultsWithFlag(List<GoodsSkuDetail> goodsSkuDetails, String skuNo) {
        return goodsSkuDetails.stream().map(e -> {
            ReducePriceSkuDto rps = new ReducePriceSkuDto();
            rps.setStock(this.getActualStockByRedis((GoodsSkuDetail)e));
            rps.setSpecNames(e.getSpecNames());
            rps.setSkuPicUrl(e.getSkuImg());
            rps.setSpecIds(e.getSpecIds());
            if (e.getSkuNo().equals(skuNo)) {
                rps.setShowFlag(true);
            }
            return rps;
        }).collect(Collectors.toList());
    }

    private Integer getActualStockByRedis(GoodsSkuDetail e) {
        String freezeStock = (String)this.stringRedisTemplate.opsForValue().get((Object)("wechat_mall_reduce_price:" + e.getMerchantId() + ":" + e.getSkuNo()));
        int i = Integer.parseInt(freezeStock);
        return e.getStock() - i;
    }

    private PageInfo<ReducePriceDto> getActivitySkuResult(PageInfo<MarketActivity> activitys) {
        if (activitys != null && !CollectionUtils.isEmpty((Collection)activitys.getList())) {
            List collect = activitys.getList().stream().map(e -> {
                MarketActivityGoods marketActivityGoods = new MarketActivityGoods();
                marketActivityGoods.setMarketActivityNo(e.getActivityNo());
                List select = this.marketActivityGoodsMapper.select((Object)marketActivityGoods);
                MarketActivityGoods selectedOne = (MarketActivityGoods)this.chooseSkuByRule(select).get("marketActivityGoods");
                return this.activityAndSkuAdapt(selectedOne, (MarketActivity)e);
            }).collect(Collectors.toList());
            PageInfo reducePriceDtoPageInfo = new PageInfo(collect);
            BeanUtils.copyProperties(activitys, (Object)reducePriceDtoPageInfo);
            reducePriceDtoPageInfo.setList(collect);
            return reducePriceDtoPageInfo;
        }
        return null;
    }

    private ReducePriceDto activityAndSkuAdapt(MarketActivityGoods selectedOne, MarketActivity e) {
        ReducePriceDto reducePriceDto = new ReducePriceDto();
        GoodsSkuDetail goodsSkuDetail = this.getGoodsSku(selectedOne);
        reducePriceDto.setGoodsName(goodsSkuDetail.getGoodsName());
        reducePriceDto.setMinPrice(selectedOne.getAmount());
        reducePriceDto.setSalePrice(goodsSkuDetail.getSalesPrice());
        reducePriceDto.setMark("\u53d1\u8d77\u780d\u4ef7");
        return reducePriceDto;
    }

    private GoodsSkuDetail getGoodsSku(MarketActivityGoods selectedOne) {
        return this.goodsSkuDetailMapper.findByGoodsIdAndSkuNo(selectedOne.getId(), selectedOne.getSkuNo());
    }

    private Map<String, Object> chooseSkuByRule(List<MarketActivityGoods> select) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List collect = select.stream().map(e -> this.getGoodsSku((MarketActivityGoods)e)).collect(Collectors.toList());
        map.put("goodsSku", collect);
        GoodsSkuDetail goodsSkuDetail = collect.stream().min(Comparator.comparing(GoodsSkuDetail::getSalesPrice)).get();
        List<GoodsSkuDetail> collect1 = collect.stream().filter(e -> e.getSalesPrice().equals(goodsSkuDetail.getSalesPrice())).collect(Collectors.toList());
        if (collect1.size() > 1) {
            MarketActivityGoods marketActivityGoods = this.compareLowprice(collect1, select);
            map.put("marketActivityGoods", marketActivityGoods);
        }
        map.put("marketActivityGoods", select.get(0));
        return map;
    }

    private MarketActivityGoods compareLowprice(List<GoodsSkuDetail> collect, List<MarketActivityGoods> select) {
        ArrayList<MarketActivityGoods> result = new ArrayList<MarketActivityGoods>();
        for (GoodsSkuDetail goodsSkuDetail : collect) {
            for (MarketActivityGoods marketActivityGoods : select) {
                if (!goodsSkuDetail.getSkuNo().equals(marketActivityGoods.getSkuNo())) continue;
                result.add(marketActivityGoods);
            }
        }
        MarketActivityGoods marketActivityGoods = result.stream().min(Comparator.comparing(MarketActivityGoods::getAmount)).get();
        List collect1 = result.stream().filter(e -> e.getAmount().equals(marketActivityGoods.getAmount())).collect(Collectors.toList());
        if (collect1.size() > 1) {
            return (MarketActivityGoods)collect1.get(0);
        }
        return marketActivityGoods;
    }

    private PageInfo<MarketActivity> getActivityPage(int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Example example = new Example(MarketActivity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andCondition("order by activity_begin_time desc");
        List marketActivities = this.marketActivityMapper.selectByExample((Object)example);
        return new PageInfo(marketActivities);
    }
}

