/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.OrdersCountInfo;
import com.wmeimob.fastboot.bizvane.dto.OrdersQueryInfo;
import com.wmeimob.fastboot.bizvane.entity.Collect;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.CollectService;
import com.wmeimob.fastboot.bizvane.service.CommentsService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.util.InputValidator;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/center"})
@PreAuthorize(value="hasRole('USER')")
public class UserCenterController {
    private static final Logger log = LoggerFactory.getLogger(UserCenterController.class);
    @Resource
    private OrdersService ordersService;
    @Resource
    private RefundOrderService refundOrderService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersService;
    @Resource
    private CommentsService commentsService;
    @Resource
    private CollectService collectService;
    @Resource
    private UserService userService;

    @GetMapping(value={"/index"})
    public OrdersCountInfo index(@RequestHeader(value="merchantId") Integer merchantId) {
        User user = (User)SecurityContext.getUser();
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        InputValidator.checkEmpty((Object)user.getOpenid(), (String)"\u53c2\u6570");
        Orders orders = new Orders();
        orders.setWechatOpenid(user.getOpenid());
        orders.setMerchantId(merchantId);
        OrdersCountInfo ordersVo = this.ordersService.getCountOrders(orders);
        return ordersVo;
    }

    @GetMapping(value={"/order"})
    public PageInfo<Orders> getOrdersList(@RequestHeader(value="merchantId") Integer merchantId, Integer orderStatus) {
        User user = (User)SecurityContext.getUser();
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        InputValidator.checkEmpty((Object)user.getOpenid(), (String)"\u53c2\u6570");
        OrdersQueryInfo orders = new OrdersQueryInfo();
        orders.setMerchantId(merchantId);
        orders.setWechatOpenid(user.getOpenid());
        orders.setQueryStatus(orderStatus);
        orders.setUserNo(user.getUserNo());
        orders.setUserId(user.getUserId());
        PageContext.startPage();
        List getOrdersList = this.ordersService.getOrdersList(orders);
        return new PageInfo(getOrdersList);
    }

    @GetMapping(value={"/order/detail/{id}"})
    public Orders getOrdersDetail(@PathVariable(value="id") Integer id) {
        Orders orders = (Orders)this.commonOrdersService.findById(id);
        return orders;
    }

    @PostMapping(value={"/order/evaluate/{id}"})
    public void evaluateOrder(@PathVariable(value="id") Integer id, @RequestBody OrdersQueryInfo orders) {
        User user = (User)SecurityContext.getUser();
        User remoteUser = (User)this.userService.findOneByCondition((Serializable)user);
        this.commentsService.evaluateOrder(id, orders, remoteUser);
    }

    @PostMapping(value={"/order/refund/{itemId}"})
    public void refundOrder(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="itemId") Integer itemId, RefundOrder refundOrder) {
        refundOrder.setMerchantId(merchantId);
        this.ordersService.refundOrder(itemId, refundOrder);
    }

    @GetMapping(value={"refundOrder"})
    public List getRefundOrderList(@RequestHeader(value="merchantId") Integer merchantId) {
        User user = (User)SecurityContext.getUser();
        RefundOrder refundOrder = new RefundOrder();
        refundOrder.setMerchantId(merchantId);
        refundOrder.setUserId(user.getUserId());
        return this.refundOrderService.findByCondition((Serializable)refundOrder);
    }

    @GetMapping(value={"/refundOrder/detail/{id}"})
    public RefundOrder getRefundOrderDetail(@PathVariable(value="id") Integer id) {
        RefundOrder orders = (RefundOrder)this.refundOrderService.findById(id);
        return orders;
    }

    @GetMapping(value={"/refundOrder/item/{id}"})
    public RefundOrder findById(@PathVariable(value="id") Integer id) {
        return this.refundOrderService.findRefundOrderById(id);
    }

    @GetMapping(value={"collect"})
    public List getCollectList(@RequestHeader(value="merchantId") Integer merchantId) {
        User user = (User)SecurityContext.getUser();
        Collect collect = new Collect();
        collect.setMerchantId(merchantId);
        collect.setWechatOpenid(user.getOpenid());
        return this.collectService.findByCondition((Serializable)collect);
    }

    @DeleteMapping(value={"collect"})
    public void updateCollect(@RequestBody Integer[] idArr) {
        this.collectService.delete(idArr);
    }

    @PostMapping(value={"collect"})
    public void updateCollect(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Collect collect) {
        User user = (User)SecurityContext.getUser();
        collect.setMerchantId(merchantId);
        collect.setWechatOpenid(user.getOpenid());
        this.collectService.add((Serializable)collect);
    }
}

