/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.mzlion.core.json.gson.JsonUtil;
import com.wmeimob.fastboot.bizvane.dto.FriendsReduceDto;
import com.wmeimob.fastboot.bizvane.dto.MyReducePriceDto;
import com.wmeimob.fastboot.bizvane.dto.ReduceHelpResponse;
import com.wmeimob.fastboot.bizvane.dto.ReducePriceDto;
import com.wmeimob.fastboot.bizvane.dto.ReducePriceSkuDto;
import com.wmeimob.fastboot.bizvane.dto.ReduceProductDto;
import com.wmeimob.fastboot.bizvane.entity.BargainPlayers;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.BargainPlayersService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityGoodsService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityOrdersService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reducePrice"})
@PreAuthorize(value="hasRole('USER')")
public class ReducePriceController {
    private static final Logger log = LoggerFactory.getLogger(ReducePriceController.class);
    @Autowired
    private MarketActivityService marketActivityService;
    @Autowired
    private MarketActivityGoodsService marketActivityGoodsService;
    @Autowired
    private MarketActivityOrdersService marketActivityOrdersService;
    @Autowired
    private BargainPlayersService bargainPlayersService;

    @GetMapping(value={"/getProductInfo"})
    @ResponseBody
    public ReduceProductDto getProductInfo(@RequestParam(value="mechantId") Integer merchantId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="marketActivityNo") String marketActivityNo, @RequestParam(value="skuNo") String skuNo, @RequestParam(value="activitySign") String activitySign) {
        User user = (User)SecurityContext.getUser();
        MarketActivityGoods mag = new MarketActivityGoods();
        mag.setMarketActivityNo(marketActivityNo);
        mag.setGoodsNo(goodsNo);
        mag.setSkuNo(skuNo);
        return this.marketActivityGoodsService.queryActivityGoodsInfo(mag, activitySign, merchantId);
    }

    public static void main1(String[] args) {
        ArrayList<ReducePriceSkuDto> list = new ArrayList<ReducePriceSkuDto>();
        ReducePriceSkuDto rs = new ReducePriceSkuDto();
        rs.setSpecIds("19,26,30");
        rs.setSkuPicUrl("https://qi.test.bizvane.cn/mall/96/jpg/2018-11-5/4446384f-374f-b32e-6699-1544f8c95e0f.jpg");
        rs.setShowFlag(true);
        rs.setSpecNames("\u7ea2,M,256GB");
        rs.setStock(Integer.valueOf(10));
        list.add(rs);
        ReduceProductDto dto = new ReduceProductDto();
        dto.setReducePriceSkuDtos(list);
        dto.setAlreadyReduceNum(Integer.valueOf(20));
        dto.setGoodsName("\u5927\u72d7");
        dto.setAlreadyReduceNum(Integer.valueOf(10));
        dto.setCanReducePrice("\u8fd8\u80fd\u780dxxxx\u5143");
        dto.setReduceRule("dfsf");
        dto.setGoodsNo("432323");
        dto.setMark("342342");
        dto.setMerchantId("435ddsf");
        dto.setPicUrl("3243");
        dto.setMinPrice(new BigDecimal("3423"));
        dto.setSalePrice(new BigDecimal("23"));
        System.out.println(JsonUtil.toJson((Object)dto));
    }

    @GetMapping(value={"/queryActivitySkusInfo"})
    @ResponseBody
    public List<ReducePriceSkuDto> queryActivitySkusInfo(@RequestParam(value="mechantId") Integer merchantId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="marketActivityNo") String marketActivityNo) {
        User user = (User)SecurityContext.getUser();
        return this.marketActivityService.queryActivitySkuInfo(merchantId, goodsNo, marketActivityNo);
    }

    public static void main2(String[] args) {
        ArrayList<ReducePriceSkuDto> list = new ArrayList<ReducePriceSkuDto>();
        ReducePriceSkuDto dto = new ReducePriceSkuDto();
        dto.setStock(Integer.valueOf(10));
        dto.setSpecNames("32dfs");
        dto.setSkuPicUrl("rwrewrew");
        dto.setSpecIds("r3423424");
        list.add(dto);
        System.out.println(JsonUtil.toJson((Object)dto));
    }

    @GetMapping(value={"/queryReduce"})
    @ResponseBody
    public PageInfo<ReducePriceDto> queryReduce(int pageNum, int pageSize) {
        User user = (User)SecurityContext.getUser();
        return this.marketActivityService.queryReducePage(pageNum, pageSize);
    }

    public static void main3(String[] args) {
        ArrayList<ReducePriceDto> list = new ArrayList<ReducePriceDto>();
        ReducePriceDto aqs = new ReducePriceDto();
        aqs.setMark("\u7eff,L,64GB");
        aqs.setSalePrice(new BigDecimal("532"));
        aqs.setGoodsName("\u7535\u8bdd");
        aqs.setGoodsNo("321432");
        aqs.setMinPrice(new BigDecimal("23"));
        aqs.setMerchantId("42342");
        aqs.setPicUrl("http://3243.jpg");
        list.add(aqs);
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setTotal(100L);
        pageInfo.setPageSize(20);
        pageInfo.setPageNum(10);
        System.out.println(JsonUtil.toJson((Object)pageInfo));
    }

    @GetMapping(value={"/queryMyReduce"})
    @ResponseBody
    public PageInfo<MyReducePriceDto> queryMyReduce(int pageNum, int pageSize) {
        User user = (User)SecurityContext.getUser();
        Date currentTime = new Date();
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setLaunchUserNo(user.getUserNo());
        return this.marketActivityOrdersService.queryMyReduce(currentTime, mao, pageNum, pageSize);
    }

    public static void main4(String[] args) {
        ArrayList<MyReducePriceDto> list = new ArrayList<MyReducePriceDto>();
        MyReducePriceDto aqs = new MyReducePriceDto();
        aqs.setMark("\u7eff,L,64GB");
        aqs.setSalePrice(new BigDecimal("532"));
        aqs.setGoodsName("\u7535\u8bdd");
        aqs.setGoodsNo("321432");
        aqs.setMinPrice(new BigDecimal("23"));
        aqs.setMerchantId("42342");
        aqs.setPicUrl("http://3243.jpg");
        aqs.setAlreadyReduce(new BigDecimal("2323").toString());
        list.add(aqs);
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setTotal(100L);
        pageInfo.setPageSize(20);
        pageInfo.setPageNum(10);
        System.out.println(JsonUtil.toJson((Object)pageInfo));
    }

    @GetMapping(value={"/initActivity"})
    @ResponseBody
    public RestResult addActivity(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        User user = (User)SecurityContext.getUser();
        return null;
    }

    public static void main6(String[] args) {
        System.out.println(JsonUtil.toJson((Object)0));
    }

    @GetMapping(value={"/addActivityAndOrders"})
    @ResponseBody
    public RestResult addActivityAndOrders(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        User user = (User)SecurityContext.getUser();
        return null;
    }

    @PutMapping(value={"/activityOrders"})
    @ResponseBody
    public RestResult reAddActivity(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        return null;
    }

    @GetMapping(value={"getWithFriendsInfo"})
    @ResponseBody
    public FriendsReduceDto withFriends(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        return null;
    }

    public static void main(String[] args) {
        ArrayList<BargainPlayers> list = new ArrayList<BargainPlayers>();
        BargainPlayers aqs = new BargainPlayers();
        FriendsReduceDto dto = new FriendsReduceDto();
        dto.setAssistsLists(list);
        list.add(aqs);
        dto.setMark("\u7eff,L,64GB");
        dto.setSalePrice(new BigDecimal("532"));
        dto.setGoodsName("\u7535\u8bdd");
        dto.setGoodsNo("321432");
        dto.setMinPrice(new BigDecimal("23"));
        dto.setMerchantId("42342");
        dto.setPicUrl("http://3243.jpg");
        dto.setAlreadyReduce(new BigDecimal("2323").toString());
        System.out.println(JsonUtil.toJson((Object)dto));
    }

    @GetMapping(value={"getHelpFriendsInfo"})
    @ResponseBody
    public FriendsReduceDto helpFriends(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        return null;
    }

    public static void main8(String[] args) {
        ArrayList<MyReducePriceDto> list = new ArrayList<MyReducePriceDto>();
        MyReducePriceDto aqs = new MyReducePriceDto();
        aqs.setMark("\u7eff,L,64GB");
        aqs.setSalePrice(new BigDecimal("532"));
        aqs.setGoodsName("\u7535\u8bdd");
        aqs.setGoodsNo("321432");
        aqs.setMinPrice(new BigDecimal("23"));
        aqs.setMerchantId("42342");
        aqs.setPicUrl("http://3243.jpg");
        aqs.setAlreadyReduce(new BigDecimal("2323").toString());
        list.add(aqs);
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setTotal(100L);
        pageInfo.setPageSize(20);
        pageInfo.setPageNum(10);
        System.out.println(JsonUtil.toJson((Object)pageInfo));
    }

    @GetMapping(value={"helpReducePrice"})
    @ResponseBody
    public ReduceHelpResponse helpReducePrice(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="launchUserNo") String launchUserNo) {
        User user = (User)SecurityContext.getUser();
        return this.bargainPlayersService.handleHelpFriends(merchantId, goodsNo, user, launchUserNo);
    }

    public static void main9(String[] args) {
        ArrayList<MyReducePriceDto> list = new ArrayList<MyReducePriceDto>();
        MyReducePriceDto aqs = new MyReducePriceDto();
        aqs.setMark("\u7eff,L,64GB");
        aqs.setSalePrice(new BigDecimal("532"));
        aqs.setGoodsName("\u7535\u8bdd");
        aqs.setGoodsNo("321432");
        aqs.setMinPrice(new BigDecimal("23"));
        aqs.setMerchantId("42342");
        aqs.setPicUrl("http://3243.jpg");
        aqs.setAlreadyReduce(new BigDecimal("2323").toString());
        list.add(aqs);
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setTotal(100L);
        pageInfo.setPageSize(20);
        pageInfo.setPageNum(10);
        System.out.println(JsonUtil.toJson((Object)pageInfo));
    }
}

