/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.MarketOrdersGoodsDto;
import com.wmeimob.fastboot.bizvane.dto.MyReducePriceDto;
import com.wmeimob.fastboot.bizvane.entity.BargainPlayers;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.mapper.BargainPlayersMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.bizvane.service.MarketActivityOrdersService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="marketActivityOrdersService")
public class MarketActivityOrdersServiceImpl
implements MarketActivityOrdersService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityOrdersServiceImpl.class);
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    @Autowired
    private MarketActivity marketActivity;
    @Autowired
    private BargainPlayersMapper bargainPlayersMapper;

    public PageInfo<MyReducePriceDto> queryMyReduce(Date currentTime, MarketActivityOrders mao, int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List mogt = this.marketActivityOrdersMapper.selectAvailbleOrdersByRule(mao.getLaunchUserNo());
        PageInfo pageInfo = new PageInfo(mogt);
        return this.chooseMyReduceByRule(currentTime, pageInfo);
    }

    private PageInfo<MyReducePriceDto> chooseMyReduceByRule(Date currentTime, PageInfo<MarketOrdersGoodsDto> pageInfo) {
        if (pageInfo == null && CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return null;
        }
        List list = pageInfo.getList();
        ArrayList<MyReducePriceDto> result = new ArrayList<MyReducePriceDto>();
        for (MarketOrdersGoodsDto mao : list) {
            int step = this.chooseStep(currentTime, mao);
            result.add(this.getMyReduceResult(mao, step, currentTime));
        }
        PageInfo pageResult = new PageInfo();
        BeanUtils.copyProperties(pageInfo, (Object)pageResult);
        pageResult.setList(result);
        return pageResult;
    }

    private MyReducePriceDto getMyReduceResult(MarketOrdersGoodsDto mao, int step, Date currentTime) {
        MyReducePriceDto result = new MyReducePriceDto();
        BargainPlayers bp = new BargainPlayers();
        bp.setActivityOrdersNo(mao.getActivityOrdersNo());
        List select = this.bargainPlayersMapper.select((Object)bp);
        BigDecimal reduceTotalAmount = select.stream().map(e -> e.getAmount()).reduce(BigDecimal.ZERO, (x, y) -> y.add((BigDecimal)x));
        result.setAlreadyReduce("\u5df2" + reduceTotalAmount + "\u5143");
        Date date = DateUtils.addDays((Date)currentTime, (int)(mao.getActivityTermValidity() / -1));
        if (step == 1) {
            result.setMark("\u7ee7\u7eed\u780d\u4ef7");
            result.setRemainingTime("");
        } else if (step == 2) {
            result.setMark("\u91cd\u65b0\u53d1\u8d77");
            result.setRemainingTime(null);
            result.setRemainingTime("\u780d\u4ef7\u5df2\u8fc7\u671f");
        } else {
            result.setMark("\u652f\u4ed8\u5269\u4f59\u4ef7\u683c");
            result.setRemainingTime("\u8bf7\u5728");
            result.setAlreadyReduce("\u5df2" + reduceTotalAmount + "\u5143\u606d\u559c\u5df2\u780d\u5230\u6700\u4f4e\u4ef7");
        }
        return result;
    }

    private int chooseStep(Date currentTime, MarketOrdersGoodsDto mao) {
        if (this.verifyCanPay(mao)) {
            return 3;
        }
        if (this.verifyTime(mao, currentTime)) {
            return 2;
        }
        return 1;
    }

    private boolean verifyCanPay(MarketOrdersGoodsDto mao) {
        BargainPlayers bp = new BargainPlayers();
        bp.setActivityOrdersNo(mao.getActivityOrdersNo());
        List select = this.bargainPlayersMapper.select((Object)bp);
        if (select.size() >= mao.getActivityPersonNum()) {
            BigDecimal reduceTotalAmount = select.stream().map(e -> e.getAmount()).reduce(BigDecimal.ZERO, (x, y) -> y.add((BigDecimal)x));
            MarketActivityGoods mag = new MarketActivityGoods();
            mag.setSkuNo(mao.getGoodsSkuNo());
            mag = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOne((Object)mag);
            if (reduceTotalAmount.compareTo(mag.getAmount()) == 0) {
                return true;
            }
            throw new RuntimeException("\u5f85\u652f\u4ed8\uff1a\u780d\u4ef7\u4eba\u6570\u5df2\u6ee1\uff0c\u4ef7\u683c\u5f02\u5e38");
        }
        return false;
    }

    private boolean verifyTime(MarketOrdersGoodsDto mao, Date currentTime) {
        return !DateUtils.addHours((Date)mao.getGmtCreate(), (int)mao.getActivityTermValidity()).before(currentTime);
    }
}

