/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.StringUtils;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.dto.FreightCalcResponse;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.bizvane.service.CouponService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import me.hao0.wepay.model.pay.JsPayResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"orders"})
@PreAuthorize(value="hasRole('USER')")
public class OrdersController {
    private static final Logger log = LoggerFactory.getLogger(OrdersController.class);
    @Resource
    private OrdersService ordersService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersServiceImpl;
    @Resource
    private UserService userService;
    @Resource
    private CouponService couponService;
    @Resource
    private ActivityService activityService;
    @Resource
    private UserCommissionService userCommissionService;
    @Resource
    private OrdersServiceImpl ordersServiceImpl;

    @PostMapping(value={"pay-confirm"})
    public Orders payConfirm(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders createObject) {
        log.info("POST...method:pay-confirm....params===>{}", (Object)JSONObject.toJSONString((Object)createObject));
        User user = (User)SecurityContext.getUser();
        createObject.setUserId(user.getUserId());
        createObject.setUserNo(user.getUserNo());
        createObject.setWechatUnionId(user.getUnionid());
        createObject.setMerchantId(merchantId);
        return this.ordersService.payConfirm(createObject);
    }

    @PostMapping
    public Orders add(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders createObject) {
        User user = (User)SecurityContext.getUser();
        User queryUser = (User)this.userService.findOneByCondition((Serializable)user);
        createObject.setWechatOpenid(user.getOpenid());
        createObject.setUserNo(user.getUserNo());
        createObject.setMerchantId(merchantId);
        createObject.setUserId(user.getUserId());
        createObject.setUserName(queryUser.getFullName());
        createObject.setAppid(appid);
        Boolean parentState = this.userCommissionService.findParentState(queryUser.getUserNo());
        createObject.setEnabledCommission(parentState);
        createObject.setWechatUnionId(queryUser.getUnionid());
        this.ordersService.add((Serializable)createObject);
        return createObject;
    }

    @PostMapping(value={"freight"})
    public FreightCalcResponse getFreight(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders orders) {
        log.info("Get Freight From Orders {}", (Object)JSONObject.toJSONString((Object)orders));
        User user = (User)SecurityContext.getUser();
        orders.setUserNo(user.getUserNo());
        orders.setUserId(user.getUserId());
        orders.setMerchantId(merchantId);
        orders.setWechatUnionId(user.getUnionid());
        Orders od = this.ordersService.payConfirm(orders);
        od.setShippingProvince(this.filterRegionName(orders.getShippingProvince(), "\u7701"));
        od.setShippingCity(this.filterRegionName(orders.getShippingCity(), "\u5e02"));
        od.setShippingDistrict(this.filterRegionName(orders.getShippingDistrict(), "\u533a"));
        return this.ordersService.getFreight(od);
    }

    private String filterRegionName(String name, String filter) {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        int filterId = name.lastIndexOf(filter);
        if (filterId != -1) {
            return name.substring(0, filterId);
        }
        return name;
    }

    @GetMapping(value={"{id}"})
    public Orders getOrdersById(@PathVariable(value="id") Integer id) {
        User user = (User)SecurityContext.getUser();
        Orders orders = (Orders)this.commonOrdersServiceImpl.findById(id);
        Assert.notNull((Object)orders, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        if (!orders.getUserNo().equals(user.getUserNo())) {
            throw new IllegalArgumentException("\u8ba2\u5355\u672a\u627e\u5230");
        }
        return orders;
    }

    @DeleteMapping(value={"{id}"})
    public void deleteOrders(@PathVariable Integer id) {
        Orders od = this.getOrdersById(id);
        this.ordersService.delete(od.getId());
    }

    @PostMapping(value={"amount"})
    public Orders calumniateByCoupons(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders createObject) {
        createObject.setMerchantId(merchantId);
        User user = (User)SecurityContext.getUser();
        createObject.setUserNo(user.getUserNo());
        createObject.setMerchantId(merchantId);
        createObject.setUserId(user.getUserId());
        createObject.setAppid(appid);
        createObject.setWechatUnionId(user.getUnionid());
        CouponDTO couponDTO = (CouponDTO)this.couponService.findById(Integer.valueOf(createObject.getCouponNo()));
        Orders calcByCoupon = this.ordersService.calcOrdersByCoupons(couponDTO, createObject);
        return calcByCoupon;
    }

    @GetMapping(value={"active-goods"})
    public List<Goods> getActiveGoods(@RequestHeader(value="merchantId") Integer merchantId, BigDecimal amount) {
        return this.activityService.queryCurrentGiftGoodsByAmount(merchantId, amount);
    }

    @PutMapping(value={"confirm"})
    public void updateOrdersToConfirm(Integer ordersId) {
        User user = (User)SecurityContext.getUser();
        Orders orders = new Orders();
        orders.setUserId(user.getUserId());
        orders.setId(ordersId);
        this.commonOrdersServiceImpl.confirm(orders);
    }

    @PostMapping(value={"close"})
    public void close(@RequestHeader(value="appid") String appid, Integer id) {
        User user = (User)SecurityContext.getUser();
        this.ordersService.cancel(appid, user.getUserId(), id);
    }

    @GetMapping(value={"payment"})
    public JsPayResponse getJspayResponse(@RequestHeader(value="appid") String appid, Integer ordersId) {
        JsPayResponse jsPayResponse = this.ordersService.payment(ordersId, appid);
        log.info("\u652f\u4ed8\u7b7e\u540d\u8fd4\u56de===>{}", (Object)JSONObject.toJSONString((Object)jsPayResponse));
        return jsPayResponse;
    }

    @GetMapping(value={"getUserIntegral"})
    public Integer getUserIntegral(@RequestParam(value="userNo") String userNo) {
        log.info("\u83b7\u53d6\u4f1a\u5458\u79ef\u5206\u4f59\u989d");
        return this.ordersServiceImpl.getUserIntegral(userNo);
    }

    @GetMapping(value={"getIntegralProportion"})
    public BigDecimal getIntegralProportion(@RequestParam(value="userNo") String userNo) {
        log.info("\u83b7\u53d6\u79ef\u5206\u5151\u6362\u6bd4\u4f8b");
        return this.ordersServiceImpl.getIntegralProportion(userNo);
    }

    @GetMapping(value={"getUserBalance"})
    public BigDecimal getUserBalance(@RequestParam(value="userNo") String userNo) {
        log.info("\u83b7\u53d6\u4f1a\u5458\u5361\u4f59\u989d");
        return this.ordersServiceImpl.getUserBalance(userNo);
    }

    @GetMapping(value={"wscConsumeIntegralChange"})
    public RestResult wscConsumeIntegralChange(@RequestParam(value="userNo") String memberCode, @RequestParam(value="integral") Integer integral, @RequestParam(value="orderNo") String orderNo) {
        log.info("\u5fae\u5546\u57ce\u6263\u51cf\u79ef\u5206");
        return this.ordersServiceImpl.wscConsumeIntegralChange(memberCode, integral, orderNo);
    }

    @GetMapping(value={"wscConsumeBalance"})
    public RestResult wscConsumeBalance(@RequestParam(value="userNo") String memberCode, @RequestParam(value="balance") BigDecimal balance, @RequestParam(value="orderNo") String orderNo) {
        log.info("\u5fae\u5546\u57ce\u6263\u51cf\u4f59\u989d");
        return this.ordersServiceImpl.wscConsumeBalance(memberCode, balance, orderNo);
    }
}

