/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.dto.GoodsStockChangeResponseDTO;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.RegionMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class GoodsSkuDetailServiceImpl
implements GoodsSkuDetailService {
    @Resource
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Resource
    private RegionMapper regionMapper;

    public GoodsSkuDetail findOneByCondition(GoodsSkuDetail condition) {
        this.checkQueryParam(condition);
        Example example = new Example(GoodsSkuDetail.class);
        example.createCriteria().andEqualTo("goodsId", (Object)condition.getGoodsId()).andEqualTo("skuNo", (Object)condition.getSkuNo());
        return (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOneByExample((Object)example);
    }

    public List<GoodsSkuDetail> findByCondition(List<GoodsSkuDetail> conditions) {
        Example example = new Example(GoodsSkuDetail.class);
        if (conditions.isEmpty()) {
            return new ArrayList<GoodsSkuDetail>();
        }
        for (GoodsSkuDetail condition : conditions) {
            this.checkQueryParam(condition);
            example.or(example.createCriteria().andEqualTo("goodsId", (Object)condition.getGoodsId()).andEqualTo("skuNo", (Object)condition.getSkuNo()).andEqualTo("isEnabled", (Object)true));
        }
        return this.goodsSkuDetailMapper.selectByExample((Object)example);
    }

    private void checkQueryParam(GoodsSkuDetail condition) {
        InputValidator.checkNull((Object)condition.getGoodsId(), (String)"\u5546\u54c1ID");
        InputValidator.checkEmpty((Object)condition.getSkuNo(), (String)"\u5546\u54c1\u89c4\u683c");
    }

    public List<GoodsStockChangeResponseDTO> inventoryReduction(List<GoodsSkuDetail> skuInfo) {
        ArrayList<GoodsStockChangeResponseDTO> responseDTOList = new ArrayList<GoodsStockChangeResponseDTO>();
        for (GoodsSkuDetail skuDetail : skuInfo) {
            int result = this.goodsSkuDetailMapper.inventoryReduction(skuDetail);
            if (result != 0) continue;
            responseDTOList.add(GoodsStockChangeResponseDTO.builder().goodsId(skuDetail.getGoodsId()).goodsName(skuDetail.getGoodsName()).skuNo(skuDetail.getSkuNo()).count(skuDetail.getStock()).failReason("\u5e93\u5b58\u4e0d\u8db3").build());
        }
        return responseDTOList;
    }

    public void incrementSales(List<GoodsSkuDetail> collect) {
        this.goodsSkuDetailMapper.incrementSales(collect);
    }
}

