/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.entity.UserAddress;
import com.wmeimob.fastboot.bizvane.service.UserAddressService;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"user/address"})
public class UserAddressController {
    @Resource
    private UserAddressService userAddressService;

    @PostMapping
    public void add(@RequestBody UserAddress userAddress) {
        this.userAddressService.add((Serializable)this.fillUserId(userAddress));
    }

    private UserAddress fillUserId(UserAddress userAddress) {
        SecurityContext.getUser();
        User user = (User)SecurityContext.getUser();
        userAddress.setUserId(user.getUserId());
        return userAddress;
    }

    @PutMapping
    public void update(@RequestBody UserAddress userAddress) {
        this.userAddressService.update((Serializable)this.fillUserId(userAddress));
    }

    @GetMapping
    public List<UserAddress> list(UserAddress userAddress) {
        return this.userAddressService.findByCondition((Serializable)this.fillUserId(userAddress));
    }

    @DeleteMapping(value={"{id}"})
    public void delete(@PathVariable Integer id) {
        this.userAddressService.delete(id, (Serializable)this.fillUserId(new UserAddress()));
    }

    @GetMapping(value={"default"})
    public UserAddress getUserDefault() {
        return this.userAddressService.queryDefault(this.fillUserId(new UserAddress()));
    }
}

