/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.KafkaTrack;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"test"})
public class TestController {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private OrdersServiceImpl ordersService;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersServiceImpl;

    @PostMapping(value={"/get"})
    public List<Goods> getGoodsPros(@RequestBody List<Goods> queryDiscountGoods) {
        List list = this.activityService.queryDiscountByShopCartGoods(Integer.valueOf(96), queryDiscountGoods);
        return list;
    }

    @PostMapping(value={"/haha"})
    public Orders payConfirm(@RequestBody Orders payOrders) {
        return this.ordersService.payConfirm(payOrders);
    }

    @PostMapping(value={"/haha1"})
    public List<Goods> goods(@RequestParam(value="merchantId") Integer merchantId, @RequestParam(value="amount") BigDecimal amount) {
        return this.activityService.queryCurrentGiftGoodsByAmount(merchantId, amount);
    }

    @GetMapping(value={"/testGetUserBalance"})
    public BigDecimal getUserBalance(@RequestParam(value="memberCode") String memberCode) {
        return this.bizvaneInterface.getUserBalance(memberCode);
    }

    @GetMapping(value={"/testGetIntegralProportion"})
    public BigDecimal getIntegralProportion(@RequestParam(value="memberCode") String memberCode) {
        return this.bizvaneInterface.getIntegralProportion(memberCode);
    }

    @GetMapping(value={"/testGetUserIntegral"})
    public Integer getUserIntegral(@RequestParam(value="memberCode") String memberCode) {
        return this.bizvaneInterface.getUserIntegral(memberCode);
    }

    @PostMapping(value={"getKafka"})
    public RestResult getKafka(@RequestBody KafkaTrack kafkaTrack) {
        kafkaTrack.setAppType("0");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        kafkaTrack.setCreateTime(sdf.format(new Date()));
        return this.bizvaneInterface.kafkaTrack(kafkaTrack);
    }

    @GetMapping(value={"/testBalance"})
    public RestResult balance(@RequestParam(value="memberCode") String memberCode, @RequestParam(value="balance") BigDecimal balance, @RequestParam(value="code") int code) {
        return this.bizvaneInterface.operationBalance(memberCode, balance, code, "www");
    }

    @GetMapping(value={"/testIntegral"})
    public RestResult integral(@RequestParam(value="memberCode") String memberCode, @RequestParam(value="integral") Integer integral, @RequestParam(value="code") int code) {
        return this.bizvaneInterface.operationIntegral(memberCode, integral, code, "222");
    }

    @PostMapping(value={"/haha2"})
    public Orders haha2(@RequestBody Orders orders) {
        return this.ordersService.add(orders);
    }

    @GetMapping(value={"/haha3"})
    public Orders haha3(@RequestParam(value="id") Integer id) {
        return (Orders)this.commonOrdersServiceImpl.findById(id);
    }
}

