/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.FriendsReduceDto;
import com.wmeimob.fastboot.bizvane.dto.MyReducePriceDto;
import com.wmeimob.fastboot.bizvane.dto.ReduceHelpResponse;
import com.wmeimob.fastboot.bizvane.dto.ReducePriceDto;
import com.wmeimob.fastboot.bizvane.dto.ReducePriceSkuDto;
import com.wmeimob.fastboot.bizvane.dto.ReduceProductDto;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.MarketActivityGoodsService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityOrdersService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reducePrice"})
@PreAuthorize(value="hasRole('USER')")
public class ReducePriceController {
    private static final Logger log = LoggerFactory.getLogger(ReducePriceController.class);
    @Autowired
    private MarketActivityService marketActivityService;
    @Autowired
    private MarketActivityGoodsService marketActivityGoodsService;
    @Autowired
    private MarketActivityOrdersService marketActivityOrdersService;

    @GetMapping(value={"/getProductInfo"})
    @ResponseBody
    public ReduceProductDto getProductInfo(@RequestParam(value="mechantId") Integer merchantId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="marketActivityNo") String marketActivityNo, @RequestParam(value="skuNo") String skuNo, @RequestParam(value="activitySign") String activitySign) {
        User user = (User)SecurityContext.getUser();
        if (user != null) {
            MarketActivityGoods mag = new MarketActivityGoods();
            mag.setMarketActivityNo(marketActivityNo);
            mag.setGoodsNo(goodsNo);
            mag.setSkuNo(skuNo);
            return this.marketActivityGoodsService.queryActivityGoodsInfo(mag, activitySign, merchantId);
        }
        return null;
    }

    @GetMapping(value={"/queryActivitySkuInfo"})
    @ResponseBody
    public ReducePriceSkuDto queryActivitySkuInfo(@RequestParam(value="mechantId") Integer merchantId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="marketActivityNo") String marketActivityNo) {
        User user = (User)SecurityContext.getUser();
        if (user != null) {
            return null;
        }
        return null;
    }

    @GetMapping(value={"/queryReduce"})
    @ResponseBody
    public PageInfo<ReducePriceDto> queryReduce(int pageNum, int pageSize) {
        User user = (User)SecurityContext.getUser();
        if (user != null) {
            return this.marketActivityService.queryReducePage(pageNum, pageSize);
        }
        return null;
    }

    @GetMapping(value={"/queryMyReduce"})
    @ResponseBody
    public List<MyReducePriceDto> queryMyReduce() {
        User user = (User)SecurityContext.getUser();
        if (user != null) {
            Date currentTime = new Date();
            MarketActivityOrders mao = new MarketActivityOrders();
            mao.setLaunchUserNo(user.getUserNo());
            return this.marketActivityOrdersService.queryMyReduce(currentTime, mao);
        }
        return null;
    }

    @GetMapping(value={"/initActivity"})
    @ResponseBody
    public RestResult addActivity(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        User user = (User)SecurityContext.getUser();
        return null;
    }

    @GetMapping(value={"/addActivityAndOrders"})
    @ResponseBody
    public RestResult addActivityAndOrders(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        User user = (User)SecurityContext.getUser();
        return null;
    }

    @PutMapping(value={"/activityOrders"})
    @ResponseBody
    public RestResult reAddActivity(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        return null;
    }

    @GetMapping(value={"getWithFriendsInfo"})
    @ResponseBody
    public FriendsReduceDto withFriends(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        return null;
    }

    @GetMapping(value={"getHelpFriendsInfo"})
    @ResponseBody
    public FriendsReduceDto helpFriends(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        return null;
    }

    @GetMapping(value={"helpReducePrice"})
    @ResponseBody
    public ReduceHelpResponse helpReducePrice(@RequestParam(value="merchantId") String merchantId, @RequestParam(value="goodsNo") String goodsNo) {
        return null;
    }
}

