/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.Collect;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropValueCustom;
import com.wmeimob.fastboot.bizvane.entity.IndexSubjectImg;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.CollectService;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.GoodsClassifyService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.HotGoodsService;
import com.wmeimob.fastboot.bizvane.service.IndexSubjectService;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.common.entity.RichText;
import com.wmeimob.fastboot.starter.common.service.RichTextService;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.util.InputValidator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mall"})
public class MallController {
    private static final Logger log = LoggerFactory.getLogger(MallController.class);
    @Resource
    private IndexSubjectService indexSubjectService;
    @Resource
    private HotGoodsService hotGoodsService;
    @Resource
    private GoodsService goodsService;
    @Resource
    private GoodsClassifyService goodsClassifyService;
    @Resource(name="richTextCommonServiceImpl")
    private RichTextService richTextService;
    @Resource
    private CollectService collectService;
    @Resource(name="commonConfigService")
    private ConfigService configService;

    @GetMapping(value={"/index"})
    public Map<String, Object> index(@RequestHeader(value="merchantId") Integer merchantId) {
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        IndexSubjectImg indexSubjectImg = this.indexSubjectService.getIndexSubjectImg(merchantId);
        map.put("indexSubjectImg", indexSubjectImg);
        Config config = this.configService.findSysConfig(merchantId);
        map.put("title", config.getTitle());
        return map;
    }

    @GetMapping(value={"/subject/detail/{id}"})
    public IndexSubjectImg getSubject(@PathVariable(value="id") Integer id) {
        return this.indexSubjectService.getIndexSubjectById(id);
    }

    @GetMapping(value={"/index2"})
    public Map<String, Object> index2(@RequestHeader(value="merchantId") Integer merchantId) {
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        IndexSubjectImg indexSubjectImg = this.indexSubjectService.getIndexSubjectImg(merchantId);
        map.put("indexSubjectImg", indexSubjectImg);
        List list = this.hotGoodsService.getIndexHotGoods(merchantId);
        map.put("list", list);
        Config config = this.configService.findSysConfig(merchantId);
        map.put("title", config.getTitle());
        return map;
    }

    @GetMapping(value={"/subject/detail2/{id}"})
    public Map<String, Object> getSubject(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        IndexSubjectImg indexSubjectImg = this.indexSubjectService.getIndexSubjectById(id);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("indexSubjectImg", indexSubjectImg);
        List list = this.hotGoodsService.getSubHotGoods(merchantId, indexSubjectImg.getId());
        map.put("list", list);
        return map;
    }

    @GetMapping(value={"/classify"})
    public List<GoodsClassify> getClassifyList(@RequestHeader(value="merchantId") Integer merchantId) {
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        return this.goodsClassifyService.getClassifyList(merchantId);
    }

    @GetMapping(value={"/goods/detail/{goodsId}"})
    public Map<String, Object> index(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="goodsId") Integer goodsId) {
        log.info("\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u3002\u3002\u3002START\u3002\u3002\u3002===\u5546\u54c1id:{}", (Object)goodsId);
        User user = (User)SecurityContext.getUser();
        InputValidator.checkEmpty((Object)merchantId, (String)"merchantId");
        InputValidator.checkEmpty((Object)goodsId, (String)"goodsId");
        Goods condition = new Goods();
        condition.setMerchantId(merchantId);
        condition.setId(goodsId);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        Goods goods = (Goods)this.goodsService.findOneByCondition((Serializable)condition);
        map.put("goods", goods);
        if (null == goods) {
            throw new CustomException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        RichText byId = this.richTextService.findById(goods.getIntroId());
        map.put("richText", byId);
        List list = this.goodsService.getGoodsGiftsByGoodsId(goodsId);
        ArrayList resultList = new ArrayList();
        if (list.size() > 0) {
            resultList.add(list.get(0));
        }
        map.put("goodsGiftsList", resultList);
        List list1 = this.goodsService.getGoodsActivityByGoodsId(goodsId);
        map.put("goodsActivityList", list1);
        List list3 = this.goodsService.getGoodsSkus(goodsId);
        list3.forEach(g -> g.setStock(Integer.valueOf(g.getIsEnabled() != false ? g.getStock() : 0)));
        map.put("goodsSkus", list3);
        if (!goods.getIsUniform().booleanValue()) {
            List list2 = this.goodsService.getGoodsSpecs(goodsId);
            map.put("goodsSpecs", list2);
        }
        Collect collect = new Collect();
        collect.setMerchantId(merchantId);
        collect.setWechatOpenid(user.getOpenid());
        collect.setFavoriteId(goodsId.toString());
        map.put("isFavorite", this.collectService.isCollected(collect));
        Config config = this.configService.findSysConfig(merchantId);
        HashMap<String, Boolean> configMap = new HashMap<String, Boolean>();
        configMap.put("balanceDeduction", config.getBalanceDeduction());
        configMap.put("integralDeduction", config.getIntegralDeduction());
        map.put("config", configMap);
        log.info("\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u3002\u3002\u3002END\u3002\u3002\u3002===\u8fd4\u56de\u7ed3\u679c\u4e3a:{}", map);
        return map;
    }

    @GetMapping(value={"/goods/pros/{goodsId}"})
    public List<GoodsPropValueCustom> getGoodsPros(@PathVariable(value="goodsId") Integer goodsId) {
        InputValidator.checkEmpty((Object)goodsId, (String)"\u53c2\u6570");
        List list = this.goodsService.getGoodsPropsByGoodsId(goodsId);
        return list;
    }

    @GetMapping(value={"/goods/evaluate/{goodsId}"})
    public HashMap<String, Object> getGoodsEvaluate(@PathVariable(value="goodsId") Integer goodsId) {
        InputValidator.checkEmpty((Object)goodsId, (String)"\u53c2\u6570");
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        PageContext.startPage();
        List comments = this.goodsService.getGoodsEvaluate(goodsId);
        map.put("comments", new PageInfo(comments));
        Integer[] sumGrade = new Integer[]{0};
        BigDecimal degress = new BigDecimal("0");
        if (null != comments && !comments.isEmpty()) {
            comments.forEach(x -> {
                sumGrade[0] = sumGrade[0] + x.getGoodsGrade();
            });
            degress = new BigDecimal(sumGrade[0]).divide(new BigDecimal(comments.size()), 1, 4).multiply(new BigDecimal("2"));
        }
        map.put("degress", degress);
        return map;
    }
}

