/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.schedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.core.json.gson.JsonUtil;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderDetailGetV2RequestVO;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderListGetResponse;
import com.wmeimob.fastboot.baison.dto.requestVO.BiasonReturnOrderGetVo;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonOrderDetailGetBusinessDataResponse;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonOrderDetailGetOrderListGetResponse;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonOrderDetailGetResponseVO;
import com.wmeimob.fastboot.baison.dto.responseVO.BiasonReturnOrderResponseAll;
import com.wmeimob.fastboot.baison.dto.responseVO.BiasonReturnOrderResponseData;
import com.wmeimob.fastboot.baison.dto.responseVO.BiasonReturnOrderResponseSuccess;
import com.wmeimob.fastboot.baison.service.E3OrderService;
import com.wmeimob.fastboot.baison.utils.RetryUtil;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.RetryInfoRecord;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.enums.ErpSystemType;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.mapper.RetryInfoRecordMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.service.CommentsService;
import com.wmeimob.fastboot.bizvane.service.CommissionService;
import com.wmeimob.fastboot.bizvane.service.CommonIntegralGoodsService;
import com.wmeimob.fastboot.bizvane.service.CommonIntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.CommonService;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.MiniprogramReleaseService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.open.entity.MiniprogramRelease;
import com.wmeimob.fastboot.starter.wechat.service.WepayService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import tk.mybatis.mapper.entity.Example;

@Component
@EnableScheduling
public class UserCommissionSchedule {
    private static final Logger log = LoggerFactory.getLogger(UserCommissionSchedule.class);
    @Resource(name="commonUserCommissionService")
    private UserCommissionService userCommissionService;
    @Resource(name="commentsCommissionService")
    private CommentsService commentsService;
    @Resource
    private MiniprogramReleaseService miniprogramReleaseService;
    @Resource
    private CommonIntegralGoodsService commonIntegralGoodsService;
    @Resource
    private CommonIntegralOrdersService commonIntegralOrdersService;
    @Autowired
    private CommissionService commissionService;
    @Autowired
    private OrdersMapper ordersMapper;
    @Autowired
    private WepayService wepayService;
    @Autowired
    private WechatMchNewMapper wechatMchNewMapper;
    @Autowired
    private RetryInfoRecordMapper retryInfoRecordMapper;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private E3OrderService e3OrderService;
    @Autowired
    private RefundOrderMapper refundOrderMapper;

    @Scheduled(fixedDelay=120000L)
    public void commissionSettle() {
        log.info("commissionSettle schedule start...");
        List byCondition = this.miniprogramReleaseService.findByCondition((Serializable)new MiniprogramRelease());
        for (MiniprogramRelease release : byCondition) {
            MDC.put((String)("commissionSettle" + release.getMerchantId()), (String)UUID.randomUUID().toString());
            this.userCommissionService.settle(release.getMerchantId());
        }
    }

    @Scheduled(fixedDelay=120000L)
    public void commentsSettle() {
        log.info("commentsSettle schedule start...");
        List byCondition = this.miniprogramReleaseService.findByCondition((Serializable)new MiniprogramRelease());
        for (MiniprogramRelease release : byCondition) {
            this.commentsService.settle(release.getMerchantId());
        }
    }

    @Scheduled(cron="0 0 0/1 ? * *")
    public void integralAutoOrdersStatus() {
        log.info("integralAutoOrdersStatus schedule start...");
        List merchantIds = this.commonIntegralOrdersService.getAllMerchantId();
        for (Integer id : merchantIds) {
            this.commonIntegralOrdersService.settle(id);
        }
    }

    @Scheduled(cron="0 0/5 * * * ?  ")
    public void changeCommission() {
        this.commissionService.update();
    }

    @Scheduled(cron="0 0 0/1 ? * *")
    public void closeUnPayOrders() {
        StopWatch sw = new StopWatch("\u8ba2\u5355\u8868\u4fee\u6539\u672a\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u4efb\u52a1");
        log.info("\u4efb\u52a1:{} ========>\u5f00\u59cb", (Object)sw.getId());
        sw.start();
        List unCloseds = this.ordersMapper.queryCloseUnPayOrders();
        if (!CollectionUtils.isEmpty((Collection)unCloseds)) {
            List orderIds = unCloseds.stream().map(e -> e.getId()).collect(Collectors.toList());
            log.info("\u81ea\u52a8\u5173\u95ed\u672a\u652f\u4ed8\u8ba2\u5355\u8865\u507f:orderIds:[{}]", JSON.toJSON(orderIds));
            ArrayList<Integer> closeFailOrdersIds = new ArrayList<Integer>();
            for (Orders e2 : unCloseds) {
                try {
                    WechatMchNew wmn = new WechatMchNew();
                    wmn.setMerchantId(e2.getMerchantId());
                    wmn = (WechatMchNew)this.wechatMchNewMapper.selectOne((Object)wmn);
                    if (wmn == null) {
                        return;
                    }
                    this.wepayService.closeOrders(wmn.getAppId(), e2.getOrderNo());
                    Orders temp = new Orders();
                    temp.setId(e2.getId());
                    temp.setOrderStatus(OrdersStatusEnum.FAIL);
                    this.ordersMapper.updateByPrimaryKeySelective((Object)temp);
                }
                catch (Exception f) {
                    log.error(f.getMessage(), (Throwable)f);
                    closeFailOrdersIds.add(e2.getId());
                }
                log.info("------->\u8c03\u7528\u5fae\u4fe1\u5173\u95ed\u8ba2\u5355\u63a5\u53e3\u5b8c\u6210");
            }
            sw.stop();
            log.info("\u4efb\u52a1:{} ========>\u7ed3\u675f========>\u6267\u884c\u65f6\u95f4:{}  \u5173\u95ed\u5931\u8d25\u7684\u8ba2\u5355id\u4e3a:{}", new Object[]{sw.getId(), sw.getTotalTimeSeconds(), JSON.toJSON(closeFailOrdersIds)});
            return;
        }
        sw.stop();
        log.info("\u8ba2\u5355\u8868\u672a\u53d1\u73b0\u9700\u8981\u81ea\u52a8\u5173\u95ed\u7684\u8ba2\u5355");
    }

    @Scheduled(fixedDelay=120000L)
    public void AutoSynchronousLogisticsInfo() {
        log.info("=========\u4eceE3\u5b9a\u65f6\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u5230\u5546\u57ce\u8ba2\u5355start============");
        Config config = new Config();
        List allUnSendOrders = this.commonService.getAllUnSendOrders();
        for (Orders order : allUnSendOrders) {
            config.setMerchantId(order.getMerchantId());
            Config oneByCondition = (Config)this.configService.findOneByCondition((Serializable)config);
            if (!oneByCondition.getErpSystem().equals(ErpSystemType.E3.getCode())) continue;
            BaisonOrderDetailGetV2RequestVO requestVO = new BaisonOrderDetailGetV2RequestVO();
            requestVO.setPageNo(Integer.valueOf(1));
            requestVO.setPageSize(Integer.valueOf(20));
            requestVO.setDeal_code(order.getOrderNo());
            BaisonOrderDetailGetResponseVO baisonResponseDTO = null;
            try {
                baisonResponseDTO = this.e3OrderService.orderDetailGetV2(requestVO);
                log.info("e3\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)baisonResponseDTO));
                BaisonOrderDetailGetBusinessDataResponse data = baisonResponseDTO.getData();
                List orderListGets = data.getOrderListGets();
                if (CollectionUtils.isEmpty((Collection)orderListGets)) continue;
                for (BaisonOrderDetailGetOrderListGetResponse orderList : orderListGets) {
                    BaisonOrderListGetResponse orderListGet = orderList.getOrderListGet();
                    if (orderListGet.getOrder_status() != 5) continue;
                    String receiverAddress = orderListGet.getReceiver_address();
                    String[] s = receiverAddress.split(" ");
                    Orders orders = new Orders();
                    orders.setShippingName(orderListGet.getReceiver_name());
                    orders.setShippingAddress(orderListGet.getReceiver_address());
                    orders.setShippingProvince(s[0]);
                    orders.setShippingCity(s[1]);
                    orders.setShippingDistrict(s[2]);
                    orders.setShippingFee(new BigDecimal(orderListGet.getShipping_fee()));
                    orders.setShippingMobile(orderListGet.getReceiver_mobile());
                    orders.setShippingVendor(orderListGet.getShipping_name());
                    orders.setShippingNo(orderListGet.getShipping_sn());
                    orders.setShippingAt(orderListGet.getShipping_time_fh());
                    orders.setLogisticsStatus(LogisticsStatusEnum.SEND);
                    log.info("\u4eceE3\u540c\u6b65\u5230\u5fae\u5546\u57ce\u7684\u7269\u6d41\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orders));
                    Example example = new Example(Orders.class);
                    example.createCriteria().andEqualTo("orderNo", (Object)orderListGet.getDeal_code());
                    this.ordersMapper.updateByExampleSelective((Object)orders, (Object)example);
                }
            }
            catch (Exception e) {
                log.info("=========\u4eceE3\u5b9a\u65f6\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u5230\u5546\u57ce\u8ba2\u5355\u5931\u8d25============:{}", (Object)e.getMessage());
                RetryInfoRecord infoRecord = new RetryInfoRecord();
                infoRecord.setClassName(RetryUtil.getClassName());
                infoRecord.setMethodName(RetryUtil.getMethodName());
                infoRecord.setErrorReason(JsonUtil.toJson((Object)baisonResponseDTO, (String[])new String[]{"data"}));
                infoRecord.setRequestParams(JSONObject.toJSONString((Object)requestVO));
                infoRecord.setRetryInterface("order.detail.get.v2");
                Example example = new Example(RetryInfoRecord.class);
                example.createCriteria().andEqualTo("retryInterface", (Object)infoRecord.getRetryInterface()).andEqualTo("requestParams", (Object)infoRecord.getRequestParams());
                List retryInfoRecords = this.retryInfoRecordMapper.selectByExample((Object)example);
                try {
                    if (CollectionUtils.isEmpty((Collection)retryInfoRecords)) {
                        infoRecord.setCreateDate(new Date());
                        this.retryInfoRecordMapper.insertSelective((Object)infoRecord);
                        continue;
                    }
                    RetryInfoRecord record = (RetryInfoRecord)retryInfoRecords.get(0);
                    infoRecord.setId(record.getId());
                    infoRecord.setModifyDate(new Date());
                    this.retryInfoRecordMapper.updateByPrimaryKeySelective((Object)infoRecord);
                }
                catch (Exception e1) {
                    log.info("\u6301\u4e45\u5316\u5f02\u5e38\u8bb0\u5f55\u5931\u8d25:{}", (Object)e1.getMessage());
                }
            }
        }
    }

    @Scheduled(fixedDelay=120000L)
    public void AutoSynRefundOrderLogisticsInfo() {
        log.info("=========\u4eceE3\u5b9a\u65f6\u540c\u6b65\u9000\u5355\u4fe1\u606fstart============");
        Config config = new Config();
        List allRefundOrders = this.commonService.getAllRefundOrders();
        for (RefundOrder refundOrder : allRefundOrders) {
            config.setMerchantId(refundOrder.getMerchantId());
            Config oneByCondition = (Config)this.configService.findOneByCondition((Serializable)config);
            if (!oneByCondition.getErpSystem().equals(ErpSystemType.E3.getCode())) continue;
            BiasonReturnOrderGetVo vo = new BiasonReturnOrderGetVo();
            vo.setPageNo(Integer.valueOf(1));
            vo.setPageSize(Integer.valueOf(20));
            vo.setRefund_deal_code(refundOrder.getOrderNo());
            BiasonReturnOrderResponseAll biasonReturnOrderResponseAll = null;
            try {
                biasonReturnOrderResponseAll = this.e3OrderService.returnDetailGet(vo);
                log.info("biasonReturnOrderResponseAll------>:{}", (Object)JSON.toJSONString((Object)biasonReturnOrderResponseAll));
                BiasonReturnOrderResponseData data = biasonReturnOrderResponseAll.getData();
                List success = data.getSuccess();
                if (CollectionUtils.isEmpty((Collection)success)) continue;
                for (BiasonReturnOrderResponseSuccess suc : success) {
                    String return_order_status = suc.getReturn_order_status();
                    String refund_deal_code = suc.getRefund_deal_code();
                    if (!"10".equals(return_order_status)) continue;
                    RefundOrder reOrder = new RefundOrder();
                    reOrder.setAuditStatus(Byte.valueOf((byte)1));
                    reOrder.setAuditAt(new Date());
                    reOrder.setGmtModified(new Date());
                    reOrder.setAuditor("E3");
                    Example example = new Example(RefundOrder.class);
                    example.createCriteria().andEqualTo("orderNo", (Object)refund_deal_code);
                    try {
                        this.refundOrderMapper.updateByExampleSelective((Object)reOrder, (Object)example);
                    }
                    catch (Exception e) {
                        log.info("\u81ea\u52a8\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.info("=========\u4eceE3\u5b9a\u65f6\u540c\u6b65\u9000\u8d27\u7269\u6d41\u4fe1\u606f\u5230\u5546\u57ce\u8ba2\u5355\u5931\u8d25============:{}", (Object)e.getMessage());
                RetryInfoRecord infoRecord = new RetryInfoRecord();
                infoRecord.setClassName(RetryUtil.getClassName());
                infoRecord.setMethodName(RetryUtil.getMethodName());
                infoRecord.setErrorReason(JsonUtil.toJson((Object)biasonReturnOrderResponseAll, (String[])new String[]{"data"}));
                infoRecord.setRequestParams(JSONObject.toJSONString((Object)vo));
                infoRecord.setRetryInterface("return.detail.get");
                Example example = new Example(RetryInfoRecord.class);
                example.createCriteria().andEqualTo("retryInterface", (Object)infoRecord.getRetryInterface()).andEqualTo("requestParams", (Object)infoRecord.getRequestParams());
                List retryInfoRecords = this.retryInfoRecordMapper.selectByExample((Object)example);
                try {
                    if (CollectionUtils.isEmpty((Collection)retryInfoRecords)) {
                        infoRecord.setCreateDate(new Date());
                        this.retryInfoRecordMapper.insertSelective((Object)infoRecord);
                        continue;
                    }
                    RetryInfoRecord record = (RetryInfoRecord)retryInfoRecords.get(0);
                    infoRecord.setId(record.getId());
                    infoRecord.setModifyDate(new Date());
                    this.retryInfoRecordMapper.updateByPrimaryKeySelective((Object)infoRecord);
                }
                catch (Exception e1) {
                    log.info("\u6301\u4e45\u5316\u5f02\u5e38\u8bb0\u5f55\u5931\u8d25:{}", (Object)e1.getMessage());
                }
            }
        }
    }
}

