/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.temp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.TTempRefundOrderShippingFee;
import com.wmeimob.fastboot.bizvane.entity.TTempRefundOrderShippingFeeError;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.TTempRefundOrderShippingFeeErrorMapper;
import com.wmeimob.fastboot.bizvane.mapper.TTempRefundOrderShippingFeeMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.ShippingFeeBatchRequestVO;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.fastboot.util.DateUtil;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.model.enums.RefundAccount;
import me.hao0.wepay.model.refund.RefundApplyRequest;
import me.hao0.wepay.model.refund.RefundApplyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class RefundOrderServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderServiceImpl.class);
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private WechatService wechatService;
    @Resource
    private WechatProperties wechatProperties;
    @Resource
    private WechatMchNewMapper wechatMchNewMapper;
    @Resource
    private TTempRefundOrderShippingFeeMapper tTempRefundOrderShippingFeeMapper;
    @Resource
    private TTempRefundOrderShippingFeeErrorMapper tTempRefundOrderShippingFeeErrorMapper;

    private ResponseData<RefundApplyRequest> refundShippingFee(Orders orders, String refundNo) {
        String orderNo = orders.getOrderNo();
        if (orders.getPriceSystem().equals(2)) {
            log.info("\u8ba2\u5355:{}\u662f\u79ef\u5206\u652f\u4ed8,return", (Object)orderNo);
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u662f\u79ef\u5206\u652f\u4ed8\u8ba2\u5355");
        }
        BigDecimal shippingFee = orders.getShippingFee();
        if (shippingFee.compareTo(BigDecimal.ZERO) != 1) {
            log.info("\u8ba2\u5355\u90ae\u8d39\u4e3a:{},return", (Object)shippingFee);
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u90ae\u8d39\u662f0");
        }
        Integer merchantId = orders.getMerchantId();
        Example example = new Example(WechatMchNew.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
        if (mchNew == null) {
            log.info("\u54c1\u724cId:{},\u672a\u64cd\u4f5c\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e,return", (Object)merchantId);
            return ResponseUtil.getFailedMsg((String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u652f\u4ed8");
        }
        WechatMp wechatMp = new WechatMp();
        wechatMp.setAppid(mchNew.getAppId());
        WechatMch wechatMch = new WechatMch();
        wechatMch.setMchKey(mchNew.getMchKey());
        wechatMch.setMchNo(mchNew.getMchNo());
        wechatMch.setP12(mchNew.getP12());
        Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
        Integer refundFee = shippingFee.multiply(new BigDecimal("100")).intValue();
        String refundAuditor = "\u8865\u9000\u90ae\u8d39";
        String refundReason = "\u8865\u9000\u90ae\u8d39";
        if (StringUtils.isEmpty((Object)refundNo)) {
            log.info("\u8ba2\u5355:{}\u672a\u751f\u6210\u5bf9\u5e94\u7684\u9000\u5355\u5355\u53f7,return", (Object)orderNo);
            return ResponseUtil.getFailedMsg((String)"\u672a\u751f\u6210\u90ae\u8d39\u9000\u6b3e\u5355");
        }
        RefundApplyRequest refundApplyRequest = new RefundApplyRequest();
        refundApplyRequest.setOutTradeNo(orderNo);
        refundApplyRequest.setOutRefundNo(refundNo);
        refundApplyRequest.setRefundFee(refundFee);
        refundApplyRequest.setOpUserId(refundAuditor);
        refundApplyRequest.setRefundDesc(refundReason);
        refundApplyRequest.setNotifyUrl((String)this.wechatProperties.getUrls().get("refund-notify"));
        refundApplyRequest.setRefundAccount(RefundAccount.REFUND_SOURCE_UNSETTLED_FUNDS);
        refundApplyRequest.setTotalFee(Integer.valueOf(orders.getPayAmount().multiply(new BigDecimal("100")).intValue()));
        log.info("wexin pay refund request => {}", (Object)JSONObject.toJSONString((Object)refundApplyRequest));
        try {
            RefundApplyResponse refundApplyResponse = wepay.refund().apply(refundApplyRequest);
            log.info("wexin pay refund result => {}", (Object)JSONObject.toJSONString((Object)refundApplyResponse));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u4fe1\u652f\u4ed8\u53d1\u8d77\u9000\u6b3e\u5f02\u5e38:{}", (Throwable)e);
            return ResponseUtil.getFailedData((Object)refundApplyRequest, (String)"\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u9000\u90ae\u8d39\u5931\u8d25");
        }
        return ResponseUtil.getSuccessData((Object)refundApplyRequest, (String)"\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u9000\u90ae\u8d39\u6210\u529f");
    }

    private ResponseData<RefundApplyRequest> refundShippingFeeRetry(Orders orders, String refundNo, String unit) {
        String orderNo = orders.getOrderNo();
        if (orders.getPriceSystem().equals(2)) {
            log.info("\u8ba2\u5355:{}\u662f\u79ef\u5206\u652f\u4ed8,return", (Object)orderNo);
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u662f\u79ef\u5206\u652f\u4ed8\u8ba2\u5355");
        }
        BigDecimal shippingFee = orders.getShippingFee();
        if (shippingFee.compareTo(BigDecimal.ZERO) != 1) {
            log.info("\u8ba2\u5355\u90ae\u8d39\u4e3a:{},return", (Object)shippingFee);
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u90ae\u8d39\u662f0");
        }
        Integer merchantId = orders.getMerchantId();
        Example example = new Example(WechatMchNew.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
        if (mchNew == null) {
            log.info("\u54c1\u724cId:{},\u672a\u64cd\u4f5c\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e,return", (Object)merchantId);
            return ResponseUtil.getFailedMsg((String)"\u672a\u914d\u7f6e\u5fae\u4fe1\u652f\u4ed8");
        }
        WechatMp wechatMp = new WechatMp();
        wechatMp.setAppid(mchNew.getAppId());
        WechatMch wechatMch = new WechatMch();
        wechatMch.setMchKey(mchNew.getMchKey());
        wechatMch.setMchNo(mchNew.getMchNo());
        wechatMch.setP12(mchNew.getP12());
        Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
        Integer refundFee = shippingFee.multiply(new BigDecimal(unit)).intValue();
        String refundAuditor = "\u8865\u9000\u90ae\u8d39";
        String refundReason = "\u8865\u9000\u90ae\u8d39";
        if (StringUtils.isEmpty((Object)refundNo)) {
            log.info("\u8ba2\u5355:{}\u672a\u751f\u6210\u5bf9\u5e94\u7684\u9000\u5355\u5355\u53f7,return", (Object)orderNo);
            return ResponseUtil.getFailedMsg((String)"\u672a\u751f\u6210\u90ae\u8d39\u9000\u6b3e\u5355");
        }
        RefundApplyRequest refundApplyRequest = new RefundApplyRequest();
        refundApplyRequest.setOutTradeNo(orderNo);
        refundApplyRequest.setOutRefundNo(refundNo);
        refundApplyRequest.setRefundFee(refundFee);
        refundApplyRequest.setOpUserId(refundAuditor);
        refundApplyRequest.setRefundDesc(refundReason);
        refundApplyRequest.setNotifyUrl((String)this.wechatProperties.getUrls().get("refund-notify"));
        refundApplyRequest.setRefundAccount(RefundAccount.REFUND_SOURCE_UNSETTLED_FUNDS);
        refundApplyRequest.setTotalFee(Integer.valueOf(orders.getPayAmount().multiply(new BigDecimal("100")).intValue()));
        log.info("wexin pay refund request => {}", (Object)JSONObject.toJSONString((Object)refundApplyRequest));
        try {
            RefundApplyResponse refundApplyResponse = wepay.refund().apply(refundApplyRequest);
            log.info("wexin pay refund result => {}", (Object)JSONObject.toJSONString((Object)refundApplyResponse));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u4fe1\u652f\u4ed8\u53d1\u8d77\u9000\u6b3e\u5f02\u5e38:{}", (Throwable)e);
            return ResponseUtil.getFailedData((Object)refundApplyRequest, (String)"\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u9000\u90ae\u8d39\u5931\u8d25");
        }
        return ResponseUtil.getSuccessData((Object)refundApplyRequest, (String)"\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u9000\u90ae\u8d39\u6210\u529f");
    }

    public ResponseData<TTempRefundOrderShippingFee> refundShippingFeeOption(String orderNo) {
        if (StringUtils.isEmpty((Object)orderNo)) {
            log.info("\u53c2\u6570\u4e3a\u7a7a,return");
            return ResponseUtil.getFailedMsg((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        Example orderExample = new Example(Orders.class);
        orderExample.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)orderExample);
        if (orders == null) {
            log.info("\u8ba2\u5355:{}\u4e0d\u5b58\u5728,return", (Object)orderNo);
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        log.info("\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orders));
        Integer merchantId = orders.getMerchantId();
        String refundNo = DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)10);
        Example example = new Example(TTempRefundOrderShippingFee.class);
        example.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        TTempRefundOrderShippingFee responseResult = (TTempRefundOrderShippingFee)this.tTempRefundOrderShippingFeeMapper.selectOneByExample((Object)example);
        if (responseResult != null) {
            log.info("\u5df2\u7ecf\u5b58\u5728\u8bb0\u5f55,\u76f4\u63a5return");
            refundNo = responseResult.getRefundNo();
            byte refundStatus = responseResult.getRefundStatus();
            if (refundStatus == 2) {
                return ResponseUtil.getSuccessData((Object)refundNo, (String)"\u5b58\u5728\u8bb0\u5f55,\u9000\u90ae\u8d39\u6210\u529f");
            }
            if (refundStatus == 3) {
                return ResponseUtil.getSuccessData((Object)refundNo, (String)"\u5b58\u5728\u8bb0\u5f55,\u9000\u90ae\u8d39\u5931\u8d25");
            }
            if (refundStatus == 1) {
                return ResponseUtil.getSuccessData((Object)refundNo, (String)"\u5b58\u5728\u8bb0\u5f55,\u9000\u90ae\u8d39\u4e2d");
            }
            return ResponseUtil.getFailedMsg((String)"\u5b58\u5728\u8bb0\u5f55,\u5f02\u5e38\u8bb0\u5f55");
        }
        log.info("\u7b2c\u4e00\u6b21\u8c03\u7528\u9000\u5e93\u5b58");
        ResponseData responseData = this.refundShippingFee(orders, refundNo);
        int code = responseData.getCode();
        String message = responseData.getMessage();
        if (code != SysResponseEnum.SUCCESS.getCode()) {
            log.info("\u8c03\u7528refundShippingFee \uff0cresponse:{}", (Object)JSON.toJSONString((Object)responseData));
            return ResponseUtil.getFailedMsg((String)message);
        }
        RefundApplyRequest data = (RefundApplyRequest)responseData.getData();
        TTempRefundOrderShippingFee tTempRefundOrderShippingFee = new TTempRefundOrderShippingFee();
        tTempRefundOrderShippingFee.setOrderNo(orderNo);
        tTempRefundOrderShippingFee.setMerchantId(merchantId);
        tTempRefundOrderShippingFee.setUserId(Integer.valueOf(orders.getUserId().intValue()));
        tTempRefundOrderShippingFee.setUserNo(orders.getUserNo());
        tTempRefundOrderShippingFee.setUserName(orders.getUserName());
        tTempRefundOrderShippingFee.setRefundAt(new Date());
        tTempRefundOrderShippingFee.setRefundAmount(orders.getShippingFee());
        tTempRefundOrderShippingFee.setRefundNo(refundNo);
        tTempRefundOrderShippingFee.setRefundReason(data.getRefundDesc());
        tTempRefundOrderShippingFee.setRefundStatus(new Byte("1"));
        tTempRefundOrderShippingFee.setAuditor(data.getOpUserId());
        tTempRefundOrderShippingFee.setAuditAt(new Date());
        tTempRefundOrderShippingFee.setGmtCreate(new Date());
        this.tTempRefundOrderShippingFeeMapper.insertSelective((Object)tTempRefundOrderShippingFee);
        return ResponseUtil.getSuccessData((Object)tTempRefundOrderShippingFee, (String)"\u751f\u6210\u9000\u90ae\u8d39\u8bb0\u5f55\u6210\u529f");
    }

    public void refundShippingFeeOptionBatch(ShippingFeeBatchRequestVO shippingFeeBatchRequestVO) {
        log.info("RefundOrderServiceImpl # refundShippingFeeOptionBatch \u6267\u884c\u5f00\u59cb");
        String orders = shippingFeeBatchRequestVO.getOrders();
        if (shippingFeeBatchRequestVO == null || StringUtils.isEmpty((Object)orders)) {
            log.info("\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        String[] split = orders.split(",");
        HashSet<String> list = new HashSet<String>(Arrays.asList(split));
        int i = 0;
        for (String orderNo : list) {
            log.info("RefundOrderServiceImpl # refundShippingFeeOptionBatch index:{} , count :{}, orderNo:{}", new Object[]{i + 1, list.size(), orderNo});
            try {
                this.refundShippingFeeOption(orderNo);
            }
            catch (Exception e) {
                this.writeErrorLog(e, orderNo);
                log.error("RefundOrderServiceImpl # refundShippingFeeOptionBatch exception:{}", (Throwable)e);
            }
        }
        log.info("RefundOrderServiceImpl # refundShippingFeeOptionBatch \u6267\u884c\u7ed3\u675f");
    }

    private void writeErrorLog(Exception e, String orderNo) {
        TTempRefundOrderShippingFeeError tTempRefundOrderShippingFeeError = new TTempRefundOrderShippingFeeError();
        tTempRefundOrderShippingFeeError.setOrderNo(orderNo);
        tTempRefundOrderShippingFeeError.setError(e.getMessage());
        this.tTempRefundOrderShippingFeeErrorMapper.insertSelective((Object)tTempRefundOrderShippingFeeError);
    }

    public ResponseData<TTempRefundOrderShippingFee> refundShippingFeeOptionRetry(String orderNo) {
        if (StringUtils.isEmpty((Object)orderNo)) {
            log.info("\u53c2\u6570\u4e3a\u7a7a,return");
            return ResponseUtil.getFailedMsg((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        Example orderExample = new Example(Orders.class);
        orderExample.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)orderExample);
        if (orders == null) {
            log.info("\u8ba2\u5355:{}\u4e0d\u5b58\u5728,return", (Object)orderNo);
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        log.info("\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orders));
        String refundNo = DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)10);
        Example example = new Example(TTempRefundOrderShippingFee.class);
        example.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        TTempRefundOrderShippingFee responseResult = (TTempRefundOrderShippingFee)this.tTempRefundOrderShippingFeeMapper.selectOneByExample((Object)example);
        if (responseResult == null) {
            return ResponseUtil.getFailedMsg((String)"retry\u65b9\u6cd5\u4e0d\u5b58\u5728\u8bb0\u5f55,\u76f4\u63a5return");
        }
        byte refundStatus = responseResult.getRefundStatus();
        if (refundStatus != -1) {
            return ResponseUtil.getFailedMsg((String)"retry\u65b9\u6cd5\u8ba2\u5355\u72b6\u6001\u4e0d\u4e3a-1,\u76f4\u63a5return");
        }
        log.info("\u5386\u53f2\u8ba2\u5355\u5904\u7406\u9000\u6b3e\u5355\u4f4d\u51fa\u9519\uff0c\u91cd\u65b0\u8865\u507f");
        ResponseData responseData = this.refundShippingFeeRetry(orders, refundNo, "99");
        int code = responseData.getCode();
        String message = responseData.getMessage();
        log.info("\u8c03\u7528refundShippingFee \uff0cresponse:{}", (Object)JSON.toJSONString((Object)responseData));
        if (code != SysResponseEnum.SUCCESS.getCode()) {
            return ResponseUtil.getFailedMsg((String)message);
        }
        TTempRefundOrderShippingFee tTempRefundOrderShippingFee = new TTempRefundOrderShippingFee();
        tTempRefundOrderShippingFee.setRefundStatus(Byte.valueOf((byte)-2));
        tTempRefundOrderShippingFee.setGmtModified(new Date());
        this.tTempRefundOrderShippingFeeMapper.updateByPrimaryKeySelective((Object)tTempRefundOrderShippingFee);
        return ResponseUtil.getSuccessData((Object)responseResult);
    }

    public void updateSuccess(String orderNo) {
        Example example = new Example(TTempRefundOrderShippingFee.class);
        example.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        TTempRefundOrderShippingFee tTempRefundOrderShippingFee = new TTempRefundOrderShippingFee();
        tTempRefundOrderShippingFee.setRefundStatus(Byte.valueOf((byte)2));
        tTempRefundOrderShippingFee.setGmtModified(new Date());
        this.tTempRefundOrderShippingFeeMapper.updateByExampleSelective((Object)tTempRefundOrderShippingFee, (Object)example);
    }

    public void updateFail(String orderNo) {
        Example example = new Example(TTempRefundOrderShippingFee.class);
        example.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        TTempRefundOrderShippingFee tTempRefundOrderShippingFee = new TTempRefundOrderShippingFee();
        tTempRefundOrderShippingFee.setRefundStatus(Byte.valueOf((byte)3));
        tTempRefundOrderShippingFee.setGmtModified(new Date());
        this.tTempRefundOrderShippingFeeMapper.updateByExampleSelective((Object)tTempRefundOrderShippingFee, (Object)example);
    }
}

