/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.wrapper;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.ShopCart;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.vo.BrowseVO;
import com.wmeimob.fastboot.bizvane.vo.ViewGoodsVO;
import com.wmeimob.fastboot.bizvane.vo.ViewShareGoodsInformRequestVO;
import com.wmeimob.fastboot.open.service.MiniprogramUserService;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class BrowseWrapperService {
    private static final Logger log = LoggerFactory.getLogger(BrowseWrapperService.class);
    @Resource
    @Lazy
    private MiniprogramUserService miniprogramUserService;

    public void fillBrowse(Orders orders, User user) {
        if (user != null) {
            BrowseVO browse = this.miniprogramUserService.getBrowse(user.getAppid(), user.getOpenid());
            log.info("openID:{}\u83b7\u53d6browse:{}", (Object)user.getOpenid(), (Object)JSON.toJSONString((Object)browse));
            String sysStaffId = browse.getSysStaffId();
            String sysStoreId = browse.getSysStoreId();
            if (!StringUtils.isEmpty((String)sysStaffId)) {
                orders.setSysStaffId(sysStaffId);
            }
            if (!StringUtils.isEmpty((String)sysStoreId)) {
                orders.setShareSysStoreId(sysStoreId);
            }
        }
        log.info("BrowseWrapperService_fillBrowse_orders:{}", (Object)JSON.toJSONString((Object)orders));
    }

    public void fillBrowse(ViewGoodsVO viewGoodsVO, User user) {
        if (user != null) {
            BrowseVO browse = this.miniprogramUserService.getBrowse(user.getAppid(), user.getOpenid());
            log.info("openID:{}\u83b7\u53d6browse:{}", (Object)user.getOpenid(), (Object)JSON.toJSONString((Object)browse));
            String sysStaffId = browse.getSysStaffId();
            String sysStoreId = browse.getSysStoreId();
            if (!StringUtils.isEmpty((String)sysStaffId)) {
                viewGoodsVO.setSysStaffId(sysStaffId);
            }
            if (!StringUtils.isEmpty((String)sysStoreId)) {
                viewGoodsVO.setSysStoreId(sysStoreId);
            }
        }
        log.info("BrowseWrapperService_fillBrowse_viewGoodsVO:{}", (Object)JSON.toJSONString((Object)viewGoodsVO));
    }

    public void fillBrowse(ShopCart shopCart, User user) {
        if (user != null) {
            BrowseVO browse = this.miniprogramUserService.getBrowse(user.getAppid(), user.getOpenid());
            log.info("openID:{}\u83b7\u53d6browse:{}", (Object)user.getOpenid(), (Object)JSON.toJSONString((Object)browse));
            String sysStaffId = browse.getSysStaffId();
            String sysStoreId = browse.getSysStoreId();
            if (!StringUtils.isEmpty((String)sysStaffId)) {
                shopCart.setSysStaffId(sysStaffId);
            }
            if (!StringUtils.isEmpty((String)sysStoreId)) {
                shopCart.setSysStoreId(sysStoreId);
            }
        }
        log.info("BrowseWrapperService_fillBrowse_shopCart:{}", (Object)JSON.toJSONString((Object)shopCart));
    }

    public void fillBrowse(ViewShareGoodsInformRequestVO viewShareGoodsInformRequestVO, User user) {
        if (user != null) {
            BrowseVO browse = this.miniprogramUserService.getBrowse(user.getAppid(), user.getOpenid());
            log.info("openID:{}\u83b7\u53d6browse:{}", (Object)user.getOpenid(), (Object)JSON.toJSONString((Object)browse));
            String sysStaffId = browse.getSysStaffId();
            String sysStoreId = browse.getSysStoreId();
            if (!StringUtils.isEmpty((String)sysStaffId)) {
                viewShareGoodsInformRequestVO.setSysStaffId(sysStaffId);
            }
            if (!StringUtils.isEmpty((String)sysStoreId)) {
                viewShareGoodsInformRequestVO.setSysStoreId(sysStoreId);
            }
        }
        log.info("BrowseWrapperService_fillBrowse_viewShareGoodsInformRequestVO:{}", (Object)JSON.toJSONString((Object)viewShareGoodsInformRequestVO));
    }
}

