/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.baison.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.baison.dto.BaisonAccessTokenRequestDTO;
import com.wmeimob.fastboot.bizvane.utils.MD5Util;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaisonUtil {
    private static final Logger log = LoggerFactory.getLogger(BaisonUtil.class);
    private static final String KEY = "key";
    private static final String SIGN = "sign";
    private static final String REQUESTTIME = "requestTime";
    private static final String SECRET = "secret";
    private static final String VERSION = "version";
    private static final String SERVICETYPE = "serviceType";
    private static final String DATA = "data";
    private static final String SYMBOL_EQUAL_SIGN = "=";
    private static final String SYMBOL_AND = "&";
    private static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    private static final String FORMAT = "json";

    public static String appendParam(BaisonAccessTokenRequestDTO requestVO) {
        JSONObject jsonParam = JSON.parseObject((String)JSON.toJSONString((Object)requestVO));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SYMBOL_AND);
        stringBuilder.append(KEY).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(KEY)).append(SYMBOL_AND);
        stringBuilder.append(SIGN).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(SIGN)).append(SYMBOL_AND);
        stringBuilder.append(REQUESTTIME).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(REQUESTTIME)).append(SYMBOL_AND);
        stringBuilder.append(VERSION).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(VERSION)).append(SYMBOL_AND);
        stringBuilder.append(SERVICETYPE).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(SERVICETYPE)).append(SYMBOL_AND);
        stringBuilder.append(DATA).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(DATA));
        return stringBuilder.toString();
    }

    public static String generateTokenSign(BaisonAccessTokenRequestDTO requestVO) {
        JSONObject jsonParam = JSON.parseObject((String)JSON.toJSONString((Object)requestVO));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(KEY).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(KEY)).append(SYMBOL_AND);
        stringBuilder.append(REQUESTTIME).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(REQUESTTIME)).append(SYMBOL_AND);
        stringBuilder.append(SECRET).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(SECRET)).append(SYMBOL_AND);
        stringBuilder.append(VERSION).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(VERSION)).append(SYMBOL_AND);
        stringBuilder.append(SERVICETYPE).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(SERVICETYPE)).append(SYMBOL_AND);
        stringBuilder.append(DATA).append(SYMBOL_EQUAL_SIGN).append(jsonParam.getString(DATA));
        System.out.println(stringBuilder);
        return MD5Util.getMD5Str32(stringBuilder.toString());
    }

    public static String getRequestTime() {
        LocalDateTime time = LocalDateTime.now(ZoneId.systemDefault());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS);
        return dateTimeFormatter.format(time);
    }
}

