/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.vo.admin;

import com.wmeimob.fastboot.bizvane.constants.admin.GoodsConstant;
import com.wmeimob.fastboot.bizvane.vo.admin.GoodsExportTempleVO;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class GoodsExportCheck {
    private static final Logger log = LoggerFactory.getLogger(GoodsExportCheck.class);

    public static boolean checkParam(GoodsExportTempleVO goodsExportTempleVO) {
        String specType;
        Integer specTypeValue;
        String firstCategory;
        String errorMsg = null;
        String goodsNo = goodsExportTempleVO.getGoodsNo();
        if (StringUtils.isEmpty((Object)goodsNo)) {
            errorMsg = "\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String goodsName = goodsExportTempleVO.getGoodsName();
        if (StringUtils.isEmpty((Object)goodsName)) {
            errorMsg = "\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String secondCategory = goodsExportTempleVO.getSecondCategory();
        if (!StringUtils.isEmpty((Object)secondCategory) && StringUtils.isEmpty((Object)(firstCategory = goodsExportTempleVO.getFirstCategory()))) {
            errorMsg = "\u5546\u54c1\u4e8c\u7ea7\u5206\u7c7b\u4e0d\u4e3a\u7a7a\u65f6,\u5546\u54c1\u4e00\u7ea7\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        firstCategory = goodsExportTempleVO.getFirstCategory();
        if (StringUtils.isEmpty((Object)firstCategory)) {
            goodsExportTempleVO.setFirstCategory("");
        }
        if ((specTypeValue = GoodsExportCheck.parseInteger(specType = goodsExportTempleVO.getSpecType())) == null) {
            errorMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u89c4\u683c\u7c7b\u578b";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        if (GoodsConstant.SINGLE_SPECIFICATION != specTypeValue && GoodsConstant.MULTI_SPECIFICATION != specTypeValue) {
            errorMsg = "\u89c4\u683c\u7c7b\u578b\u53ea\u80fd\u4e3a0\u62161";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String salePrice = goodsExportTempleVO.getSalePrice();
        if (StringUtils.isEmpty((Object)salePrice)) {
            errorMsg = "\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        BigDecimal salePriceValue = GoodsExportCheck.parseBigDecimal(salePrice);
        if (salePriceValue == null) {
            errorMsg = "\u8bf7\u586b\u5199\u6b63\u786e\u552e\u4ef7";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String tagPrice = goodsExportTempleVO.getTagPrice();
        if (StringUtils.isEmpty((Object)tagPrice)) {
            errorMsg = "\u540a\u724c\u4ef7\u4e0d\u80fd\u4e3a\u7a7a";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        BigDecimal tagPriceValue = GoodsExportCheck.parseBigDecimal(salePrice);
        if (tagPriceValue == null) {
            errorMsg = "\u8bf7\u586b\u5199\u6b63\u786e\u540a\u724c\u4ef7";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        int i = new BigDecimal(salePrice).compareTo(new BigDecimal(tagPrice));
        if (i == 1) {
            errorMsg = "\u552e\u4ef7\u4e0d\u80fd\u5927\u4e8e\u540a\u724c\u4ef7";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String isGift = goodsExportTempleVO.getIsGift();
        Integer isGiftValue = GoodsExportCheck.parseInteger(isGift);
        if (isGiftValue == null) {
            errorMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u8d60\u54c1\u7c7b\u578b";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        if (GoodsConstant.IS_GIFT != isGiftValue && GoodsConstant.IS_NOT_GIFT != isGiftValue) {
            errorMsg = "\u662f\u5426\u4e3a\u8d60\u54c1\u53ea\u80fd\u4e3a0\u62161";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String shoppingMode = goodsExportTempleVO.getShoppingMode();
        Integer shoppingModeValue = GoodsExportCheck.parseInteger(shoppingMode);
        if (shoppingModeValue == null) {
            errorMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u914d\u9001\u65b9\u5f0f";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        if (GoodsConstant.SHOPPING_MODE_TO_HOME == shoppingModeValue) {
            goodsExportTempleVO.setShoppingMode("0");
        } else if (GoodsConstant.SHOPPING_MODE_TO_STORE == shoppingModeValue) {
            goodsExportTempleVO.setShoppingMode("1");
        } else if (GoodsConstant.SHOPPING_MODE_TO_OPTIONAL == shoppingModeValue) {
            goodsExportTempleVO.setShoppingMode("2");
        } else {
            errorMsg = "\u914d\u9001\u65b9\u5f0f\u53ea\u80fd\u4e3a1\uff0c2\uff0c3";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String commissionRate = goodsExportTempleVO.getCommissionRate();
        if (StringUtils.isEmpty((Object)commissionRate)) {
            goodsExportTempleVO.setCommissionRate("0");
        } else {
            BigDecimal commissionRateValue = GoodsExportCheck.parseBigDecimal(commissionRate);
            if (commissionRateValue == null) {
                errorMsg = "\u8bf7\u586b\u5199\u6b63\u786e\u5206\u4f63\u767e\u5206\u6bd4";
                goodsExportTempleVO.setErrorMsg(errorMsg);
                return Boolean.FALSE;
            }
        }
        String priceType = goodsExportTempleVO.getPriceType();
        Integer priceTypeValue = GoodsExportCheck.parseInteger(priceType);
        if (priceTypeValue == GoodsConstant.PRICE_TYPE_CASH) {
            goodsExportTempleVO.setPriceType("0");
        } else if (priceTypeValue == GoodsConstant.PRICE_TYPE_CASH_AND_INTEGRAL) {
            goodsExportTempleVO.setPriceType("1");
        } else if (priceTypeValue == GoodsConstant.PRICE_TYPE_INTEGRAL) {
            goodsExportTempleVO.setPriceType("2");
        } else {
            errorMsg = "\u4ef7\u683c\u7c7b\u578b\u53ea\u80fd\u4e3a1\uff0c2\uff0c3";
            goodsExportTempleVO.setErrorMsg(errorMsg);
            return Boolean.FALSE;
        }
        String sort = goodsExportTempleVO.getSort();
        if (StringUtils.isEmpty((Object)sort)) {
            goodsExportTempleVO.setSort("0");
        } else {
            Integer sortValue = GoodsExportCheck.parseInteger(sort);
            if (sortValue == null) {
                errorMsg = "\u8bf7\u586b\u5199\u6b63\u786e\u6392\u5e8f\u503c";
                goodsExportTempleVO.setErrorMsg(errorMsg);
                return Boolean.FALSE;
            }
        }
        String limitation = goodsExportTempleVO.getLimitation();
        if (StringUtils.isEmpty((Object)limitation)) {
            goodsExportTempleVO.setSort("0");
        } else {
            Integer limitationValue = GoodsExportCheck.parseInteger(limitation);
            if (limitationValue == null) {
                errorMsg = "\u8bf7\u586b\u5199\u6b63\u786e\u9650\u8d2d\u6570\u91cf";
                goodsExportTempleVO.setErrorMsg(errorMsg);
                return Boolean.FALSE;
            }
        }
        goodsExportTempleVO.setIsShelved(GoodsConstant.IS_NOT_SHELVED.toString());
        return Boolean.TRUE;
    }

    private static BigDecimal parseBigDecimal(String param) {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bigDecimal;
    }

    private static Integer parseInteger(String param) {
        Integer integer = null;
        try {
            integer = Double.valueOf(param).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return integer;
    }

    public static void main(String[] args) {
        int i = new BigDecimal("102.0").compareTo(new BigDecimal("101.0"));
        System.out.println(i);
    }
}

