/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.exception;

import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.exception.GlobalExceptionHandler;
import com.wmeimob.fastboot.core.rest.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;

@ControllerAdvice
@RestController
public class MallCommonExceptionHandler
extends GlobalExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @ExceptionHandler(value={MallCommonException.class})
    public RestResult mallWechatException(MallCommonException e) {
        this.logger.warn(e.getMessage());
        return RestResult.msg((int)HttpStatus.I_AM_A_TEAPOT.value(), (String)e.getMessage());
    }

    @ExceptionHandler(value={CustomException.class})
    public RestResult customException(CustomException e) {
        this.logger.warn(e.getMessage());
        return RestResult.msg((int)HttpStatus.I_AM_A_TEAPOT.value(), (String)e.getMessage());
    }

    @ExceptionHandler(value={UserException.class})
    public RestResult userException(UserException e) {
        this.logger.warn(e.getMessage());
        return RestResult.msg((int)HttpStatus.NOT_ACCEPTABLE.value(), (String)e.getMessage());
    }
}

