/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane;

import com.wmeimob.fastboot.bizvane.CommonUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;

public class HttpHelper {
    public static Map<String, String> prepareTransfer(WechatMch wechatMch, WechatMp wechatMp, String openid, String amount, String ip, String orderNo) {
        HashMap<String, String> redPack = new HashMap<String, String>();
        redPack.put("nonce_str", HttpHelper.randomString());
        redPack.put("partner_trade_no", orderNo);
        redPack.put("mchid", wechatMch.getMchNo());
        redPack.put("mch_appid", wechatMp.getAppid());
        redPack.put("openid", openid);
        redPack.put("check_name", "NO_CHECK");
        redPack.put("amount", amount);
        redPack.put("desc", "\u63d0\u73b0");
        redPack.put("spbill_create_ip", ip);
        redPack.put("sign", CommonUtil.signature_MD5(redPack, wechatMch.getMchKey()));
        return redPack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String payPost(WechatMch wechatMch, String url, String param, InputStream inputStream) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(HttpHelper.getSSLContext(wechatMch, inputStream).getSocketFactory());
            }
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = conn.getResponseCode() == 200 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            String line = "";
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private static SSLContext getSSLContext(WechatMch wechatMch, InputStream inputStream) {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(HttpHelper.getkeyStore(wechatMch, inputStream), wechatMch.getMchNo().toCharArray());
            KeyManager[] keyManagers = kmf.getKeyManagers();
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(keyManagers, null, new SecureRandom());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            return sslContext;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static KeyStore getkeyStore(WechatMch wechatMch, InputStream inputStream) {
        KeyStore keySotre = null;
        try {
            keySotre = KeyStore.getInstance("PKCS12");
            keySotre.load(inputStream, wechatMch.getMchNo().toCharArray());
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keySotre;
    }

    private static String randomString() {
        StringBuilder sb = new StringBuilder();
        sb.append(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        sb.append(String.valueOf(System.currentTimeMillis()).substring(5));
        sb.append(String.valueOf(new Random(System.currentTimeMillis()).nextInt(90) + 10));
        return sb.toString();
    }
}

