/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.dto.SysDimSkuPoDto;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OffLineInfoHandlerServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(OffLineInfoHandlerServiceImpl.class);
    @Autowired
    public BizvaneInterface bizvaneInterface;

    public List<RefundOrder> queryOfflineMemberInfoRefund(CompanyBrandRelation companyBrandRelation, List<RefundOrder> list) {
        JSONObject offlineMemberInfo = null;
        try {
            offlineMemberInfo = this.bizvaneInterface.getOfflineMemberInfo(companyBrandRelation.getCompanyId(), companyBrandRelation.getMerchantId(), list.get(0).getUserNo());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new CustomException("\u83b7\u53d6\u4f1a\u5458\u7684\u7ebf\u4e0b\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (offlineMemberInfo != null) {
            JSONObject data = offlineMemberInfo.getJSONObject("data");
            String erpId = (String)data.get((Object)"erpId");
            String cardNo = (String)data.get((Object)"cardNo");
            String serviceStoreId = data.getString("storeId");
            String serviceStoreCode = (String)data.get((Object)"serviceStoreCode");
            String serviceGuideCode = (String)data.get((Object)"serviceGuideCode");
            String serviceGuideId = data.getString("staffId");
            String name = (String)data.get((Object)"name");
            for (RefundOrder refundOrder : list) {
                refundOrder.setErpId(erpId);
                refundOrder.setOfflineCardNo(cardNo);
                refundOrder.setErpStoreId(serviceStoreId);
                refundOrder.setErpStoreCode(serviceStoreCode);
                refundOrder.setErpGuideCode(serviceGuideCode);
                refundOrder.setErpGuideId(serviceGuideId);
                refundOrder.setVipName(name);
            }
        }
        log.info("\u5904\u7406\u5b8c\u6210\u9000\u5355\u6570\u636e:[{}]", JSON.toJSON((Object)list.get(0)));
        return list;
    }

    public List<Orders> queryOfflineMemberInfoOrders(CompanyBrandRelation companyBrandRelation, List<Orders> list) {
        JSONObject offlineMemberInfo = null;
        try {
            offlineMemberInfo = this.bizvaneInterface.getOfflineMemberInfo(companyBrandRelation.getCompanyId(), companyBrandRelation.getMerchantId(), list.get(0).getUserNo());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new CustomException("\u83b7\u53d6\u4f1a\u5458\u7684\u7ebf\u4e0b\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (offlineMemberInfo != null) {
            JSONObject data = offlineMemberInfo.getJSONObject("data");
            String erpId = data.getString("erpId");
            String cardNo = data.getString("cardNo");
            String serviceStoreId = data.getString("storeId");
            String serviceStoreCode = data.getString("serviceStoreCode");
            String serviceGuideCode = data.getString("serviceGuideCode");
            String serviceGuideId = data.getString("staffId");
            String name = data.getString("name");
            for (Orders orders : list) {
                orders.setErpId(erpId);
                orders.setOfflineCardNo(cardNo);
                orders.setErpStoreId(serviceStoreId);
                orders.setErpStoreCode(serviceStoreCode);
                orders.setErpGuideCode(serviceGuideCode);
                orders.setErpGuideId(serviceGuideId);
                orders.setVipName(name);
            }
        }
        log.info("\u5904\u7406\u5b8c\u6210\u8ba2\u5355\u6570\u636e:[{}]", JSON.toJSON((Object)list.get(0)));
        return list;
    }

    public List<RefundOrder> extractRefundValueInsertIntoList(List<SysDimSkuPoDto> dspList, List<RefundOrder> list) {
        if (!CollectionUtils.isEmpty(dspList)) {
            block0: for (SysDimSkuPoDto sd : dspList) {
                if ("\u6210\u529f".equals(sd.getFailReason())) {
                    for (RefundOrder refundOrder : list) {
                        for (OrderItems item : refundOrder.getItems()) {
                            if (!sd.getProductCode().equals(item.getGoodsNo()) || !sd.getSkuCode().equals(item.getGoodsSkuNo())) continue;
                            item.setCode(sd.getProductId());
                            item.setSkuCode(sd.getSkuCode());
                            item.setOfflineSkuId(sd.getSkuId());
                            item.setOfflineGoodsId(sd.getProductId());
                            continue block0;
                        }
                    }
                    continue;
                }
                log.error("\u6839\u636ecompanyId:{},brandId:{},goodsNo:{},skuNO:{}\u83b7\u53d6\u4e2d\u53f0\u7ebf\u4e0b\u6570\u636e\u5931\u8d25\uff0creason:{}", new Object[]{sd.getSysCompanyId(), sd.getSysBrandId(), sd.getProductCode(), sd.getSkuCode(), sd.getFailReason()});
            }
        }
        return list;
    }

    public List<Orders> extractOrdersValueInsertIntoList(List<SysDimSkuPoDto> dspList, List<Orders> list) {
        if (!CollectionUtils.isEmpty(dspList)) {
            block0: for (SysDimSkuPoDto sd : dspList) {
                if ("\u6210\u529f".equals(sd.getFailReason())) {
                    for (Orders orders : list) {
                        for (OrderItems item : orders.getItems()) {
                            if (!sd.getProductCode().equals(item.getGoodsNo()) || !sd.getSkuCode().equals(item.getGoodsSkuNo())) continue;
                            item.setCode(sd.getProductCode());
                            item.setSkuCode(sd.getSkuCode());
                            item.setOfflineSkuId(sd.getSkuId());
                            item.setOfflineGoodsId(sd.getProductId());
                            continue block0;
                        }
                    }
                    continue;
                }
                log.error("\u6839\u636ecompanyId:{},brandId:{},goodsNo:{},skuNO:{}\u83b7\u53d6\u4e2d\u53f0\u7ebf\u4e0b\u6570\u636e\u5931\u8d25\uff0creason:{}", new Object[]{sd.getSysCompanyId(), sd.getSysBrandId(), sd.getProductCode(), sd.getSkuCode(), sd.getFailReason()});
            }
        }
        return list;
    }

    public List<SysDimSkuPoDto> offLineInfoHandler(List<SysDimSkuPoDto> param) {
        log.info("----------->\u83b7\u53d6\u4e2d\u53f0\u7ebf\u4e0b\u5546\u54c1\u6570\u636e:\u5165\u53c2:[{}]", JSON.toJSON(param));
        List offLineGoodsInfo = this.bizvaneInterface.getOffLineGoodsInfo(param);
        log.info("----------->\u83b7\u53d6\u4e2d\u53f0\u7ebf\u4e0b\u5546\u54c1\u6570\u636e:\u8fd4\u53c2:[{}]", JSON.toJSON((Object)offLineGoodsInfo));
        return offLineGoodsInfo;
    }
}

