/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils.admin;

import com.wmeimob.fastboot.bizvane.enums.admin.ExportTempleHelp;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTempleUtil {
    private static final Logger log = LoggerFactory.getLogger(ExportTempleUtil.class);
    private static final List<String> packages = new ArrayList<String>(){};

    public static ExportTempleHelp transfer(Class exportTempleEnum) throws Exception {
        if (exportTempleEnum == null) {
            throw new ClassNotFoundException("\u8bf7\u8f93\u5165\u6b63\u786e\u53c2\u6570");
        }
        String packageName = exportTempleEnum.getPackage().getName();
        if (!packages.contains(packageName)) {
            throw new Exception("\u8bf7\u8f93\u5165\u6b63\u786e\u8def\u5f84");
        }
        T[] objects = exportTempleEnum.getEnumConstants();
        Method getId = exportTempleEnum.getMethod("getId", new Class[0]);
        Method getField = exportTempleEnum.getMethod("getField", new Class[0]);
        Method getNote = exportTempleEnum.getMethod("getNote", new Class[0]);
        ExportTempleHelp exportTempleHelp = new ExportTempleHelp();
        ArrayList<String> fieldsList = new ArrayList<String>();
        ArrayList<String> notesList = new ArrayList<String>();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        String[] fields = new String[objects.length];
        String[] notes = new String[objects.length];
        Integer[] ids = new Integer[objects.length];
        for (Object object : objects) {
            Integer id = (Integer)getId.invoke(object, new Object[0]);
            String field = getField.invoke(object, new Object[0]).toString();
            String note = getNote.invoke(object, new Object[0]).toString();
            fieldsList.add(id, field);
            notesList.add(id, note);
            idList.add(id, id);
            fields[id.intValue()] = field;
            notes[id.intValue()] = note;
            ids[id.intValue()] = id;
        }
        exportTempleHelp.setFieldsList(fieldsList);
        exportTempleHelp.setNotesList(notesList);
        exportTempleHelp.setFields(fields);
        exportTempleHelp.setNotes(notes);
        exportTempleHelp.setIds(ids);
        exportTempleHelp.setIdList(idList);
        return exportTempleHelp;
    }

    static {
        packages.add("com.wmeimob.fastboot.bizvane.enums.admin");
    }
}

