/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mzlion.core.json.gson.JsonUtil;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonResponseDTO;
import com.wmeimob.fastboot.baison.utils.BaisonUtil2;
import com.wmeimob.fastboot.baison.utils.RetryUtil;
import com.wmeimob.fastboot.bizvane.entity.RetryInfoRecord;
import com.wmeimob.fastboot.bizvane.mapper.RetryInfoRecordMapper;
import com.wmeimob.fastboot.bizvane.service.RetryService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetryServiceImpl
implements RetryService {
    private static final Logger log = LoggerFactory.getLogger(RetryServiceImpl.class);
    @Autowired
    private RetryInfoRecordMapper retryInfoRecordMapper;
    @Autowired
    private RetryService retryService;
    @Autowired
    private BaisonUtil2 baisonUtil2;

    @Override
    public PageInfo<RetryInfoRecord> retryE3Interface(Integer id) {
        log.info("=============E3\u63a5\u53e3\u91cd\u8bd5==========\u8bb0\u5f55id====" + JSONObject.toJSONString((Object)id));
        RetryInfoRecord retryInfoRecord = (RetryInfoRecord)this.retryInfoRecordMapper.selectByPrimaryKey(id);
        String params = retryInfoRecord.getRequestParams();
        String retryInterface = retryInfoRecord.getRetryInterface();
        String newParams = "";
        newParams = params.contains("serviceType") ? JsonUtil.toJson((Object)params, (String[])new String[]{"serviceType"}) : params;
        BaisonResponseDTO post = null;
        try {
            post = this.baisonUtil2.getBaiSonE3Response(retryInterface, newParams);
        }
        catch (Exception e) {
            log.info("===\u91cd\u8bd5====" + retryInterface + "========\u63a5\u53e3\u5f02\u5e38===========:{}", (Object[])e.getStackTrace());
            e.printStackTrace();
        }
        RetryInfoRecord infoRecord = new RetryInfoRecord();
        infoRecord.setIsRetry(Boolean.TRUE);
        if ("api-success".equals(post.getStatus())) {
            infoRecord.setRecordStatus(1);
        } else {
            infoRecord.setRecordStatus(0);
            RetryInfoRecord infoRecord2 = new RetryInfoRecord();
            infoRecord.setClassName(RetryUtil.getClassName());
            infoRecord.setMethodName(RetryUtil.getMethodName());
            infoRecord.setErrorReason(JsonUtil.toJson((Object)post, (String[])new String[]{"data"}));
            infoRecord.setRequestParams(newParams);
            infoRecord.setRetryInterface("order.detail.add");
            infoRecord.setRetryCount(infoRecord.getRetryCount() + 1);
            int count = 0;
            try {
                count = this.retryInfoRecordMapper.insertSelective(infoRecord);
            }
            catch (Exception e1) {
                log.info("\u6301\u4e45\u5316\u5f02\u5e38\u8bb0\u5f55\u5931\u8d25:{}", (Object[])e1.getStackTrace());
            }
        }
        this.retryInfoRecordMapper.updateByPrimaryKeySelective(infoRecord);
        PageInfo<RetryInfoRecord> retryList = this.retryService.getRetryList(1, 50);
        return retryList;
    }

    @Override
    public PageInfo<RetryInfoRecord> getRetryList(Integer pageNumber, Integer pageSize) {
        log.info("========\u8fdb\u5165\u91cd\u8bd5\u8bb0\u5f55\u5217\u8868\u67e5\u8be2============params:pageNumber={},pageSize={}", (Object)pageNumber, (Object)pageSize);
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        List retryInfoRecords = this.retryInfoRecordMapper.selectAll();
        PageInfo pageInfo = new PageInfo(retryInfoRecords);
        return pageInfo;
    }
}

