/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.OrderGift;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.OrdersCommission;
import com.wmeimob.fastboot.bizvane.entity.OrdersFullGift;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatusEnum;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersCommissionMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersFullGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.UserCommissionAccountsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.RefundOrderPOMapper;
import com.wmeimob.fastboot.bizvane.po.RefundOrderPO;
import com.wmeimob.fastboot.bizvane.po.RefundOrderPOExample;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service(value="commonOrdersServiceImpl")
public class CommonOrdersServiceImpl
implements OrdersService {
    private static final Logger log = LoggerFactory.getLogger(CommonOrdersServiceImpl.class);
    @Resource
    private OrdersMapper ordersMapper;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Resource
    private UserCommissionAccountsMapper userCommissionAccountsMapper;
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private OrderGiftMapper orderGiftMapper;
    @Resource
    private OrdersFullGiftMapper ordersFullGiftMapper;
    @Autowired
    private OrdersCommissionMapper ordersCommissionMapper;
    @Autowired
    private RefundOrderPOMapper refundOrderPOMapper;
    private static final ScheduledThreadPoolExecutor SCHEDULED4COMMISSION = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("wechat-loreal-commission-pool-%d").build());

    public Orders findById(Integer id) {
        Orders param = new Orders();
        param.setId(id);
        Orders orders = this.ordersMapper.selectOrdersDetailById(param);
        Assert.notNull((Object)orders, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        if (OrdersStatusEnum.TRADE.equals((Object)orders.getOrderStatus()) && PayStatusEnum.UN_PAY.equals((Object)orders.getPayStatus())) {
            Config config = new Config();
            config.setMerchantId(orders.getMerchantId());
            Config queryConfig = (Config)this.configService.findOneByCondition(config);
            Integer settingCloseMini = queryConfig.getAwaitOrderPayMinute();
            Date date = new Date();
            long result = orders.getGmtCreate().getTime() + (long)(settingCloseMini * 60) * 1000L;
            date.setTime(new Date().getTime() - result);
            orders.setPayDeadLine(date);
        }
        orders.getItems().forEach(orderItems -> {
            BigDecimal integralAmount = BigDecimal.valueOf(0.0);
            BigDecimal deductionBalance = BigDecimal.valueOf(0.0);
            BigDecimal itemsPayMount = BigDecimal.valueOf(0.0);
            log.info("\u67e5\u8be2\u5230\u7684\u8ba2\u5355\u660e\u7ec6\u4e3a:{}", JSON.toJSON((Object)orderItems));
            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey(orderItems.getGoodsId());
            orderItems.setGoodsNo(goods != null ? goods.getGoodsNo() : null);
            Example example = new Example(OrderGift.class);
            example.createCriteria().andEqualTo("orderId", (Object)orderItems.getOrderId()).andEqualTo("orderItemId", (Object)orderItems.getId()).andEqualTo("skuNo", (Object)orderItems.getGoodsSkuNo());
            List gifts = this.orderGiftMapper.selectByExample(example);
            orderItems.setGifts(gifts);
            orders.setGifts(gifts);
        });
        Example example = new Example(OrdersFullGift.class);
        example.createCriteria().andEqualTo("orderId", (Object)id);
        List fullGifts = this.ordersFullGiftMapper.selectByExample(example);
        if (fullGifts.size() > 0) {
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            fullGifts.forEach(ordersFullGift -> {
                Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey(ordersFullGift.getGoodId());
                goods.setCount(ordersFullGift.getGoodNum());
                goodsList.add(goods);
            });
            orders.setFullGifts(goodsList);
        }
        return orders;
    }

    @Override
    public void confirm(Orders orders1) {
        log.info("\u786e\u8ba4\u6536\u8d27\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)orders1));
        if (orders1.getUserId() == null) {
            throw new UserException();
        }
        Assert.notNull((Object)orders1.getId(), (String)"\u8ba2\u5355ID");
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("userId", (Object)orders1.getUserId()).andEqualTo("id", (Object)orders1.getId());
        Orders orders = this.ordersMapper.selectByIdAndUserId(orders1.getUserId(), orders1.getId());
        if (orders == null) {
            throw new CustomException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!PayStatusEnum.SUCCESS.equals((Object)orders.getPayStatus())) {
            throw new CustomException("\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        if (!LogisticsStatusEnum.SEND.equals((Object)orders.getLogisticsStatus())) {
            throw new CustomException("\u8ba2\u5355\u672a\u53d1\u8d27\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        RefundOrderPOExample refundOrderPOExample = new RefundOrderPOExample();
        refundOrderPOExample.createCriteria().andValidEqualTo(1).andOrderNoEqualTo(orders.getOrderNo()).andAuditStatusNotEqualTo(new Byte("2"));
        List<RefundOrderPO> refundOrderPOS = this.refundOrderPOMapper.selectByExample(refundOrderPOExample);
        if (!CollectionUtils.isEmpty(refundOrderPOS)) {
            throw new CustomException("\u6b64\u8ba2\u5355\u5df2\u6709\u672a\u5904\u7406\u5b8c\u7684\u552e\u540e\u8ba2\u5355\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        log.info("\u65b0\u8ba2\u5355\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)orders));
        Date date = new Date();
        orders.setLogisticsStatus(LogisticsStatusEnum.RECEIVED);
        orders.setOrderStatus(OrdersStatusEnum.SUCCESS);
        orders.setReceiptAt(date);
        orders.setGmtModified(date);
        log.info("\u786e\u8ba4\u6536\u8d27\u4e4b\u524d:{}", (Object)orders.getCommission());
        log.info("\u786e\u8ba4\u6536\u83b7\u662f\u5426\u7ed3\u7b97:{}", (Object)orders.getIsSettleCommission());
        int result = this.ordersMapper.updateByExampleSelective(orders, example);
        if (result == 0) {
            log.error("\u786e\u8ba4\u6536\u8d27\u5931\u8d25 => {}", (Object)JSONObject.toJSONString((Object)orders));
            throw new CustomException("\u786e\u8ba4\u6536\u8d27\u5931\u8d25");
        }
        OrdersCommission ordersCommission = new OrdersCommission();
        ordersCommission.setOrderId(orders.getId().longValue());
        ordersCommission.setVersion(0);
        ordersCommission.setCreateDate(new Date());
        this.ordersCommissionMapper.insert(ordersCommission);
    }

    public List<Orders> findByCondition(Orders condition) {
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("merchantId", (Object)condition.getMerchantId()).andEqualTo("orderStatus", (Object)condition.getOrderStatus()).andEqualTo("logisticsStatus", (Object)condition.getLogisticsStatus()).andEqualTo("payStatus", (Object)condition.getPayStatus()).andCondition("DATEDIFF(SYSDATE(),receipt_at)>", (Object)condition.getCommissionCalcAfterReceiptDays()).andEqualTo("isSettleCommission", (Object)condition.getIsSettleCommission());
        return this.ordersMapper.selectByExample(example);
    }

    @Override
    public List<Orders> findEnabledCommissions(Integer merchantId) {
        Config config = this.configService.findSysConfig(merchantId);
        if (config == null || !config.getIsDistribution().booleanValue()) {
            return new ArrayList<Orders>();
        }
        Orders condition = new Orders();
        condition.setMerchantId(merchantId);
        condition.setEnabledCommission(true);
        condition.setOrderStatus(OrdersStatusEnum.SUCCESS);
        condition.setLogisticsStatus(LogisticsStatusEnum.RECEIVED);
        condition.setPayStatus(PayStatusEnum.SUCCESS);
        condition.setCommissionCalcAfterReceiptDays(config.getAwaitOrderReturn());
        condition.setIsSettleCommission(false);
        return this.findByCondition(condition);
    }

    @Override
    public void updateCommissionState(List<Orders> collect) {
        this.ordersMapper.updateCommissionsState(collect);
    }
}

