/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccountLogs;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccounts;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.mapper.UserCommissionAccountLogsMapper;
import com.wmeimob.fastboot.bizvane.mapper.UserCommissionAccountsMapper;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service(value="commonUserCommissionService")
public class CommonUserCommissionServiceImpl
implements UserCommissionService {
    private static final Logger log = LoggerFactory.getLogger(CommonUserCommissionServiceImpl.class);
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService ordersService;
    @Resource
    private UserCommissionAccountsMapper userCommissionAccountsMapper;
    @Resource
    private UserCommissionAccountLogsMapper userCommissionAccountLogsMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void settle(Integer merchantId) {
        String uuid = MDC.get((String)("commissionSettle" + merchantId));
        List<Orders> ordersList = this.ordersService.findEnabledCommissions(merchantId);
        boolean empty = CollectionUtils.isEmpty(ordersList);
        log.info("\u67e5\u8be2\u53c2\u4e0e\u4f63\u91d1\u7ed3\u7b97\u7684\u8ba2\u5355uuid:{},merchantId = {},empty:{}", new Object[]{uuid, merchantId, empty});
        if (empty) {
            return;
        }
        log.info("ordersList size:{}", (Object)ordersList.size());
        Date date = new Date();
        for (Orders orders : ordersList) {
            log.info("CommonUserCommissionServiceImpl # orders:{}", (Object)JSON.toJSONString((Object)orders));
            log.info("\u5f53\u524d\u8ba2\u5355\u6d88\u8d39\u8005\u7684\u4f63\u91d1\u8d26\u6237,\u8ba2\u5355\u53f7{},\u8ba2\u5355\u4e2d\u7684userNo:{}", (Object)orders.getOrderNo(), (Object)orders.getUserNo());
            UserCommissionAccounts accounts = this.getAccount(orders.getUserNo());
            UserCommissionAccounts parentAccount = this.getParentAccount(accounts);
            if (parentAccount == null) {
                log.info("\u6ca1\u6709\u4e0a\u7ea7\u7528\u6237\u4f63\u91d1\u7ed3\u7b97");
                continue;
            }
            log.info("\u83b7\u53d6\u4e0a\u7ea7\u4f63\u91d1\u8d26\u6237:{}", (Object)JSONObject.toJSONString((Object)parentAccount));
            BigDecimal currentCommission = parentAccount.getAmount();
            if (orders.getCommission().compareTo(BigDecimal.ZERO) == 0) {
                log.info("\u8ba2\u5355 {} ,\u4e0b\u5355\u7528\u6237\u7f16\u53f7{}, \u4f63\u91d1\u4e3a0\uff0c\u5ffd\u7565", (Object)orders.getOrderNo(), (Object)orders.getUserNo());
                continue;
            }
            parentAccount.setAmount(orders.getCommission());
            this.userCommissionAccountsMapper.incrementAmount(parentAccount);
            accounts.setContributionAmount(orders.getCommission());
            this.userCommissionAccountsMapper.incrementContributionAmount(accounts);
            UserCommissionAccountLogs accountLogs = new UserCommissionAccountLogs();
            accountLogs.setAccountAmount(currentCommission);
            accountLogs.setMerchantId(orders.getMerchantId());
            accountLogs.setRecordType((byte)1);
            accountLogs.setContributionAccountId(accounts.getId());
            accountLogs.setUserAccountId(parentAccount.getId());
            accountLogs.setOrderNo(orders.getOrderNo());
            accountLogs.setChangeType("order_commission");
            accountLogs.setChangedAt(date);
            accountLogs.setChangeAmount(orders.getCommission());
            accountLogs.setGmtCreate(date);
            accountLogs.setAuditor("");
            accountLogs.setAuditReback("");
            accountLogs.setAuditStatus((byte)0);
            accountLogs.setWithdrawType((byte)1);
            accountLogs.setWithdrawNo("");
            this.userCommissionAccountLogsMapper.insertSelective(accountLogs);
        }
        log.info("\u66f4\u65b0\u8ba2\u5355\u4f63\u91d1\u7ed3\u7b97\u72b6\u6001\uff0c\u4e2a\u6570{}", (Object)ordersList.size());
        this.ordersService.updateCommissionState(ordersList.stream().map(o -> {
            Orders orders = new Orders();
            orders.setId(o.getId());
            orders.setIsSettleCommission(true);
            orders.setSettledAt(new Date());
            return orders;
        }).collect(Collectors.toList()));
    }

    @Override
    public UserCommissionAccounts selectUserCommissionAccountByUserNo(String userNo) {
        return this.userCommissionAccountsMapper.selectUserCommissionAccountsByUserNo(userNo);
    }

    private UserCommissionAccounts getParentAccount(UserCommissionAccounts accounts) {
        UserCommissionAccounts userCommissionAccounts = this.getAccount(accounts.getUserNo());
        userCommissionAccounts = (UserCommissionAccounts)this.userCommissionAccountsMapper.selectByPrimaryKey(userCommissionAccounts.getPid());
        return userCommissionAccounts;
    }

    private UserCommissionAccounts getAccount(String userNo) {
        UserCommissionAccounts userCommissionAccounts = new UserCommissionAccounts();
        userCommissionAccounts.setUserNo(userNo);
        userCommissionAccounts = (UserCommissionAccounts)this.userCommissionAccountsMapper.selectOne(userCommissionAccounts);
        if (userCommissionAccounts == null) {
            log.error("\u7528\u6237" + userNo + "\u672a\u627e\u5230\u4f63\u91d1\u8d26\u6237");
            throw new UserException("\u7528\u6237" + userNo + "\u672a\u627e\u5230\u4f63\u91d1\u8d26\u6237");
        }
        return userCommissionAccounts;
    }

    @Override
    public UserCommissionAccounts selectByOpenId(String openId) {
        Example userCommissionAccountsExample = new Example(UserCommissionAccounts.class);
        userCommissionAccountsExample.createCriteria().andEqualTo("bindOpenId", (Object)openId);
        List userCommissionAccounts = this.userCommissionAccountsMapper.selectByExample(userCommissionAccountsExample);
        if (CollectionUtils.isEmpty((Collection)userCommissionAccounts)) {
            return null;
        }
        UserCommissionAccounts userCommissionAccountsObject = (UserCommissionAccounts)userCommissionAccounts.get(0);
        return userCommissionAccountsObject;
    }
}

