/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.dto.GoodsBusinessVO;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.ShopCart;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendMsgToQWServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(SendMsgToQWServiceImpl.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;

    public void sendGoodsMsg(Goods param, String memberCode, int type) {
        log.info("\u901a\u77e5\u4f01\u5fae\u5165\u53c2:[{}]", JSON.toJSON((Object)param));
        GoodsBusinessVO vo = new GoodsBusinessVO();
        this.convertData(vo, param, type);
        vo.setMemberCode(memberCode);
        this.scheduledThreadPoolExecutor.execute(() -> this.bizvaneInterface.notifyQw(vo));
    }

    private void convertData(GoodsBusinessVO vo, Goods param, int type) {
        BeanUtils.copyProperties((Object)param, (Object)vo);
        CompanyBrandRelation cbr = new CompanyBrandRelation();
        cbr.setMerchantId(param.getMerchantId());
        cbr = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne(cbr);
        vo.setBusinessType(type);
        vo.setSysBrandId(cbr.getMerchantId().longValue());
        vo.setSysCompanyId(cbr.getCompanyId().longValue());
        vo.setGoodsId(param.getId().longValue());
        vo.setGoodsImgs(param.getCoverImg());
        vo.setGoodsName(param.getGoodsName());
        vo.setGoodsNo(param.getGoodsNo());
        vo.setGoodsPrice(param.getSalePrice());
    }

    public void sendOrdersGoodssMsg(Orders param, int type) {
        log.info("\u901a\u77e5\u4f01\u5fae\u5165\u53c2:[{}]", JSON.toJSON((Object)param));
        ArrayList<GoodsBusinessVO> vo = new ArrayList<GoodsBusinessVO>();
        this.convertOrderItems(vo, param, type);
        this.scheduledThreadPoolExecutor.execute(() -> vo.forEach(e -> this.bizvaneInterface.notifyQw((GoodsBusinessVO)e)));
    }

    private void convertOrderItems(List<GoodsBusinessVO> vo, Orders param, int type) {
        CompanyBrandRelation cbr = new CompanyBrandRelation();
        cbr.setMerchantId(param.getMerchantId());
        cbr = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne(cbr);
        long merchantId = cbr.getMerchantId().intValue();
        long sysCompanyId = cbr.getCompanyId().intValue();
        vo = param.getItems().stream().map(e -> {
            GoodsBusinessVO tem = new GoodsBusinessVO();
            BeanUtils.copyProperties((Object)e, (Object)tem);
            tem.setBusinessType(type);
            tem.setSysBrandId(merchantId);
            tem.setSysCompanyId(sysCompanyId);
            tem.setGoodsId(param.getId().longValue());
            return tem;
        }).collect(Collectors.toList());
    }

    public void sendShopCartGoodsMsg(ShopCart param, int type) {
        log.info("\u901a\u77e5\u4f01\u5fae\u5165\u53c2:[{}]", JSON.toJSON((Object)param));
        GoodsBusinessVO vo = new GoodsBusinessVO();
        this.convertShopCartData(vo, param, type);
        this.scheduledThreadPoolExecutor.execute(() -> this.bizvaneInterface.notifyQw(vo));
    }

    private void convertShopCartData(GoodsBusinessVO vo, ShopCart param, int type) {
        BeanUtils.copyProperties((Object)param, (Object)vo);
        CompanyBrandRelation cbr = new CompanyBrandRelation();
        cbr.setMerchantId(param.getMerchantId());
        cbr = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne(cbr);
        vo.setBusinessType(type);
        vo.setSysBrandId(cbr.getMerchantId().longValue());
        vo.setSysCompanyId(cbr.getCompanyId().longValue());
        vo.setGoodsId(param.getGoodsId().longValue());
    }
}

