/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.idempotent;

import com.wmeimob.fastboot.bizvane.idempotent.Idempotent;
import com.wmeimob.fastboot.bizvane.idempotent.IdempotentKeyUtil;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCommands;

@Component
@Aspect
@ConditionalOnClass(value={RedisTemplate.class})
public class IdempotentAspect {
    private static final String KEY_TEMPLATE = "idempotent_%s";
    @Resource
    private RedisTemplate<String, String> redisTemplate;

    @Pointcut(value="@annotation(com.wmeimob.fastboot.bizvane.idempotent.Idempotent)")
    public void executeIdempotent() {
    }

    @Around(value="executeIdempotent()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        String key = String.format(KEY_TEMPLATE, idempotent.value() + "_" + IdempotentKeyUtil.generate(method, joinPoint.getArgs()));
        String redisRes = (String)this.redisTemplate.execute(conn -> ((JedisCommands)conn.getNativeConnection()).set(key, key, "NX", "PX", idempotent.expireMillis()));
        if (Objects.equals("OK", redisRes)) {
            return joinPoint.proceed();
        }
        return RestResult.fail((String)"\u60a8\u5df2\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }
}

