/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.wmeimob.fastboot.bizvane.entity.UserAddress;
import com.wmeimob.fastboot.bizvane.mapper.UserAddressMapper;
import com.wmeimob.fastboot.bizvane.service.UserAddressService;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class UserAddressServiceImpl
implements UserAddressService {
    @Resource
    private UserAddressMapper userAddressMapper;

    @Transactional(rollbackFor={RuntimeException.class})
    public UserAddress add(UserAddress userAddress) {
        this.checkParams(userAddress);
        if (userAddress.getIsDefault().booleanValue()) {
            this.cancelDefaultAddress(userAddress);
        }
        userAddress.setGmtCreate(new Date());
        this.userAddressMapper.insertSelective((Object)userAddress);
        return userAddress;
    }

    private void checkParams(UserAddress userAddress) {
        InputValidator.checkNull((Object)userAddress.getUserId(), (String)"\u7528\u6237ID");
        InputValidator.checkNull((Object)userAddress.getIsDefault(), (String)"\u662f\u5426\u9ed8\u8ba4\u9009\u4e2d");
        InputValidator.checkNull((Object)userAddress.getProvince(), (String)"\u7701\u4efd\u4fe1\u606f");
        InputValidator.checkNull((Object)userAddress.getCity(), (String)"\u57ce\u5e02\u4fe1\u606f");
        InputValidator.checkNull((Object)userAddress.getDistrict(), (String)"\u5730\u533a\u4fe1\u606f");
        InputValidator.checkEmpty((Object)userAddress.getAddress(), (String)"\u8be6\u7ec6\u5730\u5740\u4fe1\u606f");
        InputValidator.isMobile((String)userAddress.getMobile());
    }

    private void cancelDefaultAddress(UserAddress userAddress) {
        InputValidator.checkNull((Object)userAddress.getUserId(), (String)"user missing");
        Example example = new Example(UserAddress.class);
        example.createCriteria().andEqualTo("userId", (Object)userAddress.getUserId());
        UserAddress update = new UserAddress();
        update.setIsDefault(Boolean.valueOf(false));
        this.userAddressMapper.updateByExampleSelective((Object)update, (Object)example);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public int update(UserAddress userAddress) {
        this.checkParams(userAddress);
        if (userAddress.getIsDefault().booleanValue()) {
            this.cancelDefaultAddress(userAddress);
        }
        InputValidator.checkNull((Object)userAddress.getId(), (String)"id");
        userAddress.setGmtModified(new Date());
        Example example = new Example(UserAddress.class);
        example.createCriteria().andEqualTo("userId", (Object)userAddress.getUserId()).andEqualTo("id", (Object)userAddress.getId());
        return this.userAddressMapper.updateByExampleSelective((Object)userAddress, (Object)example);
    }

    public int delete(Integer id, UserAddress userAddress) {
        InputValidator.checkEmpty((Object)userAddress.getUserId(), (String)"user id");
        Example example = new Example(UserAddress.class);
        example.createCriteria().andEqualTo("userId", (Object)userAddress.getUserId()).andEqualTo("id", (Object)id);
        return this.userAddressMapper.deleteByExample((Object)example);
    }

    public List<UserAddress> findByCondition(UserAddress userAddress) {
        InputValidator.checkEmpty((Object)userAddress.getUserId(), (String)"user id");
        Example example = new Example(UserAddress.class);
        example.createCriteria().andEqualTo("userId", (Object)userAddress.getUserId());
        return this.userAddressMapper.selectByExample((Object)example);
    }

    public UserAddress queryDefault(UserAddress userAddress) {
        userAddress.setIsDefault(Boolean.valueOf(true));
        return (UserAddress)this.userAddressMapper.selectOne((Object)userAddress);
    }
}

