/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpec;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.event.OrderEvent;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class OrderDeliveryEventListener
implements ApplicationListener<OrderEvent> {
    private static final Logger log = LoggerFactory.getLogger(OrderDeliveryEventListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private GoodsSpecMapper goodsSpecMapper;

    public void onApplicationEvent(OrderEvent orderEvent) {
        this.scheduledThreadPoolExecutor.execute(() -> {
            block4: {
                try {
                    Orders orders = orderEvent.getOrders();
                    Orders puOrders = new Orders();
                    BeanUtils.copyProperties((Object)orders, (Object)puOrders);
                    Integer pushFlag = orderEvent.getPushFlag();
                    if (pushFlag == null || !pushFlag.equals(PushFlagEnum.SEND_ORDER.getPushFlag())) break block4;
                    log.info("\u8ba2\u5355\u53d1\u8d27\u63a8\u9001\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
                    log.info("\u8ba2\u5355\u53d1\u8d27\u63a8\u9001\u7ebf\u4e0b:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)orderEvent.getOrders()));
                    CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
                    companyBrandRelation.setMerchantId(orders.getMerchantId());
                    companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne((Object)companyBrandRelation);
                    puOrders.setSysCompanyId(companyBrandRelation.getCompanyId());
                    try {
                        puOrders.getItems().forEach(e -> {
                            String[] split;
                            String specIds = e.getSpecIds();
                            if (!StringUtils.isEmpty((Object)specIds) && (split = specIds.split(",")) != null && split.length > 0) {
                                GoodsSpec goodsSpec;
                                if (split.length >= 1) {
                                    goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey((Object)split[0]);
                                    e.setSpecCode(goodsSpec.getSpecCode());
                                }
                                if (split.length >= 2) {
                                    goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey((Object)split[1]);
                                    e.setSpecCode(e.getSpecCode() + "," + goodsSpec.getSpecCode());
                                }
                            }
                        });
                        log.info("\u5904\u7406\u5b8c\u6210\u53d1\u8d27\u6570\u636e:[{}]", JSON.toJSON((Object)puOrders));
                        this.bizvaneInterface.notifySendOrderInfo(puOrders);
                    }
                    catch (Exception e2) {
                        log.error("\u8ba2\u5355\u53d1\u8d27\u63a8\u9001\u7ebf\u4e0b\u5931\u8d25:msg:[{}]_[{}]", (Object)e2.getMessage(), (Object)e2);
                    }
                    log.info("\u8ba2\u5355\u53d1\u8d27\u63a8\u9001\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u7ed3\u675f----------->");
                }
                catch (Exception e3) {
                    log.error(e3.getMessage(), (Throwable)e3);
                }
            }
        });
    }
}

