/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DateUtil {
    public static final String YYYY_MM_DD_T_HH_MM_SS_SSS_0800 = "yyyy-MM-dd'T'HH:mm:ss.SSS+0800";
    public static String ymdhms = "yyyy-MM-dd HH:mm:ss";
    public static String ymdhmsS = "yyyy-MM-dd HH:mm:ss SSS";
    public static String ymd = "yyyy-MM-dd";
    public SimpleDateFormat ymdSDF = new SimpleDateFormat(ymd);
    private static String year = "yyyy";
    private static String month = "MM";
    private static String day = "dd";
    private static String yyyyMMdd_yd = "yyyyMMdd";
    public SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat(ymdhms);
    public SimpleDateFormat yearSDF = new SimpleDateFormat(year);
    public SimpleDateFormat monthSDF = new SimpleDateFormat(month);
    public SimpleDateFormat daySDF = new SimpleDateFormat(day);
    private static final ThreadLocal<DateFormat> messageFormat = new ThreadLocal();
    private static final ThreadLocal<DateFormat> messageFormatyyyyMMdd = new ThreadLocal();
    private static final ThreadLocal<DateFormat> messageFormatymdhms = new ThreadLocal();
    public static SimpleDateFormat yyyyMMddHHmm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat yyyyMMddHH_NOT_ = new SimpleDateFormat("yyyyMMdd");
    public static long DATEMM = 86400L;

    private static final DateFormat getYesterdayStringThreadLocal() {
        DateFormat format = messageFormat.get();
        if (format == null) {
            format = new SimpleDateFormat(yyyyMMdd_yd, Locale.getDefault());
            messageFormat.set(format);
        }
        return format;
    }

    private static final DateFormat getYesterdayyyyyMMddStringThreadLocal() {
        DateFormat format = messageFormatyyyyMMdd.get();
        if (format == null) {
            format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            messageFormatyyyyMMdd.set(format);
        }
        return format;
    }

    private static final DateFormat getYesterdayymdhmsStringThreadLocal() {
        DateFormat format = messageFormatymdhms.get();
        if (format == null) {
            format = new SimpleDateFormat(ymdhms, Locale.getDefault());
            messageFormatymdhms.set(format);
        }
        return format;
    }

    public String getCurrentTime() {
        return this.yyyyMMddHHmmss.format(new Date());
    }

    public static String getYesterdayYYYYMMDD() {
        Date date = new Date(System.currentTimeMillis() - DATEMM * 1000L);
        String str = yyyyMMdd.format(date);
        try {
            date = DateUtil.getYesterdayymdhmsStringThreadLocal().parse(str + " 00:00:00");
            return DateUtil.getYesterdayyyyyMMddStringThreadLocal().format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getStrDateByDay(String backDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, Integer.parseInt("-" + backDay));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public static String getStrDateByDayZore(String backDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, Integer.parseInt("-" + backDay));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public static String getStrDateByMonth(String backMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, Integer.parseInt("-" + backMonth));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public String getCurrentYear() {
        return this.yearSDF.format(new Date());
    }

    public String getCurrentMonth() {
        return this.monthSDF.format(new Date());
    }

    public String getCurrentDay() {
        return this.daySDF.format(new Date());
    }

    public String getCurrentymd() {
        return this.ymdSDF.format(new Date());
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long getTimeNumberToday() {
        Date date = new Date();
        String str = yyyyMMdd.format(date);
        try {
            date = yyyyMMdd.parse(str);
            return date.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getTodateString() {
        String str = yyyyMMddHH_NOT_.format(new Date());
        return str;
    }

    public static String getYesterdayString() {
        Date date = new Date(System.currentTimeMillis() - DATEMM * 1000L);
        String str = DateUtil.getYesterdayStringThreadLocal().format(date);
        return str;
    }

    public static Date getYesterDayZeroHour() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getStartDateOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getEndDateOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(11, 23);
        return cal.getTime();
    }

    public static String longToString(long date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dt2 = new Date(date * 1000L);
        String sDateTime = sdf.format(dt2);
        return sDateTime;
    }

    public static Date getTodayZeroHour() {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getYesterDay24Hour() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(10, 23);
        return cal.getTime();
    }

    public static Date stringToDate(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getStartDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 7);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 1);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 1);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 2);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static String givedTimeToBefer(String givedTime, long interval, String format_Date_Sign) {
        String tomorrow = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format_Date_Sign);
            Date gDate = sdf.parse(givedTime);
            long current = gDate.getTime();
            long beforeOrAfter = current - interval * 1000L;
            Date date = new Date(beforeOrAfter);
            tomorrow = new SimpleDateFormat(format_Date_Sign).format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tomorrow;
    }

    public static long stringToLong(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dt2 = null;
        long lTime = 0L;
        try {
            dt2 = sdf.parse(date);
            lTime = dt2.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return lTime;
    }

    public Map<String, String> getTwoDay(String endTime, String beginTime, boolean isEndTime) {
        Map<String, String> result = new HashMap<String, String>();
        if (endTime == null || endTime.equals("") || beginTime == null || beginTime.equals("")) {
            return null;
        }
        try {
            Date date = this.ymdSDF.parse(endTime);
            endTime = this.ymdSDF.format(date);
            Date mydate = this.ymdSDF.parse(beginTime);
            long day = (date.getTime() - mydate.getTime()) / 86400000L;
            result = DateUtil.getDate(endTime, Integer.parseInt(day + ""), isEndTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Integer getTwoDayInterval(String endTime, String beginTime, boolean isEndTime) {
        if (endTime == null || endTime.equals("") || beginTime == null || beginTime.equals("")) {
            return 0;
        }
        long day = 0L;
        try {
            Date date = this.ymdSDF.parse(endTime);
            endTime = this.ymdSDF.format(date);
            Date mydate = this.ymdSDF.parse(beginTime);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return 0;
        }
        return Integer.parseInt(day + "");
    }

    public static Map<String, String> getDate(String endTime, Integer interval, boolean isEndTime) {
        HashMap<String, String> result = new HashMap<String, String>();
        if ((interval == 0 || isEndTime) && isEndTime) {
            result.put(endTime, endTime);
        }
        if (interval > 0) {
            int begin;
            for (int i = begin = 0; i < interval; ++i) {
                endTime = DateUtil.givedTimeToBefer(endTime, DATEMM, ymd);
                result.put(endTime, endTime);
            }
        }
        return result;
    }

    public List<Long> getDatesBetweenTwoDate(String beginDate, String endDate) throws ParseException {
        Date bDate = this.ymdSDF.parse(beginDate);
        Date eDate = this.ymdSDF.parse(endDate);
        ArrayList<Long> lDate = new ArrayList<Long>();
        lDate.add(bDate.getTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(bDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!eDate.after(cal.getTime())) break;
            lDate.add(cal.getTime().getTime());
        }
        lDate.add(eDate.getTime());
        return lDate;
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static Date parse(String strDate, String pattern) {
        if (StringUtils.isEmpty((String)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String interceptFormat(String strDate, String originPattern, String newPattern) {
        if (StringUtils.isEmpty((String)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(newPattern);
        return df.format(DateUtil.stringToDate(strDate, originPattern));
    }

    public static String interceptFormat(String strDate) {
        if (StringUtils.isEmpty((String)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(ymd);
        return df.format(DateUtil.stringToDate(strDate, ymdhms));
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Date addHour(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, n);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, n);
        return cal.getTime();
    }

    public static int getIntervalDays(Date date, Date otherDate) {
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return (int)(time / 86400000L);
    }

    public static Long getIntervalMinutes(Date date, Date otherDate) {
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return time == 0L ? 0L : time / 60000L;
    }

    public int getDayOfMonth() {
        Calendar aCalendar = Calendar.getInstance(Locale.CHINA);
        int day = aCalendar.getActualMaximum(5);
        return day;
    }

    public static String getNow(String format) {
        return DateUtil.format(new Date(), format);
    }

    public static String getBirthFirst(String year) {
        if (StringUtils.isBlank((String)year)) {
            year = "0";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return String.valueOf(Integer.parseInt(format.format(new Date())) - Integer.valueOf(year)) + "-12-31 23:59:59";
    }

    public static String getBirthLast(String year) {
        if (StringUtils.isBlank((String)year)) {
            year = "100";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return String.valueOf(Integer.parseInt(format.format(new Date())) - Integer.valueOf(year)) + "-01-01 00:00:00";
    }

    public static String getAgeLast(Integer age) {
        if (age == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(1, -age.intValue());
        calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(calendar.getTime()) + " 00:00:00";
    }

    public static String getAgeFirst(Integer age) {
        if (age == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(1, -age.intValue());
        calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(calendar.getTime()) + " 23:59:59";
    }

    public static boolean isDateString(String dateValue, String dateFormat) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            Date date = simpleDateFormat.parse(dateValue);
            return dateValue.equals(simpleDateFormat.format(date));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String dateFormatT(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        return DateUtil.format(DateUtil.parse(str, ymdhms), YYYY_MM_DD_T_HH_MM_SS_SSS_0800);
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getStrDateByDayZore("10"));
    }
}

