/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.dto.SysDimSkuPoDto;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.MallLogs;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.MallLogsTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatus;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.enums.PushToWhereEnum;
import com.wmeimob.fastboot.bizvane.event.OrderEvent;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.MallLogsService;
import com.wmeimob.fastboot.bizvane.service.impl.OffLineInfoHandlerServiceImpl;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PaidOrderToOfflienListener
implements ApplicationListener<OrderEvent> {
    private static final Logger log = LoggerFactory.getLogger(PaidOrderToOfflienListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private OrdersMapper orderMapper;
    @Autowired
    private OffLineInfoHandlerServiceImpl offLineInfoHandlerServiceImpl;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private MallLogsService mallLogsService;
    @Autowired
    private GoodsMapper goodsMapper;

    public void onApplicationEvent(OrderEvent orderEvent) {
        this.scheduledThreadPoolExecutor.execute(() -> {
            block10: {
                try {
                    Orders orders = orderEvent.getOrders();
                    Orders puOrders = new Orders();
                    BeanUtils.copyProperties((Object)orders, (Object)puOrders);
                    Integer pushToWhere = orderEvent.getPushToWhere();
                    Integer pushFlag = orderEvent.getPushFlag();
                    Integer payStatus = orderEvent.getPayStatus();
                    if (payStatus == null || payStatus.equals(PayStatus.UN_PAY.getPayStatus())) {
                        return;
                    }
                    if (!pushFlag.equals(PushFlagEnum.PAID_ORDERS.getPushFlag()) && !pushFlag.equals(PushFlagEnum.ADD_PAID_ORDERS.getPushFlag()) || !pushToWhere.equals(PushToWhereEnum.TO_All.getPushToWhere()) && !pushToWhere.equals(PushToWhereEnum.TO_CONNECTOR.getPushToWhere())) break block10;
                    log.info("\u521b\u5efa\u8ba2\u5355\u63a8\u9001\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
                    log.info("\u65b0\u589e\u8ba2\u5355\u63a8\u9001\u7ebf\u4e0b:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)orderEvent.getOrders()));
                    ArrayList<SysDimSkuPoDto> param = new ArrayList<SysDimSkuPoDto>();
                    CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
                    companyBrandRelation.setMerchantId(puOrders.getMerchantId());
                    companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne(companyBrandRelation);
                    for (OrderItems item : puOrders.getItems()) {
                        SysDimSkuPoDto dto = new SysDimSkuPoDto();
                        Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey(item.getGoodsId());
                        dto.setProductCode(goods.getGoodsNo());
                        dto.setSkuCode(item.getGoodsSkuNo());
                        dto.setSysBrandId(companyBrandRelation.getMerchantId());
                        dto.setSysCompanyId(companyBrandRelation.getCompanyId());
                        param.add(dto);
                    }
                    List<Orders> list = new ArrayList<Orders>();
                    list.add(puOrders);
                    String s = null;
                    try {
                        List<SysDimSkuPoDto> dspList = this.offLineInfoHandlerServiceImpl.offLineInfoHandler(param);
                        list = this.offLineInfoHandlerServiceImpl.extractOrdersValueInsertIntoList(dspList, list);
                        list = this.offLineInfoHandlerServiceImpl.queryOfflineMemberInfoOrders(companyBrandRelation, list);
                        log.info("\u5904\u7406\u5b8c\u6210\u8ba2\u5355\u6570\u636e:[{}]", JSON.toJSON((Object)list.get(0)));
                        s = this.bizvaneInterface.notifyPaidOrderInfoOffLine(list.get(0));
                    }
                    catch (Exception e) {
                        log.error("\u63a8\u9001\u7ebf\u4e0b\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                        MallLogs mallLogs = new MallLogs();
                        mallLogs.setLogType(MallLogsTypeEnum.LOGS_PUSH_OFFLINE_ADD_ORDERS.getType() + "");
                        mallLogs.setLogContent(JSON.toJSONString((Object)puOrders));
                        mallLogs.setReason("\u65b0\u589e\u8ba2\u5355\u63a8\u9001\u7ebf\u4e0b");
                        mallLogs.setCrateTime(new Date());
                        mallLogs.setUpdateTime(mallLogs.getCrateTime());
                        mallLogs.setRecordNumber(0);
                        mallLogs.setStatus(0);
                        try {
                            this.mallLogsService.add(mallLogs);
                        }
                        catch (Exception ex) {
                            log.error("\u4fdd\u5b58\u65e5\u5fd7\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                        }
                    }
                    Orders od = new Orders();
                    od.setId(puOrders.getId());
                    if (!StringUtils.isEmpty((Object)s)) {
                        Integer result = "success".equals(s) ? 1 : 2;
                        od.setSynOfflineState(result);
                    } else {
                        od.setSynOfflineState(2);
                    }
                    this.orderMapper.updateByPrimaryKeySelective(od);
                    log.info("\u65b0\u589e\u8ba2\u5355\u63a8\u9001\u7ebf\u4e0b\u6210\u529f");
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

