/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.dto.SysDimSkuPoDto;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.MallLogs;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.MallLogsTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.event.OrderEvent;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.MallLogsService;
import com.wmeimob.fastboot.bizvane.service.impl.OffLineInfoHandlerServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class OrderDeliveryEventListener
implements ApplicationListener<OrderEvent> {
    private static final Logger log = LoggerFactory.getLogger(OrderDeliveryEventListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private OffLineInfoHandlerServiceImpl offLineInfoHandlerServiceImpl;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private MallLogsService mallLogsService;
    @Autowired
    private GoodsMapper goodsMapper;

    public void onApplicationEvent(OrderEvent orderEvent) {
        this.scheduledThreadPoolExecutor.execute(() -> {
            block7: {
                try {
                    Orders orders = orderEvent.getOrders();
                    Orders puOrders = new Orders();
                    BeanUtils.copyProperties((Object)orders, (Object)puOrders);
                    Integer pushFlag = orderEvent.getPushFlag();
                    if (pushFlag == null || !pushFlag.equals(PushFlagEnum.SEND_ORDER.getPushFlag())) break block7;
                    log.info("\u8ba2\u5355\u53d1\u8d27\u63a8\u9001\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
                    log.info("\u8ba2\u5355\u53d1\u8d27\u63a8\u9001\u7ebf\u4e0b:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)orderEvent.getOrders()));
                    ArrayList<SysDimSkuPoDto> param = new ArrayList<SysDimSkuPoDto>();
                    CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
                    companyBrandRelation.setMerchantId(orders.getMerchantId());
                    companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne(companyBrandRelation);
                    for (OrderItems item : puOrders.getItems()) {
                        SysDimSkuPoDto dto = new SysDimSkuPoDto();
                        Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey(item.getGoodsId());
                        dto.setProductCode(goods.getGoodsNo());
                        dto.setSkuCode(item.getGoodsSkuNo());
                        dto.setSysBrandId(companyBrandRelation.getMerchantId());
                        dto.setSysCompanyId(companyBrandRelation.getCompanyId());
                        param.add(dto);
                    }
                    List<Orders> list = new ArrayList<Orders>();
                    list.add(puOrders);
                    try {
                        List<SysDimSkuPoDto> dspList = this.offLineInfoHandlerServiceImpl.offLineInfoHandler(param);
                        list = this.offLineInfoHandlerServiceImpl.extractOrdersValueInsertIntoList(dspList, list);
                        list = this.offLineInfoHandlerServiceImpl.queryOfflineMemberInfoOrders(companyBrandRelation, list);
                        this.bizvaneInterface.notifySendOrderInfo(list.get(0));
                    }
                    catch (Exception e) {
                        log.error("\u63a8\u9001\u7ebf\u4e0b\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                        MallLogs mallLogs = new MallLogs();
                        mallLogs.setLogType(MallLogsTypeEnum.LOGS_PUSH_OFFLINE_SEND_ORDERS.getType() + "");
                        mallLogs.setLogContent(JSON.toJSONString((Object)puOrders));
                        mallLogs.setReason("\u8ba2\u5355\u53d1\u8d27\u63a8\u9001\u7ebf\u4e0b");
                        mallLogs.setCrateTime(new Date());
                        mallLogs.setUpdateTime(mallLogs.getCrateTime());
                        mallLogs.setRecordNumber(0);
                        mallLogs.setStatus(0);
                        try {
                            this.mallLogsService.add(mallLogs);
                        }
                        catch (Exception ex) {
                            log.error("\u4fdd\u5b58\u65e5\u5fd7\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                        }
                    }
                    log.info("\u8ba2\u5355\u53d1\u8d27\u63a8\u9001\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u7ed3\u675f----------->");
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

