/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.easyokhttp.HttpClient;
import com.mzlion.easyokhttp.request.PostRequest;
import com.wmeimob.fastboot.autoconfigure.qiniu.QiNiuProperties;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.config.WeixinProperties;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.dto.OrdersDTO;
import com.wmeimob.fastboot.bizvane.dto.RefundDTO;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.entity.KafkaTrack;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OperationTypeEnum;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.JSCode2SessionResponse;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BizvaneInterface {
    private static final Logger log = LoggerFactory.getLogger(BizvaneInterface.class);
    @Resource
    private BizvaneProperties bizvaneProperties;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private QiNiuProperties qiNiuProperties;
    @Resource
    private WeixinProperties weixinProperties;
    private static final long DAY_MILLISECOND = 86400000L;

    public JSONObject getMiniprogramRedirectConfiguration(final String appid) {
        String url = this.bizvaneProperties.getMiniprogramRedirectConfigUrl();
        HashMap map = new HashMap(){
            {
                this.put("appId", appid);
            }
        };
        JSONObject data = this.doPost(url, map, "\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u8df3\u8f6c\u914d\u7f6e").getJSONObject("data");
        return data;
    }

    public static CouponDTO getCouponDTOByDetailData(JSONObject data) {
        data.getJSONObject("couponEntityPO").put("validType", (Object)data.getJSONObject("couponDefinitionPO").getInteger("validType"));
        data.getJSONObject("couponEntityPO").put("validDay", (Object)data.getJSONObject("couponDefinitionPO").getInteger("validDay"));
        data.getJSONObject("couponEntityPO").put("superpositionMemberCard", (Object)data.getJSONObject("couponDefinitionPO").getInteger("superpositionMemberCard"));
        data.getJSONObject("couponEntityPO").put("minDiscount", (Object)data.getJSONObject("couponDefinitionPO").getInteger("minDiscount"));
        data.getJSONObject("couponEntityPO").put("minConsume", (Object)data.getJSONObject("couponDefinitionPO").getInteger("minConsume"));
        data.getJSONObject("couponEntityPO").put("maxPreferential", (Object)data.getJSONObject("couponDefinitionPO").getBigDecimal("maxPreferential"));
        data.getJSONObject("couponEntityPO").put("useChannel", (Object)data.getJSONObject("couponDefinitionPO").getInteger("useChannel"));
        CouponDTO couponDTO = BizvaneInterface.getCouponByJSON(data.getJSONObject("couponEntityPO"));
        return couponDTO;
    }

    public static CouponDTO getCouponByJSON(JSONObject data) {
        CouponDTO couponDTO = new CouponDTO();
        couponDTO.setId(data.getInteger("couponEntityId"));
        couponDTO.setCode(data.getString("couponCode"));
        couponDTO.setCouponName(data.getString("couponName"));
        couponDTO.setDefinitionId(data.getInteger("couponDefinitionId"));
        couponDTO.setInfo(data.getString("info"));
        couponDTO.setCouponType(CouponDTO.CouponTypeEnum.from(data.getInteger("preferentialType")));
        couponDTO.setMaxDiscountAmount(data.getBigDecimal("maxPreferential"));
        couponDTO.setCouponChannel(CouponDTO.CouponChannelEnum.from(data.getInteger("useChannel")));
        if (CouponDTO.CouponTypeEnum.CASH.equals((Object)couponDTO.getCouponType())) {
            couponDTO.setAmount(data.getBigDecimal("money"));
        }
        if (CouponDTO.CouponTypeEnum.DISCOUNT.equals((Object)couponDTO.getCouponType())) {
            couponDTO.setDiscount(data.getBigDecimal("discount").multiply(new BigDecimal("0.1")));
        }
        couponDTO.setCouponValidType(CouponDTO.CouponValidTypeEnum.from(data.getInteger("validType")));
        if (CouponDTO.CouponValidTypeEnum.RANGE.equals((Object)couponDTO.getCouponValidType())) {
            couponDTO.setStartValidDate(data.getDate("validDateStart"));
            couponDTO.setEndValidDate(data.getDate("validDateEnd"));
        }
        if (CouponDTO.CouponValidTypeEnum.AFTER.equals((Object)couponDTO.getCouponValidType())) {
            couponDTO.setValidDays(data.getInteger("validDay"));
            couponDTO.setGetDate(data.getDate("createDate"));
            if (couponDTO.getGetDate() == null) {
                couponDTO.setGetDate(data.getDate("getDate"));
            }
            couponDTO.setStartValidDate(couponDTO.getGetDate());
            couponDTO.setEndValidDate(new Date(couponDTO.getGetDate().getTime() + (long)couponDTO.getValidDays().intValue() * 86400000L));
        }
        couponDTO.setMinConsume(data.getBigDecimal("minConsume"));
        BigDecimal minDiscount = data.getBigDecimal("minDiscount");
        couponDTO.setCanUseDiscount(minDiscount == null ? BigDecimal.ZERO : minDiscount.multiply(new BigDecimal("0.1")));
        couponDTO.setIsAllowFoldUserDiscount(data.getBoolean("superpositionMemberCard"));
        return couponDTO;
    }

    public String getComponentAccessToken() {
        String url = this.bizvaneProperties.getComponentAccessTokenUrl();
        String data = this.doPost(url, new HashMap<String, Object>(), "\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e73\u53f0token").getString("data");
        return data;
    }

    public LoginUser decryptManagermentToken(String token) {
        String url = this.bizvaneProperties.getAdminTokenValidUrl();
        JSONObject result = (JSONObject)((PostRequest)HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url)).header("stageToken", token)).asBean(JSONObject.class);
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.error("response fail : {}", (Object)message);
            throw new RuntimeException(message);
        }
        JSONObject data = result.getJSONObject("data");
        log.info("decryptManagermentToken\u7684\u8fd4\u56de\u7ed3\u679c\u4e3a{}", (Object)data.toJSONString());
        return LoginUser.builder().merchantId(data.getInteger("brandId")).nickName(data.getString("name")).companyId(data.getInteger("sysCompanyId")).companyName(data.getString("companyName")).companyCode(data.getString("companyCode")).merchantName(data.getString("brandName")).merchantCode(data.getString("brandCode")).token(token).build();
    }

    public void notifyRefundApplied(RefundOrder od) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getRefundAppliedInfoNotifyUrl();
        OrderItems item = od.getItem();
        RefundDTO build = RefundDTO.builder().count(od.getSaleQuantity()).price(item.getMarketPrice()).specification("5,101").code("288319003").standardPrice(item.getMarketPrice()).standardAmount(item.getMarketPrice().multiply(BigDecimal.valueOf(item.getSaleQuantity().intValue()))).marketValue(item.getSalePrice().multiply(BigDecimal.valueOf(item.getSaleQuantity().intValue()))).amountReceivable(od.getItemAmout()).transactionAmount(od.getRefundAmount()).build();
        try {
            JSONObject result = (JSONObject)HttpClient.textBody((String)url).json((Object)build).asBean(JSONObject.class);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{"\u9000\u6b3e\u5230\u8d26\u901a\u77e5", url, JSONObject.toJSONString((Object)build), result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.error("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public void unLockCoupon(final CouponDTO couponDTO) {
        String url = this.bizvaneProperties.getUnLockCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponCode", couponDTO.getCode());
                this.put("memberCode", couponDTO.getUserNo());
            }
        };
        this.doPost(url, map, "\u5238\u89e3\u9501");
    }

    public void lockCoupon(final CouponDTO couponDTO) {
        if (couponDTO == null || couponDTO.getCode() == null) {
            return;
        }
        String url = this.bizvaneProperties.getLockCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponCode", couponDTO.getCode());
                this.put("memberCode", couponDTO.getUserNo());
            }
        };
        this.doPost(url, map, "\u5238\u9501\u5b9a");
    }

    public void notifyPaidOrderInfo(Orders o) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getPaidOrdersInfoNotifyUrl();
        OrdersDTO ordersDTO = OrdersDTO.builder().brandId(o.getMerchantId()).orderNo(o.getOrderNo()).orderTime(sdf.format(o.getGmtCreate())).consigneeName(o.getShippingName()).consigneePhone(o.getShippingMobile()).consigneeProvince(o.getShippingProvince()).consigneeCity(o.getShippingCity()).consigneeArea(o.getShippingDistrict()).consigneeStreet("").consigneeDetailed(o.getShippingAddress()).erpId(o.getUserId().toString()).erpStoreId("").erpGuideId("").shareGuideId("").commodityAmount(o.getOrderAmount()).standardAmount(o.getOrderAmount()).preferentialAmount(o.getOrderAmount()).deductibleAmount(BigDecimal.ZERO).otherPreferentialVolume(o.getActiveDeduction()).receivableAmount(o.getPayAmount()).transactionAmount(o.getPayAmount()).isPost(o.getShippingFee().equals(BigDecimal.ZERO) ? "Y" : "N").postage(o.getShippingFee()).payMoney(o.getPayAmount()).vipcouponCode(o.getCouponNo()).logisticsStatus(o.getLogisticsStatus().compareTo(LogisticsStatusEnum.SEND) == 0 ? 1 : (o.getLogisticsStatus().compareTo(LogisticsStatusEnum.UN_SEND) == 0 ? 0 : 2)).orderItem(o.getItems().stream().map(od -> OrdersDTO.OrderItem.builder().count(od.getSaleQuantity()).price(od.getMarketPrice()).specification(od.getGoodsSkuName()).code(od.getGoodsSkuNo()).standardPrice(od.getMarketPrice()).standardAmount(od.getMarketPrice().multiply(BigDecimal.valueOf(od.getSaleQuantity().intValue()))).marketValue(od.getSalePrice().multiply(BigDecimal.valueOf(od.getSaleQuantity().intValue()))).amountReceivable(od.getItemsAmount()).transactionAmount(od.getItemsPayAmount()).build()).collect(Collectors.toList())).build();
        try {
            JSONObject result = (JSONObject)HttpClient.textBody((String)url).json((Object)ordersDTO).asBean(JSONObject.class);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{"\u8ba2\u5355\u4ed8\u6b3e\u901a\u77e5", url, JSONObject.toJSONString((Object)ordersDTO), result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.error("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public Map<String, Object> pickupCoupon(Map<String, Object> map) {
        String url = this.bizvaneProperties.getPickCouponUrl();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            JSONObject data = this.doPost(url, map, "\u9886\u53d6\u4f18\u60e0\u5238").getJSONObject("data");
            if (data == null || data.isEmpty()) {
                throw new RuntimeException("\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25\uff01");
            }
            result.put("countTodaySum", data.getLong("countTodaySum"));
            result.put("countAllSum", data.getLong("countAllSum"));
        }
        catch (RuntimeException e) {
            throw new CustomException(e.getMessage());
        }
        return result;
    }

    public CouponDTO getCouponDetail(final Integer couponEntityId) {
        String url = this.bizvaneProperties.getCouponDetailUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponEntityId", couponEntityId);
            }
        };
        JSONObject data = this.doPost(url, map, "\u83b7\u53d6\u5238\u8be6\u60c5").getJSONObject("data");
        return BizvaneInterface.getCouponDTOByDetailData(data);
    }

    public UserDiscountDTO userLevelDiscountInfo(final Integer levelId) {
        HashMap map;
        String url = this.bizvaneProperties.getMemberLevelDiscountUrl();
        JSONObject data = this.doPost(url, map = new HashMap(){
            {
                this.put("mbrLevelId", levelId);
            }
        }, "\u83b7\u53d6\u4f1a\u5458\u7b49\u7ea7\u4f18\u60e0\u4fe1\u606f").getJSONObject("data");
        if (data == null || data.isEmpty()) {
            throw new RuntimeException("\u65e0\u6cd5\u62c9\u53d6\u4f1a\u5458\u7b49\u7ea7\u6298\u6263\u4fe1\u606f");
        }
        UserDiscountDTO userDiscountDTO = new UserDiscountDTO();
        String memberDiscount = data.getString("memberDiscount");
        if (StringUtils.isEmpty((Object)memberDiscount)) {
            log.info("\u62c9\u53d6\u4f1a\u5458\u7b49\u7ea7\u6298\u6263\u7387\u4e3a\u7a7a\uff0c\u5c06\u5176\u8bbe\u7f6e\u4e3a1\uff0c\u786e\u4fdd\u8ba1\u7b97\u4f1a\u5458\u6298\u6263\u4e0d\u62a5\u9519\u3002");
            userDiscountDTO.setDiscount(BigDecimal.ONE);
        } else {
            userDiscountDTO.setDiscount(new BigDecimal(memberDiscount).divide(BigDecimal.valueOf(100L)));
        }
        userDiscountDTO.setDiscountMethod(UserDiscountDTO.DiscountMethod.from(data.getInteger("discountMethod")));
        userDiscountDTO.setDiscountRange(UserDiscountDTO.DiscountRange.from(data.getInteger("discountControl")));
        userDiscountDTO.setDiscountMax(new BigDecimal(data.getString("discountMax")).divide(BigDecimal.valueOf(100L)));
        userDiscountDTO.setDiscountMin(new BigDecimal(data.getString("discountMin")).divide(BigDecimal.valueOf(100L)));
        if (userDiscountDTO.getDiscountMethod().equals((Object)UserDiscountDTO.DiscountMethod.FOLD_UP_THE_FOLD)) {
            userDiscountDTO.setFoldUpDiscount(new BigDecimal(data.getString("additionalDiscount")).divide(BigDecimal.valueOf(100L)));
        }
        return userDiscountDTO;
    }

    public void validCoupon(final CouponDTO couponDTO) {
        String url = this.bizvaneProperties.getVerifyCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponCode", couponDTO.getCode());
                this.put("memberCode", couponDTO.getUserNo());
                this.put("useBusinessCode", 1);
                this.put("profitMoney", couponDTO.getVerifyAmount());
                this.put("discountMoney", couponDTO.getDeductionAmount());
                this.put("brandId", couponDTO.getMerchantId());
            }
        };
        this.doPost(url, map, "\u4f18\u60e0\u5238\u6838\u9500");
    }

    public Map<String, Object> getCustomCounponList(final CouponDTO u, final Integer pageIndex) {
        String url = this.bizvaneProperties.getUserCouponListUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", u.getUserNo());
                this.put("couponStatus", 20);
                this.put("memberInfoModel.brandId", u.getMerchantId());
                this.put("pageNumber", pageIndex);
                this.put("pageSize", 20);
            }
        };
        JSONObject data = this.doPost(url, map, "\u83b7\u53d6\u7528\u6237\u4f18\u60e0\u5238").getJSONObject("data");
        JSONArray couponArr = data.getJSONArray("list");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<CouponDTO> couponDTOList = new ArrayList<CouponDTO>();
        for (Object object : couponArr) {
            CouponDTO couponDTO;
            JSONObject current = (JSONObject)object;
            if (current.getBoolean("lock").booleanValue() || current.getBoolean("use") != null && current.getBoolean("use").booleanValue() || CouponDTO.CouponChannelEnum.OFFLINE.equals((Object)(couponDTO = BizvaneInterface.getCouponByJSON(current)).getCouponChannel())) continue;
            couponDTOList.add(couponDTO);
        }
        result.put("list", couponDTOList);
        result.put("hasNextPage", data.getBooleanValue("hasNextPage"));
        return result;
    }

    public List<CouponDTO> getCouponList(final CouponDTO u) {
        HashMap map;
        String url = this.bizvaneProperties.getCouponListUrl();
        JSONArray data = this.doPost(url, map = new HashMap(){
            {
                this.put("memberInfoModel.memberCode", u.getUserNo());
                this.put("activityType", 4);
                this.put("memberInfoModel.brandId", u.getMerchantId());
            }
        }, "\u83b7\u53d6\u5238\u5217\u8868").getJSONArray("data");
        if (data == null || data.isEmpty()) {
            return null;
        }
        ArrayList<CouponDTO> couponDTOList = new ArrayList<CouponDTO>();
        for (Object object : data) {
            JSONObject current = (JSONObject)object;
            if (!current.getBooleanValue("canReceive")) continue;
            JSONObject couponJson = current.getJSONObject("couponDetailResponseVO").getJSONObject("couponDefinitionPO");
            CouponDTO couponDTO = BizvaneInterface.getCouponByJSON(couponJson);
            couponDTO.setActivityId(current.getInteger("mktActivityId"));
            couponDTO.setPerPersonMax(current.getInteger("perPersonMax"));
            couponDTO.setPerPersonPerDayMax(current.getInteger("perPersonPerDayMax"));
            if (CouponDTO.CouponChannelEnum.OFFLINE.equals((Object)couponDTO.getCouponChannel())) continue;
            couponDTOList.add(couponDTO);
        }
        return couponDTOList;
    }

    public User getMemberInfo(final User loginUserInfo) {
        String url = this.bizvaneProperties.getUserInfoUrl();
        HashMap map = new HashMap(){
            {
                this.put("wxUnionId", loginUserInfo.getUnionid());
                this.put("memberCode", loginUserInfo.getUserNo());
                this.put("brandId", loginUserInfo.getMerchantId());
            }
        };
        log.info("\u652f\u4ed8\u6210\u529f");
        JSONObject data = null;
        try {
            data = this.doPost(url, map, "\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f").getJSONObject("data");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        if (data == null) {
            return null;
        }
        User remoteUser = new User();
        remoteUser.setUserNo(data.getString("memberCode"));
        remoteUser.setUserId(data.getInteger("mbrMemberId"));
        remoteUser.setBrandId(data.getInteger("brandId"));
        remoteUser.setLevelId(data.getInteger("levelId"));
        remoteUser.setFullName(data.getString("name"));
        remoteUser.setOpenid(data.getString("wxOpenId"));
        String headPortraits = data.getString("headPortraits");
        if (!StringUtils.isEmpty((Object)headPortraits) && !headPortraits.contains("https")) {
            headPortraits = "https://" + this.qiNiuProperties.getDomain() + "/" + headPortraits;
        }
        remoteUser.setHeadImgUrl(headPortraits);
        remoteUser.setEnabledCommission(data.getBoolean("distributionState"));
        remoteUser.setCountIntegral(data.getLong("countIntegral"));
        log.info("\u4f1a\u5458\u4e2d\u5fc3\u83b7\u53d6\u4fe1\u606f\u8fd4\u56de\u53c2\u6570:[{}]", JSON.toJSON((Object)remoteUser));
        return remoteUser;
    }

    private JSONObject doPost(String url, Map<String, Object> param, String interfaceName) {
        PostRequest post = HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url));
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            post.param(entry.getKey(), entry.getValue().toString());
        }
        JSONObject result = null;
        try {
            result = (JSONObject)post.asBean(JSONObject.class);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, this.bizvaneProperties.getRequestPrefix() + url, JSONObject.toJSONString(param), result});
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.error("response fail : {}", (Object)message);
            throw new RuntimeException(message);
        }
        return result;
    }

    private JSONObject doPost3(String url, Map<String, Object> param, String interfaceName) {
        CloseableHttpClient clients = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            BasicNameValuePair nameValuePair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
            list.add(nameValuePair);
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
            CloseableHttpResponse response = clients.execute((HttpUriRequest)httpPost);
            int n = response.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private JSONObject doPost2(String url, Map<String, Object> param, String interfaceName) {
        PostRequest post = HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url));
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            post.param(entry.getKey(), entry.getValue().toString());
        }
        post.header("Content-Type", "application/json");
        JSONObject result = null;
        try {
            result = (JSONObject)post.asBean(JSONObject.class);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u4f1a\u5458\u6570\u636e\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, this.bizvaneProperties.getRequestPrefix() + url, JSONObject.toJSONString(param), result});
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.error("response fail : {}", (Object)message);
            throw new RuntimeException(message);
        }
        return result;
    }

    private boolean requestFail(JSONObject result) {
        return result == null || result.getInteger("code") != 0;
    }

    public RestResult refundIntegralChange(final IntegralRefundOrder integralRefundOrder) {
        HashMap map;
        String url = this.bizvaneProperties.getIntegralChangeOperateUrl();
        JSONObject data = this.doPost(url, map = new HashMap(){
            {
                this.put("memberCode", integralRefundOrder.getMemberCode());
                this.put("changeIntegral", integralRefundOrder.getRefundIntegral() * integralRefundOrder.getRefundQuantity());
                this.put("changeType", 2);
                this.put("changeBills", integralRefundOrder.getRefundNo());
                this.put("businessType", 31);
            }
        }, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int code = data.getIntValue("code");
        return code == 0 ? RestResult.success() : RestResult.fail();
    }

    public RestResult consumeIntegralChange(final String memberCode, final Integer integral, final String orderNo) {
        HashMap map;
        String url = this.bizvaneProperties.getIntegralChangeOperateUrl();
        JSONObject data = this.doPost(url, map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("changeIntegral", integral);
                this.put("changeType", 1);
                this.put("changeBills", orderNo);
                this.put("businessType", 30);
            }
        }, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int code = data.getIntValue("code");
        return code == 0 ? RestResult.success() : RestResult.fail();
    }

    public Integer getUserIntegral(final String memberCode) {
        log.info("\u8c03\u53d6applet\u63a5\u53e3\u3002\u3002\u3002\u3002\u83b7\u53d6\u4f1a\u5458\u79ef\u5206");
        String url = this.bizvaneProperties.getMemberDeductionUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
            }
        };
        JSONObject data = this.doGet(url, map, "\u83b7\u53d6\u4f1a\u5458\u79ef\u5206").getJSONObject("data");
        if (data == null || data.isEmpty()) {
            return 0;
        }
        return data.getInteger("countIntegral");
    }

    public BigDecimal getIntegralProportion(final String memberCode) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\u3002\u3002\u3002\u83b7\u53d6\u79ef\u5206\u5151\u6362\u6bd4\u4f8b");
        String url = this.bizvaneProperties.getMemberDeductionUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
            }
        };
        JSONObject data = this.doGet(url, map, "\u83b7\u53d6\u79ef\u5206\u5151\u6362\u6bd4\u4f8b").getJSONObject("data");
        if (data == null || data.isEmpty()) {
            return BigDecimal.valueOf(0.0);
        }
        return data.getBigDecimal("discountRatio");
    }

    public BigDecimal getUserBalance(final String memberCode) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\u3002\u3002\u3002\u83b7\u53d6\u4f1a\u5458\u5361\u4f59\u989d");
        String url = this.bizvaneProperties.getMemberDeductionUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
            }
        };
        JSONObject data = this.doGet(url, map, "\u83b7\u53d6\u4f1a\u5458\u5361\u4f59\u989d").getJSONObject("data");
        if (data == null || data.isEmpty()) {
            return BigDecimal.valueOf(0.0);
        }
        BigDecimal balance = data.getBigDecimal("balance");
        return balance;
    }

    public String getAppid(final Integer brandId) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\u3002\u3002\u3002\u83b7\u53d6appid");
        String url = this.bizvaneProperties.getQueryAppidUrl();
        HashMap map = new HashMap(){
            {
                this.put("sysBrandId", brandId);
            }
        };
        JSONObject data = this.doGet(url, map, "\u83b7\u53d6\u5c0f\u7a0b\u5e8fappid");
        if (data == null || data.isEmpty()) {
            return null;
        }
        String appid = data.getString("data");
        return appid;
    }

    private JSONObject doGet(String url, Map<String, Object> param, String interfaceName) {
        JSONObject jsonObject = null;
        url = this.bizvaneProperties.getRequestPrefix() + url;
        CloseableHttpClient client = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        String params = null;
        try {
            params = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
            HttpGet httpGet = new HttpGet(url + "?" + params);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            response.close();
            jsonObject = JSONObject.parseObject((String)string);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, url, JSONObject.toJSONString(param), string});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public RestResult wscRefundIntegralChange(final String memberCode, final Integer integral, final String orderNo) {
        HashMap map;
        String url = this.bizvaneProperties.getIntegralChangeOperateUrl();
        JSONObject data = this.doPost(url, map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("changeIntegral", integral);
                this.put("changeType", 2);
                this.put("changeBills", orderNo);
                this.put("businessType", 36);
            }
        }, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int code = data.getIntValue("code");
        return code == 0 ? RestResult.success() : RestResult.fail();
    }

    public RestResult wscConsumeIntegralChange(final String memberCode, final Integer integral, final String orderNo) {
        HashMap map;
        String url = this.bizvaneProperties.getIntegralChangeOperateUrl();
        JSONObject data = this.doPost(url, map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("changeIntegral", integral);
                this.put("changeType", 1);
                this.put("changeBills", orderNo);
                this.put("businessType", 35);
            }
        }, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int code = data.getIntValue("code");
        return code == 0 ? RestResult.success() : RestResult.fail();
    }

    public RestResult kafkaTrack(KafkaTrack kafkaTrack) {
        log.info("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\u3002\u3002\u3002\u884c\u4e3a\u91c7\u96c6\u5206\u6790");
        String url = this.bizvaneProperties.getKafkaTrack();
        String kafkaBusinessNumValue = this.bizvaneProperties.getKafkaBusinessNumValue();
        String kafkaApiKeyValue = this.bizvaneProperties.getKafkaApiKeyValue();
        kafkaTrack.setBusinessNum(kafkaBusinessNumValue);
        kafkaTrack.setApiKey(kafkaApiKeyValue);
        JSONObject data = this.executePost(url, kafkaTrack);
        log.info("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\u3002\u3002\u3002\u884c\u4e3a\u91c7\u96c6\u5206\u6790\u8fd4\u56de\u4e3a\uff1a{}", (Object)data.toJSONString());
        if (1 == data.getIntValue("successFlag")) {
            return RestResult.success();
        }
        return RestResult.fail((String)data.getString("message"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject executePost(String url, Object param) {
        JSONObject jsonObject = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(10000).build();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPost.setConfig(requestConfig);
        String parameter = JSON.toJSONString((Object)param);
        StringEntity se = null;
        try {
            log.info("post\u4f20json\u683c\u5f0f\u53c2\u6570\u7684\u5de5\u5177\u65b9\u6cd5,\u53c2\u6570\u4e3a:{}", (Object)parameter);
            se = new StringEntity(parameter, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        se.setContentType("text/json");
        httpPost.setEntity((HttpEntity)se);
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            jsonObject = JSONObject.parseObject((String)result);
            httpClient.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return jsonObject;
    }

    public RestResult operationBalance(final String memberCode, final BigDecimal balance, final int code, final String orderNo) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\uff0c\u64cd\u4f5c\u4f1a\u5458\u4f59\u989d\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e3a:{}", (Object)OperationTypeEnum.getOperationTypeEnum(code).getMsg());
        String url = this.bizvaneProperties.getMemberBalanceAndIntegralUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("balance", balance);
                this.put("changeType", code);
                this.put("docno", orderNo);
            }
        };
        JSONObject data = this.doPost(url, map, "\u64cd\u4f5c\u4f1a\u5458\u4f59\u989d");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int resultCode = data.getIntValue("code");
        return resultCode == 0 ? RestResult.success() : RestResult.fail();
    }

    public RestResult operationIntegral(final String memberCode, final Integer integral, final int code, final String orderNo) {
        log.info("\u8c03\u7528applet\u63a5\u53e3\uff0c\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e3a:{}", (Object)OperationTypeEnum.getOperationTypeEnum(code).getMsg());
        String url = this.bizvaneProperties.getMemberBalanceAndIntegralUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", memberCode);
                this.put("changeIntegral", integral);
                this.put("changeType", code);
                this.put("docno", orderNo);
            }
        };
        JSONObject data = this.doPost(url, map, "\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206");
        if (data == null || data.isEmpty()) {
            return RestResult.fail();
        }
        int resultCode = data.getIntValue("code");
        return resultCode == 0 ? RestResult.success() : RestResult.fail();
    }

    public JSCode2SessionResponse getSession(final String appid, final String code) {
        log.info("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3\uff0c\u83b7\u53d6session\u3001unionid\u4fe1\u606f");
        String url = "https://api.weixin.qq.com/sns/component/jscode2session";
        HashMap map = new HashMap(){
            {
                this.put("appid", appid);
                this.put("js_code", code);
                this.put("grant_type", "authorization_code");
                this.put("component_appid", BizvaneInterface.this.weixinProperties.getComponentAppid());
                this.put("component_access_token", BizvaneInterface.this.getComponentAccessToken());
            }
        };
        return (JSCode2SessionResponse)this.doGetSan(url, map, "\u5fae\u4fe1\u767b\u9646").toJavaObject(JSCode2SessionResponse.class);
    }

    private JSONObject doGetSan(String url, Map<String, Object> param, String interfaceName) {
        JSONObject jsonObject = null;
        CloseableHttpClient client = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        String params = null;
        try {
            params = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
            HttpGet httpGet = new HttpGet(url + "?" + params);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            response.close();
            jsonObject = JSONObject.parseObject((String)string);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, url, JSONObject.toJSONString(param), string});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public void notifySendOrderInfo(Orders o) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getSendedOrdersInfoNotifyUrl();
        log.info("\u53d1\u8d27\u63a8\u9001\u7ebf\u4e0burl:[{}]", (Object)url);
        OrdersDTO ordersDTO = OrdersDTO.builder().brandId(o.getMerchantId()).orderNo(o.getOrderNo()).orderTime(sdf.format(o.getGmtCreate())).consigneeName(o.getShippingName()).consigneePhone(o.getShippingMobile()).consigneeProvince(o.getShippingProvince()).consigneeCity(o.getShippingCity()).consigneeArea(o.getShippingDistrict()).consigneeStreet("").consigneeDetailed(o.getShippingAddress()).erpId(o.getUserId().toString()).erpStoreId("").erpGuideId("").shareGuideId("").commodityAmount(o.getOrderAmount()).standardAmount(o.getOrderAmount()).preferentialAmount(o.getOrderAmount()).deductibleAmount(BigDecimal.ZERO).otherPreferentialVolume(o.getActiveDeduction()).receivableAmount(o.getPayAmount()).transactionAmount(o.getPayAmount()).isPost(o.getShippingFee().equals(BigDecimal.ZERO) ? "Y" : "N").postage(o.getShippingFee()).payMoney(o.getPayAmount()).vipcouponCode(o.getCouponNo()).logisticsStatus(o.getLogisticsStatus().compareTo(LogisticsStatusEnum.SEND) == 0 ? 1 : (o.getLogisticsStatus().compareTo(LogisticsStatusEnum.UN_SEND) == 0 ? 0 : 2)).orderItem(o.getItems().stream().map(od -> OrdersDTO.OrderItem.builder().count(od.getSaleQuantity()).price(od.getMarketPrice()).specification(od.getGoodsSkuName()).code(od.getGoodsSkuNo()).standardPrice(od.getMarketPrice()).standardAmount(od.getMarketPrice().multiply(BigDecimal.valueOf(od.getSaleQuantity().intValue()))).marketValue(od.getSalePrice().multiply(BigDecimal.valueOf(od.getSaleQuantity().intValue()))).amountReceivable(od.getItemsAmount()).transactionAmount(od.getItemsPayAmount()).build()).collect(Collectors.toList())).build();
        try {
            log.info("\u53d1\u8d27\u63a8\u9001\u7ebf\u4e0b\u5165\u53c2:[{}]", JSONObject.toJSON((Object)ordersDTO));
            JSONObject result = (JSONObject)HttpClient.textBody((String)url).json((Object)ordersDTO).asBean(JSONObject.class);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{"\u8ba2\u5355\u53d1\u8d27\u901a\u77e5", url, JSONObject.toJSONString((Object)ordersDTO), result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.error("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public JSONArray getStoreList(final String lat, final String lng, final String brandId, final String userNo) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getSearchStoreUrl();
        HashMap map = new HashMap(){
            {
                this.put("lat", lat);
                this.put("lng", lng);
                this.put("sysBrandId", brandId);
                this.put("memberCode", userNo);
            }
        };
        log.info("\u83b7\u53d6\u95e8\u5e97\u5217\u8868\u5165\u53c2:[{}]", JSONObject.toJSON((Object)map));
        JSONObject jsonObject = this.executePost(url, map);
        log.info("\u83b7\u53d6\u95e8\u5e97\u5217\u8868\u8fd4\u53c2:[{}]", (Object)jsonObject.toJSONString());
        JSONArray storeList = jsonObject.getJSONObject("data").getJSONArray("appletSysStoreBos");
        return storeList;
    }
}

