/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.event.RefundEvent;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RefundEventListener
implements ApplicationListener<RefundEvent> {
    private static final Logger log = LoggerFactory.getLogger(RefundEventListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;

    public void onApplicationEvent(RefundEvent refundEvent) {
        log.info("\u9000\u6b3e\u63a8\u9001\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
        this.scheduledThreadPoolExecutor.execute(() -> {
            RefundOrder refundOrder = refundEvent.getRefundOrder();
            log.info("\u65e0\u73b0\u91d1\u9000\u6b3e\u63a8\u9001\u4efb\u52a1:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)refundOrder));
            try {
                if (refundOrder != null && refundOrder.getRefundType().equals(1)) {
                    this.bizvaneInterface.notifyRefundApplied(refundEvent.getRefundOrder());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }
}

