/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.event.OrderEvent;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class AddOrderListener
implements ApplicationListener<OrderEvent> {
    private static final Logger log = LoggerFactory.getLogger(AddOrderListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;

    public void onApplicationEvent(OrderEvent orderEvent) {
        log.info("\u521b\u5efa\u8ba2\u5355\u63a8\u9001\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
        this.scheduledThreadPoolExecutor.execute(() -> {
            log.info("\u65b0\u589e\u8ba2\u5355\u63a8\u9001\u7ebf\u4e0b:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)orderEvent.getOrders()));
            try {
                Orders orders = orderEvent.getOrders();
                if (orders.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && orders.getLogisticsStatus().equals((Object)LogisticsStatusEnum.UN_SEND)) {
                    this.bizvaneInterface.notifyPaidOrderInfo(orderEvent.getOrders());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
        log.info("\u521b\u5efa\u8ba2\u5355\u63a8\u9001\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u7ed3\u675f----------->");
    }
}

