/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.wmeimob.fastboot.bizvane.dto.MarketOrdersGoodsDto;
import com.wmeimob.fastboot.bizvane.dto.MyReducePriceDto;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.bizvane.service.MarketActivityOrdersService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="marketActivityOrdersService")
public class MarketActivityOrdersServiceImpl
implements MarketActivityOrdersService {
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    @Autowired
    private MarketActivity marketActivity;

    @Override
    public List<MyReducePriceDto> queryMyReduce(Date currentTime, MarketActivityOrders mao) {
        List<MarketOrdersGoodsDto> mogt = this.marketActivityOrdersMapper.selectAvailbleOrdersByRule(mao.getLaunchUserNo());
        List<MarketOrdersGoodsDto> collect = mogt.stream().filter(e -> !e.getActivityEndTime().before(currentTime) || !DateUtils.addHours((Date)e.getGmtCreate(), (int)e.getActivityTermValidity()).before(currentTime)).collect(Collectors.toList());
        return this.chooseMyReduceByRule(currentTime, collect);
    }

    private List<MyReducePriceDto> chooseMyReduceByRule(Date currentTime, List<MarketOrdersGoodsDto> collect) {
        if (!CollectionUtils.isEmpty(collect)) {
            ArrayList<MyReducePriceDto> result = new ArrayList<MyReducePriceDto>();
            for (MarketOrdersGoodsDto mao : collect) {
                int step = this.chooseStep(currentTime, mao);
                result.add(this.getMyReduceResult(mao, step, currentTime));
            }
            return result;
        }
        return null;
    }

    private MyReducePriceDto getMyReduceResult(MarketOrdersGoodsDto mao, int step, Date currentTime) {
        return null;
    }

    private int chooseStep(Date currentTime, MarketOrdersGoodsDto mao) {
        return 0;
    }
}

