/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.wmeimob.fastboot.bizvane.dto.ReducePriceSkuDto;
import com.wmeimob.fastboot.bizvane.dto.ReduceProductDto;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.service.MarketActivityGoodsService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="marketActivityGoodsService")
public class MarketActivityGoodsServiceImpl
implements MarketActivityGoodsService {
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private MarketActivityMapper marketActivityMapper;
    @Autowired
    private GoodsMapper goodsMapper;

    @Override
    public ReduceProductDto queryActivityGoodsInfo(MarketActivityGoods mag, String activitySign, Integer merchantId) {
        List select = this.marketActivityGoodsMapper.select(mag);
        Goods goods = new Goods();
        goods.setSkuNo(((MarketActivityGoods)select.get(0)).getSkuNo());
        goods = (Goods)this.goodsMapper.selectOne(goods);
        ReduceProductDto rps = new ReduceProductDto();
        BeanUtils.copyProperties((Object)goods, (Object)rps);
        rps.setReduceRule(this.getActivityRules(mag.getMarketActivityNo()));
        return this.chooseStepBySign(activitySign, rps, merchantId);
    }

    private String getActivityRules(String marketActivityNo) {
        MarketActivity ma = new MarketActivity();
        ma.setActivityNo(marketActivityNo);
        ma.setActivityStatus(true);
        MarketActivity marketActivity = (MarketActivity)this.marketActivityMapper.selectOne(ma);
        return marketActivity.getActivityDetail();
    }

    private ReduceProductDto chooseStepBySign(String activitySign, ReduceProductDto rps, Integer merchantId) {
        if ("3".equals(activitySign)) {
            Goods goods = new Goods();
            goods.setGoodsNo(rps.getGoodsNo());
            goods.setMerchantId(merchantId);
            List select = this.goodsMapper.select(goods);
            rps.setReducePriceSkuDtos(select.stream().map(e -> {
                ReducePriceSkuDto rpsd = new ReducePriceSkuDto();
                BeanUtils.copyProperties((Object)e, (Object)rpsd);
                return rpsd;
            }).collect(Collectors.toList()));
        }
        return rps;
    }
}

