/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.open.loader;

import com.wmeimob.fastboot.starter.wechat.mapper.WechatMpMapper;
import com.wmeimob.wechat.open.loader.AuthorizerRefreshTokenLoader;
import com.wmeimob.wechat.open.model.AuthorizationInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMp;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AuthorizerRefreshTokenLoaderImpl
implements AuthorizerRefreshTokenLoader {
    private volatile Map<String, String> refreshTokenMap;
    @Resource
    private WechatMpMapper wechatMpMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public String get(String appid) {
        String refreshToken = this.refreshTokenMap != null && this.refreshTokenMap.get(appid) != null ? this.refreshTokenMap.get(appid) : (String)this.stringRedisTemplate.opsForValue().get((Object)("opens:authorizer_appids:" + appid + ":refresh_token"));
        if (refreshToken == null && this.wechatMpMapper != null) {
            WechatMp wechatMp = new WechatMp();
            wechatMp.setAppid(appid);
            List wechatMps = this.wechatMpMapper.select((Object)wechatMp);
            wechatMp = (WechatMp)wechatMps.get(0);
            if (wechatMp != null) {
                refreshToken = wechatMp.getAuthorizerRefreshToken();
            }
        }
        return refreshToken;
    }

    public void set(AuthorizationInfo authorizationInfo) {
        if (this.refreshTokenMap == null) {
            this.refreshTokenMap = new HashMap<String, String>(10);
        }
        String refreshToken = authorizationInfo.getAuthorizerRefreshToken();
        this.refreshTokenMap.put(authorizationInfo.getAuthorizerAppid(), refreshToken);
        this.stringRedisTemplate.opsForValue().set((Object)("opens:authorizer_appids:" + authorizationInfo.getAuthorizerAppid() + ":refresh_token"), (Object)authorizationInfo.getAuthorizerRefreshToken());
    }
}

