/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import tk.mybatis.mapper.entity.Example;

@Service(value="commonOrdersServiceImpl")
public class CommonOrdersServiceImpl
implements OrdersService {
    private static final Logger log = LoggerFactory.getLogger(CommonOrdersServiceImpl.class);
    @Resource
    private OrdersMapper ordersMapper;
    @Resource(name="commonConfigService")
    private ConfigService configService;

    public Orders findById(Integer id) {
        Orders param = new Orders();
        param.setId(id);
        Orders orders = this.ordersMapper.selectOrdersDetailById(param);
        Assert.notNull((Object)orders, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        if (OrdersStatusEnum.TRADE.equals((Object)orders.getOrderStatus()) && PayStatusEnum.UN_PAY.equals((Object)orders.getPayStatus())) {
            Config config = new Config();
            config.setMerchantId(orders.getMerchantId());
            Config queryConfig = (Config)this.configService.findOneByCondition(config);
            Integer settingCloseMini = queryConfig.getAwaitOrderPayMinute();
            Date date = new Date();
            date.setTime(orders.getGmtCreate().getTime() + (long)(settingCloseMini * 60) * 1000L);
            orders.setPayDeadLine(date);
        }
        return orders;
    }

    @Override
    public void confirm(Orders orders) {
        Assert.notNull((Object)orders.getUserId(), (String)"\u7528\u6237ID");
        Assert.notNull((Object)orders.getId(), (String)"\u8ba2\u5355ID");
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("userId", (Object)orders.getUserId()).andEqualTo("id", (Object)orders.getId());
        Date date = new Date();
        orders.setLogisticsStatus(LogisticsStatusEnum.RECEIVED);
        orders.setOrderStatus(OrdersStatusEnum.SUCCESS);
        orders.setReceiptAt(date);
        orders.setGmtModified(date);
        int result = this.ordersMapper.updateByExampleSelective(orders, example);
        if (result == 0) {
            log.error("\u786e\u8ba4\u6536\u8d27\u5931\u8d25 => {}", (Object)JSONObject.toJSONString((Object)orders));
            throw new CustomException("\u786e\u8ba4\u6536\u8d27\u5931\u8d25");
        }
    }

    public List<Orders> findByCondition(Orders condition) {
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("merchantId", (Object)condition.getMerchantId()).andEqualTo("enabledCommission", (Object)condition.getEnabledCommission()).andEqualTo("orderStatus", (Object)condition.getOrderStatus()).andEqualTo("logisticsStatus", (Object)condition.getLogisticsStatus()).andEqualTo("payStatus", (Object)condition.getPayStatus()).andCondition("DATEDIFF(SYSDATE(),receipt_at)>", (Object)condition.getCommissionCalcAfterReceiptDays()).andEqualTo("isSettleCommission", (Object)condition.getIsSettleCommission());
        return this.ordersMapper.selectByExample(example);
    }

    @Override
    public List<Orders> findEnabledCommissions(Integer merchantId) {
        Config config = this.configService.findSysConfig(merchantId);
        if (config == null || !config.getIsDistribution().booleanValue()) {
            return new ArrayList<Orders>();
        }
        Orders condition = new Orders();
        condition.setMerchantId(merchantId);
        condition.setEnabledCommission(true);
        condition.setOrderStatus(OrdersStatusEnum.SUCCESS);
        condition.setLogisticsStatus(LogisticsStatusEnum.RECEIVED);
        condition.setPayStatus(PayStatusEnum.SUCCESS);
        condition.setCommissionCalcAfterReceiptDays(config.getAwaitOrderReturn());
        condition.setIsSettleCommission(false);
        return this.findByCondition(condition);
    }

    @Override
    public void updateCommissionState(List<Orders> collect) {
        this.ordersMapper.updateCommissionsState(collect);
    }
}

