/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.easyokhttp.HttpClient;
import com.mzlion.easyokhttp.request.PostRequest;
import com.wmeimob.fastboot.autoconfigure.qiniu.QiNiuProperties;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.dto.OrdersDTO;
import com.wmeimob.fastboot.bizvane.dto.RefundDTO;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BizvaneInterface {
    private static final Logger log = LoggerFactory.getLogger(BizvaneInterface.class);
    @Resource
    private BizvaneProperties bizvaneProperties;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private QiNiuProperties qiNiuProperties;
    private static final long DAY_MILLISECOND = 86400000L;

    public JSONObject getMiniprogramRedirectConfiguration(final String appid) {
        String url = this.bizvaneProperties.getMiniprogramRedirectConfigUrl();
        HashMap map = new HashMap(){
            {
                this.put("appId", appid);
            }
        };
        JSONObject data = this.doPost(url, map, "\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u8df3\u8f6c\u914d\u7f6e").getJSONObject("data");
        return data;
    }

    public static CouponDTO getCouponDTOByDetailData(JSONObject data) {
        data.getJSONObject("couponEntityPO").put("validType", (Object)data.getJSONObject("couponDefinitionPO").getInteger("validType"));
        data.getJSONObject("couponEntityPO").put("validDay", (Object)data.getJSONObject("couponDefinitionPO").getInteger("validDay"));
        data.getJSONObject("couponEntityPO").put("superpositionMemberCard", (Object)data.getJSONObject("couponDefinitionPO").getInteger("superpositionMemberCard"));
        data.getJSONObject("couponEntityPO").put("minDiscount", (Object)data.getJSONObject("couponDefinitionPO").getInteger("minDiscount"));
        data.getJSONObject("couponEntityPO").put("minConsume", (Object)data.getJSONObject("couponDefinitionPO").getInteger("minConsume"));
        data.getJSONObject("couponEntityPO").put("maxPreferential", (Object)data.getJSONObject("couponDefinitionPO").getBigDecimal("maxPreferential"));
        data.getJSONObject("couponEntityPO").put("useChannel", (Object)data.getJSONObject("couponDefinitionPO").getInteger("useChannel"));
        CouponDTO couponDTO = BizvaneInterface.getCouponByJSON(data.getJSONObject("couponEntityPO"));
        return couponDTO;
    }

    public static CouponDTO getCouponByJSON(JSONObject data) {
        CouponDTO couponDTO = new CouponDTO();
        couponDTO.setId(data.getInteger("couponEntityId"));
        couponDTO.setCode(data.getString("couponCode"));
        couponDTO.setCouponName(data.getString("couponName"));
        couponDTO.setDefinitionId(data.getInteger("couponDefinitionId"));
        couponDTO.setInfo(data.getString("info"));
        couponDTO.setCouponType(CouponDTO.CouponTypeEnum.from(data.getInteger("preferentialType")));
        couponDTO.setMaxDiscountAmount(data.getBigDecimal("maxPreferential"));
        couponDTO.setCouponChannel(CouponDTO.CouponChannelEnum.from(data.getInteger("useChannel")));
        if (CouponDTO.CouponTypeEnum.CASH.equals((Object)couponDTO.getCouponType())) {
            couponDTO.setAmount(data.getBigDecimal("money"));
        }
        if (CouponDTO.CouponTypeEnum.DISCOUNT.equals((Object)couponDTO.getCouponType())) {
            couponDTO.setDiscount(data.getBigDecimal("discount").multiply(new BigDecimal("0.1")));
        }
        couponDTO.setCouponValidType(CouponDTO.CouponValidTypeEnum.from(data.getInteger("validType")));
        if (CouponDTO.CouponValidTypeEnum.RANGE.equals((Object)couponDTO.getCouponValidType())) {
            couponDTO.setStartValidDate(data.getDate("validDateStart"));
            couponDTO.setEndValidDate(data.getDate("validDateEnd"));
        }
        if (CouponDTO.CouponValidTypeEnum.AFTER.equals((Object)couponDTO.getCouponValidType())) {
            couponDTO.setValidDays(data.getInteger("validDay"));
            couponDTO.setGetDate(data.getDate("createDate"));
            if (couponDTO.getGetDate() == null) {
                couponDTO.setGetDate(data.getDate("getDate"));
            }
            couponDTO.setStartValidDate(couponDTO.getGetDate());
            couponDTO.setEndValidDate(new Date(couponDTO.getGetDate().getTime() + (long)couponDTO.getValidDays().intValue() * 86400000L));
        }
        couponDTO.setMinConsume(data.getBigDecimal("minConsume"));
        BigDecimal minDiscount = data.getBigDecimal("minDiscount");
        couponDTO.setCanUseDiscount(minDiscount == null ? BigDecimal.ZERO : minDiscount.multiply(new BigDecimal("0.1")));
        couponDTO.setIsAllowFoldUserDiscount(data.getBoolean("superpositionMemberCard"));
        return couponDTO;
    }

    public String getComponentAccessToken() {
        String url = this.bizvaneProperties.getComponentAccessTokenUrl();
        String data = this.doPost(url, new HashMap<String, Object>(), "\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e73\u53f0token").getString("data");
        return data;
    }

    public LoginUser decryptManagermentToken(String token) {
        String url = this.bizvaneProperties.getAdminTokenValidUrl();
        JSONObject result = (JSONObject)((PostRequest)HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url)).header("stageToken", token)).asBean(JSONObject.class);
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.error("response fail : {}", (Object)message);
            throw new RuntimeException(message);
        }
        JSONObject data = result.getJSONObject("data");
        return LoginUser.builder().merchantId(data.getInteger("brandId")).nickName(data.getString("name")).token(token).build();
    }

    public void notifyRefundApplied(RefundOrder od) {
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getRefundAppliedInfoNotifyUrl();
        OrderItems item = od.getItem();
        RefundDTO build = RefundDTO.builder().count(od.getSaleQuantity()).price(item.getMarketPrice()).specification(item.getGoodsSkuNo()).code(item.getGoodsId().toString()).standardPrice(item.getMarketPrice()).standardAmount(item.getMarketPrice().multiply(BigDecimal.valueOf(item.getSaleQuantity().intValue()))).marketValue(item.getSalePrice().multiply(BigDecimal.valueOf(item.getSaleQuantity().intValue()))).amountReceivable(od.getItemAmout()).transactionAmount(od.getRefundAmount()).build();
        try {
            JSONObject result = (JSONObject)HttpClient.textBody((String)url).json((Object)build).asBean(JSONObject.class);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{"\u9000\u6b3e\u5230\u8d26\u901a\u77e5", url, JSONObject.toJSONString((Object)build), result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.error("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public void unLockCoupon(final CouponDTO couponDTO) {
        String url = this.bizvaneProperties.getUnLockCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponCode", couponDTO.getCode());
                this.put("memberCode", couponDTO.getUserNo());
            }
        };
        this.doPost(url, map, "\u5238\u89e3\u9501");
    }

    public void lockCoupon(final CouponDTO couponDTO) {
        if (couponDTO == null || couponDTO.getCode() == null) {
            return;
        }
        String url = this.bizvaneProperties.getLockCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponCode", couponDTO.getCode());
                this.put("memberCode", couponDTO.getUserNo());
            }
        };
        this.doPost(url, map, "\u5238\u9501\u5b9a");
    }

    public void notifyPaidOrderInfo(Orders o) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getPaidOrdersInfoNotifyUrl();
        OrdersDTO ordersDTO = OrdersDTO.builder().brandId(o.getMerchantId()).orderNo(o.getOrderNo()).orderTime(sdf.format(o.getGmtCreate())).consigneeName(o.getShippingName()).consigneePhone(o.getShippingMobile()).consigneeProvince(o.getShippingProvince()).consigneeCity(o.getShippingCity()).consigneeArea(o.getShippingDistrict()).consigneeStreet("").consigneeDetailed(o.getShippingAddress()).erpId(o.getUserId().toString()).erpStoreId("").erpGuideId("").shareGuideId("").commodityAmount(o.getOrderAmount()).standardAmount(o.getOrderAmount()).preferentialAmount(o.getOrderAmount()).deductibleAmount(BigDecimal.ZERO).otherPreferentialVolume(o.getActiveDeduction()).receivableAmount(o.getPayAmount()).transactionAmount(o.getPayAmount()).isPost(o.getShippingFee().equals(BigDecimal.ZERO) ? "Y" : "N").postage(o.getShippingFee()).payMoney(o.getPayAmount()).vipcouponCode(o.getCouponNo()).orderItem(o.getItems().stream().map(od -> OrdersDTO.OrderItem.builder().count(od.getSaleQuantity()).price(od.getMarketPrice()).specification(od.getGoodsSkuName()).code(od.getGoodsSkuNo()).standardPrice(od.getMarketPrice()).standardAmount(od.getMarketPrice().multiply(BigDecimal.valueOf(od.getSaleQuantity().intValue()))).marketValue(od.getSalePrice().multiply(BigDecimal.valueOf(od.getSaleQuantity().intValue()))).amountReceivable(od.getItemsAmount()).transactionAmount(od.getItemsPayAmount()).build()).collect(Collectors.toList())).build();
        try {
            JSONObject result = (JSONObject)HttpClient.textBody((String)url).json((Object)ordersDTO).asBean(JSONObject.class);
            log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{"\u8ba2\u5355\u4ed8\u6b3e\u901a\u77e5", url, JSONObject.toJSONString((Object)ordersDTO), result});
            if (this.requestFail(result)) {
                String message = result == null ? "empty" : result.getString("message");
                log.error("response fail : {}", (Object)message);
                throw new RuntimeException(message);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public void pickupCoupon(final CouponDTO couponDTO) {
        String url = this.bizvaneProperties.getPickCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberInfoModel.brandId", couponDTO.getMerchantId());
                this.put("memberInfoModel.memberCode", couponDTO.getUserNo());
                this.put("couponDefinitionId", couponDTO.getDefinitionId());
                this.put("mktActivityId", couponDTO.getActivityId());
                this.put("activityType", 4);
            }
        };
        try {
            this.doPost(url, map, "\u9886\u53d6\u4f18\u60e0\u5238");
        }
        catch (RuntimeException e) {
            throw new CustomException(e.getMessage());
        }
    }

    public CouponDTO getCouponDetail(final Integer couponEntityId) {
        String url = this.bizvaneProperties.getCouponDetailUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponEntityId", couponEntityId);
            }
        };
        JSONObject data = this.doPost(url, map, "\u83b7\u53d6\u5238\u8be6\u60c5").getJSONObject("data");
        return BizvaneInterface.getCouponDTOByDetailData(data);
    }

    public UserDiscountDTO userLevelDiscountInfo(final Integer levelId) {
        HashMap map;
        String url = this.bizvaneProperties.getMemberLevelDiscountUrl();
        JSONObject data = this.doPost(url, map = new HashMap(){
            {
                this.put("mbrLevelId", levelId);
            }
        }, "\u83b7\u53d6\u4f1a\u5458\u7b49\u7ea7\u4f18\u60e0\u4fe1\u606f").getJSONObject("data");
        if (data == null || data.isEmpty()) {
            throw new RuntimeException("\u65e0\u6cd5\u62c9\u53d6\u4f1a\u5458\u7b49\u7ea7\u6298\u6263\u4fe1\u606f");
        }
        UserDiscountDTO userDiscountDTO = new UserDiscountDTO();
        userDiscountDTO.setDiscount(new BigDecimal(data.getString("memberDiscount")).divide(BigDecimal.valueOf(100L)));
        userDiscountDTO.setDiscountMethod(UserDiscountDTO.DiscountMethod.from(data.getInteger("discountMethod")));
        userDiscountDTO.setDiscountRange(UserDiscountDTO.DiscountRange.from(data.getInteger("discountControl")));
        userDiscountDTO.setDiscountMax(new BigDecimal(data.getString("discountMax")).divide(BigDecimal.valueOf(100L)));
        userDiscountDTO.setDiscountMin(new BigDecimal(data.getString("discountMin")).divide(BigDecimal.valueOf(100L)));
        if (userDiscountDTO.getDiscountMethod().equals((Object)UserDiscountDTO.DiscountMethod.FOLD_UP_THE_FOLD)) {
            userDiscountDTO.setFoldUpDiscount(new BigDecimal(data.getString("additionalDiscount")).divide(BigDecimal.valueOf(100L)));
        }
        return userDiscountDTO;
    }

    public void validCoupon(final CouponDTO couponDTO) {
        String url = this.bizvaneProperties.getVerifyCouponUrl();
        HashMap map = new HashMap(){
            {
                this.put("couponCode", couponDTO.getCode());
                this.put("memberCode", couponDTO.getUserNo());
                this.put("useBusinessCode", 1);
                this.put("profitMoney", couponDTO.getVerifyAmount());
                this.put("discountMoney", couponDTO.getDeductionAmount());
                this.put("brandId", couponDTO.getMerchantId());
            }
        };
        this.doPost(url, map, "\u4f18\u60e0\u5238\u6838\u9500");
    }

    public Map<String, Object> getCustomCounponList(final CouponDTO u, final Integer pageIndex) {
        String url = this.bizvaneProperties.getUserCouponListUrl();
        HashMap map = new HashMap(){
            {
                this.put("memberCode", u.getUserNo());
                this.put("couponStatus", 20);
                this.put("memberInfoModel.brandId", u.getMerchantId());
                this.put("pageNumber", pageIndex);
                this.put("pageSize", 20);
            }
        };
        JSONObject data = this.doPost(url, map, "\u83b7\u53d6\u7528\u6237\u4f18\u60e0\u5238").getJSONObject("data");
        JSONArray couponArr = data.getJSONArray("list");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<CouponDTO> couponDTOList = new ArrayList<CouponDTO>();
        for (Object object : couponArr) {
            CouponDTO couponDTO;
            JSONObject current = (JSONObject)object;
            if (current.getBoolean("lock").booleanValue() || current.getBoolean("use") != null && current.getBoolean("use").booleanValue() || CouponDTO.CouponChannelEnum.OFFLINE.equals((Object)(couponDTO = BizvaneInterface.getCouponByJSON(current)).getCouponChannel())) continue;
            couponDTOList.add(couponDTO);
        }
        result.put("list", couponDTOList);
        result.put("hasNextPage", data.getBooleanValue("hasNextPage"));
        return result;
    }

    public List<CouponDTO> getCouponList(final CouponDTO u) {
        HashMap map;
        String url = this.bizvaneProperties.getCouponListUrl();
        JSONArray data = this.doPost(url, map = new HashMap(){
            {
                this.put("memberInfoModel.memberCode", u.getUserNo());
                this.put("activityType", 4);
                this.put("memberInfoModel.brandId", u.getMerchantId());
            }
        }, "\u83b7\u53d6\u5238\u5217\u8868").getJSONArray("data");
        if (data == null || data.isEmpty()) {
            return null;
        }
        ArrayList<CouponDTO> couponDTOList = new ArrayList<CouponDTO>();
        for (Object object : data) {
            JSONObject current = (JSONObject)object;
            if (!current.getBooleanValue("canReceive")) continue;
            JSONObject couponJson = current.getJSONObject("couponDetailResponseVO").getJSONObject("couponDefinitionPO");
            CouponDTO couponDTO = BizvaneInterface.getCouponByJSON(couponJson);
            couponDTO.setActivityId(current.getInteger("mktActivityId"));
            if (CouponDTO.CouponChannelEnum.OFFLINE.equals((Object)couponDTO.getCouponChannel())) continue;
            couponDTOList.add(couponDTO);
        }
        return couponDTOList;
    }

    public User getMemberInfo(final User loginUserInfo) {
        JSONObject data;
        String url = this.bizvaneProperties.getUserInfoUrl();
        HashMap map = new HashMap(){
            {
                this.put("wxUnionId", loginUserInfo.getUnionid());
                this.put("memberCode", loginUserInfo.getUserNo());
            }
        };
        if ("office".equals(this.applicationContext.getEnvironment().getActiveProfiles()[0])) {
            map.put("wxUnionId", "or4ga0q2qw17EWdRsh1LNIlqd_G0");
        }
        if ((data = this.doPost(url, map, "\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f").getJSONObject("data")) == null) {
            return null;
        }
        User remoteUser = new User();
        remoteUser.setUserNo(data.getString("memberCode"));
        remoteUser.setUserId(data.getInteger("mbrMemberId"));
        remoteUser.setBrandId(data.getInteger("brandId"));
        remoteUser.setLevelId(data.getInteger("levelId"));
        remoteUser.setFullName(data.getString("name"));
        remoteUser.setHeadImgUrl(data.getString("headPortraits") == null ? "" : "https://" + this.qiNiuProperties.getDomain() + "/" + data.getString("headPortraits"));
        remoteUser.setEnabledCommission(data.getBoolean("distributionState"));
        return remoteUser;
    }

    private JSONObject doPost(String url, Map<String, Object> param, String interfaceName) {
        PostRequest post = HttpClient.post((String)(this.bizvaneProperties.getRequestPrefix() + url));
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (entry.getValue() == null) {
                entry.setValue("");
            }
            post.param(entry.getKey(), entry.getValue().toString());
        }
        JSONObject result = null;
        try {
            result = (JSONObject)post.asBean(JSONObject.class);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        log.info("\u63a5\u53e3\u540d\u79f0\uff1a{},\u8bf7\u6c42\u5730\u5740\uff1a {} ,\u8bf7\u6c42\u53c2\u6570\uff1a {} ==> {}", new Object[]{interfaceName, this.bizvaneProperties.getRequestPrefix() + url, JSONObject.toJSONString(param), result});
        if (this.requestFail(result)) {
            String message = result == null ? "empty" : result.getString("message");
            log.error("response fail : {}", (Object)message);
            throw new RuntimeException(message);
        }
        return result;
    }

    private boolean requestFail(JSONObject result) {
        return result == null || result.getInteger("code") != 0;
    }
}

