/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.wmeimob.fastboot.bizvane.dto.StatisticalDTO;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.enums.PushToWhereEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.event.OrderEvent;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class OrdersServiceImpl
implements OrdersService {
    private static final Logger log = LoggerFactory.getLogger(OrdersServiceImpl.class);
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private OrderItemsMapper orderItemsMapper;
    @Resource
    private RefundOrderMapper refundOrderMapper;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersService;
    @Resource
    private BizvaneInterface bizvaneInterface;
    private static final ScheduledThreadPoolExecutor SCHEDULE = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("wechat-loreal-global-pool-%d").build());
    @Autowired
    private ApplicationContext applicationContext;

    public List<Orders> findByCondition(Orders orders) {
        return this.ordersMapper.selectOrderList(orders);
    }

    public int update(Orders orders) {
        Date date = new Date();
        orders.setGmtModified(date);
        if (orders.getLogisticsStatus() != null && orders.getLogisticsStatus().equals((Object)LogisticsStatusEnum.SEND)) {
            int result;
            if (orders.getShippingMode() == 1) {
                orders.setShippingAt(date);
                orders.setLogisticsStatus(LogisticsStatusEnum.RECEIVED);
                orders.setOrderStatus(OrdersStatusEnum.SUCCESS);
                orders.setReceiptAt(date);
                orders.setGmtModified(date);
                result = this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
            } else {
                InputValidator.checkLengthRange((Object)orders.getShippingNo(), (int)0, (int)20, (String)"\u5feb\u9012\u5355\u53f7");
                if (!Pattern.matches("^[a-zA-Z0-9\\-]+$", orders.getShippingNo())) {
                    throw new IllegalArgumentException("\u5feb\u9012\u5355\u53f7\u53c2\u6570\u5f02\u5e38");
                }
                orders.setShippingAt(date);
                result = this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
                if (result > 0) {
                    Config sysConfig = this.configService.findSysConfig(orders.getMerchantId());
                    Orders queryOrders = (Orders)this.ordersMapper.selectByPrimaryKey((Object)orders.getId());
                    orders.setUserId(queryOrders.getUserId());
                    orders.setId(queryOrders.getId());
                    SCHEDULE.schedule(() -> this.commonOrdersService.confirm(orders), (long)sysConfig.getAwaitOrderConfirm().intValue(), TimeUnit.DAYS);
                }
            }
            if (result < 1) {
                throw new CustomException("\u53d1\u8d27\u5931\u8d25");
            }
            Orders param = new Orders();
            param.setOrderNo(orders.getOrderNo());
            param.setId(orders.getId());
            Orders od = this.ordersMapper.selectOrdersDetailById((Object)param);
            OrderEvent orderDeliveryEvent = new OrderEvent((Object)this.applicationContext, od, PushFlagEnum.SEND_ORDER.getPushFlag(), PushToWhereEnum.TO_All.getPushToWhere(), null);
            try {
                this.applicationContext.publishEvent((ApplicationEvent)orderDeliveryEvent);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return result;
        }
        return this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
    }

    public Orders findById(String orderNo) {
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)example);
        if (orders != null) {
            return orders;
        }
        return null;
    }

    public List<StatisticalDTO> commissionStatisticalList(Orders orders) {
        List statisticalDTOS = this.ordersMapper.commissionStatisticalList(orders);
        if (statisticalDTOS.size() > 0) {
            StatisticalDTO statisticalDTO = new StatisticalDTO();
            statisticalDTO.setPrice(new BigDecimal("0"));
            statisticalDTO.setRefundPrice(new BigDecimal("0"));
            statisticalDTO.setCommission(new BigDecimal("0"));
            statisticalDTO.setCountOrder(Integer.valueOf(0));
            statisticalDTO.setCountRefundOrder(Integer.valueOf(0));
            statisticalDTO.setQuantity(Integer.valueOf(0));
            statisticalDTO.setRefundQuantity(Integer.valueOf(0));
            statisticalDTO.setCreateTime("\u603b\u8ba1");
            for (StatisticalDTO s : statisticalDTOS) {
                statisticalDTO.setPrice(statisticalDTO.getPrice().add(s.getPrice() == null ? new BigDecimal("0") : s.getPrice()));
                statisticalDTO.setRefundPrice(statisticalDTO.getRefundPrice().add(s.getRefundPrice() == null ? new BigDecimal("0") : s.getRefundPrice()));
                statisticalDTO.setCommission(statisticalDTO.getCommission().add(s.getCommission() == null ? new BigDecimal("0") : s.getCommission()));
                statisticalDTO.setCountOrder(Integer.valueOf(statisticalDTO.getCountOrder() + (s.getCountOrder() == null ? 0 : s.getCountOrder())));
                statisticalDTO.setCountRefundOrder(Integer.valueOf(statisticalDTO.getCountRefundOrder() + (s.getCountRefundOrder() == null ? 0 : s.getCountRefundOrder())));
                statisticalDTO.setQuantity(Integer.valueOf(statisticalDTO.getQuantity() + (s.getQuantity() == null ? 0 : s.getQuantity())));
                statisticalDTO.setRefundQuantity(Integer.valueOf(statisticalDTO.getRefundQuantity() + (s.getRefundQuantity() == null ? 0 : s.getRefundQuantity())));
            }
            statisticalDTOS.add(0, statisticalDTO);
        }
        return statisticalDTOS;
    }

    public List<StatisticalDTO> orderStatisticalList(Orders orders) {
        List statisticalDTOS = this.ordersMapper.orderStatisticalList(orders);
        if (statisticalDTOS.size() > 0) {
            StatisticalDTO statisticalDTO = new StatisticalDTO();
            statisticalDTO.setAvgPrice(new BigDecimal("0"));
            statisticalDTO.setAvgQuantity(Integer.valueOf(0));
            statisticalDTO.setCountCollect(Integer.valueOf(0));
            statisticalDTO.setCountOrder(Integer.valueOf(0));
            statisticalDTO.setCountRefundOrder(Integer.valueOf(0));
            statisticalDTO.setCountPayOrder(Integer.valueOf(0));
            statisticalDTO.setPayAmount(new BigDecimal("0"));
            statisticalDTO.setPayQuantity(Integer.valueOf(0));
            statisticalDTO.setPrice(new BigDecimal("0"));
            statisticalDTO.setQuantity(Integer.valueOf(0));
            statisticalDTO.setRefundPrice(new BigDecimal("0"));
            statisticalDTO.setRefundQuantity(Integer.valueOf(0));
            statisticalDTO.setCreateTime("\u603b\u8ba1");
            for (StatisticalDTO s : statisticalDTOS) {
                statisticalDTO.setAvgPrice(statisticalDTO.getAvgPrice().add(s.getAvgPrice() == null ? new BigDecimal("0") : s.getAvgPrice()));
                statisticalDTO.setPayAmount(statisticalDTO.getPayAmount().add(s.getPayAmount() == null ? new BigDecimal("0") : s.getPayAmount()));
                statisticalDTO.setPrice(statisticalDTO.getPrice().add(s.getPrice() == null ? new BigDecimal("0") : s.getPrice()));
                statisticalDTO.setRefundPrice(statisticalDTO.getRefundPrice().add(s.getRefundPrice() == null ? new BigDecimal("0") : s.getRefundPrice()));
                statisticalDTO.setAvgQuantity(Integer.valueOf(statisticalDTO.getAvgQuantity() + (s.getAvgQuantity() == null ? 0 : s.getAvgQuantity())));
                statisticalDTO.setCountCollect(Integer.valueOf(statisticalDTO.getCountCollect() + (s.getCountCollect() == null ? 0 : s.getCountCollect())));
                statisticalDTO.setCountPayOrder(Integer.valueOf(statisticalDTO.getCountPayOrder() + (s.getCountPayOrder() == null ? 0 : s.getCountPayOrder())));
                statisticalDTO.setCountOrder(Integer.valueOf(statisticalDTO.getCountOrder() + (s.getCountOrder() == null ? 0 : s.getCountOrder())));
                statisticalDTO.setCountRefundOrder(Integer.valueOf(statisticalDTO.getCountRefundOrder() + (s.getCountRefundOrder() == null ? 0 : s.getCountRefundOrder())));
                statisticalDTO.setPayQuantity(Integer.valueOf(statisticalDTO.getPayQuantity() + (s.getPayQuantity() == null ? 0 : s.getPayQuantity())));
                statisticalDTO.setQuantity(Integer.valueOf(statisticalDTO.getQuantity() + (s.getQuantity() == null ? 0 : s.getQuantity())));
                statisticalDTO.setRefundQuantity(Integer.valueOf(statisticalDTO.getRefundQuantity() + (s.getRefundQuantity() == null ? 0 : s.getRefundQuantity())));
            }
            statisticalDTOS.add(0, statisticalDTO);
        }
        return statisticalDTOS;
    }

    public Map judgeSend(Integer id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Orders orders = (Orders)this.ordersMapper.selectByPrimaryKey((Object)id);
        if (orders == null) {
            map.put("code", -1);
            map.put("msg", "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        String ordersNo = orders.getOrderNo();
        Example example = new Example(OrderItems.class);
        example.createCriteria().andEqualTo("orderNo", (Object)ordersNo);
        List itemsList = this.orderItemsMapper.selectByExample((Object)example);
        Example reExample = new Example(RefundOrder.class);
        reExample.createCriteria().andEqualTo("orderNo", (Object)ordersNo);
        List refundOrders = this.refundOrderMapper.selectByExample((Object)reExample);
        if (refundOrders.size() > 0) {
            if (refundOrders.size() == itemsList.size()) {
                map.put("code", -1);
                map.put("msg", "\u60a8\u8ba2\u5355\u4e0b\u5546\u54c1\u90fd\u5904\u4e8e\u9000\u8d27\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u53d1\u8d27\u3002");
                int i = 0;
                for (OrderItems orderItems : itemsList) {
                    if (!RefundStatus.SUCCESS.equals((Object)orderItems.getRefundStatus())) continue;
                    ++i;
                }
                if (i == itemsList.size()) {
                    orders.setOrderStatus(OrdersStatusEnum.FAIL);
                    this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
                }
            } else {
                StringBuffer sb = new StringBuffer();
                for (OrderItems items : itemsList) {
                    for (RefundOrder refundOrder : refundOrders) {
                        if (!refundOrder.getItemId().equals(items.getId())) continue;
                        sb.append("\u5546\u54c1\u540d\u79f0\uff1a[" + items.getGoodsName() + "],\u65e0\u6cd5\u53d1\u8d27\u3002 ");
                    }
                }
                map.put("code", 1);
                map.put("msg", sb.toString());
            }
        } else if (refundOrders.size() == 0) {
            map.put("code", 0);
        }
        return map;
    }

    public void pushToOffline(Integer id) {
        Orders orders = (Orders)this.ordersMapper.selectByPrimaryKey((Object)id);
        if (orders != null) {
            List orderItems = this.orderItemsMapper.selectOrderItemsListByNo(orders.getOrderNo());
            orders.setItems(orderItems);
            this.bizvaneInterface.notifyPaidOrderInfoOffLine(orders);
        }
    }
}

