/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralSpec;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralSpecMapper;
import com.wmeimob.fastboot.bizvane.service.IntegralSpecService;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralSpecServiceImpl
implements IntegralSpecService {
    @Autowired
    private IntegralSpecMapper integralSpecMapper;
    @Autowired
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;

    public IntegralSpec add(IntegralSpec integralSpec) {
        Example example = new Example(IntegralSpec.class);
        example.createCriteria().andEqualTo("specName", (Object)integralSpec.getSpecName()).andEqualTo("merchantId", (Object)integralSpec.getMerchantId());
        List integralSpecs = this.integralSpecMapper.selectByExample((Object)example);
        if (integralSpecs.size() > 0) {
            throw new CustomException("\u89c4\u683c\u540d\u79f0\u91cd\u590d");
        }
        List specList = integralSpec.getIntegralSpecList();
        if (specList == null || specList.size() < 1) {
            throw new CustomException("\u53ef\u9009\u9879\u4e0d\u53ef\u4e3a\u7a7a");
        }
        Date date = new Date();
        integralSpec.setGmtCreate(date);
        this.integralSpecMapper.insertSelective((Object)integralSpec);
        for (IntegralSpec g : specList) {
            g.setPid(integralSpec.getId());
            g.setGmtCreate(date);
            g.setMerchantId(integralSpec.getMerchantId());
            this.integralSpecMapper.insert((Object)g);
        }
        return integralSpec;
    }

    public int update(IntegralSpec integralSpec) {
        Example example = new Example(IntegralSpec.class);
        example.createCriteria().andEqualTo("specName", (Object)integralSpec.getSpecName()).andEqualTo("merchantId", (Object)integralSpec.getMerchantId()).andNotEqualTo("id", (Object)integralSpec.getId()).andNotEqualTo("pid", (Object)integralSpec.getId());
        List integralSpecs = this.integralSpecMapper.selectByExample((Object)example);
        if (integralSpecs.size() > 0) {
            throw new CustomException("\u89c4\u683c\u540d\u79f0\u91cd\u590d");
        }
        Date date = new Date();
        integralSpec.setGmtModified(date);
        if (integralSpec.getIntegralSpecList() != null && integralSpec.getIntegralSpecList().size() > 0) {
            List integralSpecList = integralSpec.getIntegralSpecList();
            for (IntegralSpec g : integralSpecList) {
                if (g.getId() == null) {
                    g.setPid(integralSpec.getId());
                    g.setGmtCreate(date);
                    g.setMerchantId(integralSpec.getMerchantId());
                    g.setSpecName(g.getSpecName());
                    this.integralSpecMapper.insertSelective((Object)g);
                    continue;
                }
                g.setPid(integralSpec.getId());
                g.setMerchantId(integralSpec.getMerchantId());
                g.setSpecName(g.getSpecName());
                g.setGmtModified(date);
                this.integralSpecMapper.updateByPrimaryKeySelective((Object)g);
            }
        }
        return this.integralSpecMapper.updateByPrimaryKeySelective((Object)integralSpec);
    }

    public int delete(Integer id) {
        Example example = new Example(IntegralSpec.class);
        example.createCriteria().andEqualTo("pid", (Object)id);
        List integralSpecs = this.integralSpecMapper.selectByExample((Object)example);
        if (integralSpecs.size() > 0) {
            throw new CustomException("\u8bf7\u5148\u5220\u9664\u53ef\u9009\u503c");
        }
        IntegralSpec integralSpec = (IntegralSpec)this.integralSpecMapper.selectByPrimaryKey((Object)id);
        Example goodSkuExample = new Example(IntegralGoodsSku.class);
        goodSkuExample.createCriteria().andEqualTo("valid", (Object)Boolean.TRUE).andLike("specIds", "%" + id + "%");
        List skus = this.integralGoodsSkuMapper.selectByExample((Object)goodSkuExample);
        if (skus.size() > 0) {
            throw new CustomException("\u6b64\u89c4\u683c\u6b63\u88ab\u5546\u54c1\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return this.integralSpecMapper.deleteByPrimaryKey((Object)id);
    }

    public List<IntegralSpec> getList(Integer merchantId) {
        Example example = new Example(IntegralSpec.class);
        example.orderBy("sort").desc();
        example.createCriteria().andEqualTo("pid", (Object)0).andEqualTo("merchantId", (Object)merchantId);
        List list = this.integralSpecMapper.selectByExample((Object)example);
        if (list != null && list.size() > 0) {
            for (IntegralSpec spec : list) {
                Example exampleChild = new Example(IntegralSpec.class);
                exampleChild.createCriteria().andEqualTo("pid", (Object)spec.getId()).andEqualTo("merchantId", (Object)merchantId);
                List childList = this.integralSpecMapper.selectByExample((Object)exampleChild);
                spec.setIntegralSpecList(childList);
            }
        }
        return list;
    }
}

