/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.Courier;
import com.wmeimob.fastboot.bizvane.mapper.CourierMapper;
import com.wmeimob.fastboot.bizvane.service.CourierService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class CourierServiceImpl
implements CourierService {
    @Autowired
    private CourierMapper courierMapper;

    public Courier add(Courier courier) {
        InputValidator.checkLengthRange((Object)courier.getName(), (int)1, (int)15, (String)"\u516c\u53f8\u540d\u79f0");
        Example example = new Example(Courier.class);
        example.createCriteria().andEqualTo("merchantId", (Object)courier.getMerchantId()).andEqualTo("name", (Object)courier.getName());
        List courierList = this.courierMapper.selectByExample((Object)example);
        if (courierList.size() > 0) {
            throw new CustomException("\u516c\u53f8\u540d\u79f0\u91cd\u590d");
        }
        courier.setGmtCreate(new Date());
        this.courierMapper.insertSelective((Object)courier);
        return courier;
    }

    public int delete(Integer id) {
        return this.courierMapper.deleteByPrimaryKey((Object)id);
    }

    public int update(Courier courier) {
        InputValidator.checkLengthRange((Object)courier.getName(), (int)1, (int)15, (String)"\u516c\u53f8\u540d\u79f0");
        Example example = new Example(Courier.class);
        example.createCriteria().andEqualTo("merchantId", (Object)courier.getMerchantId()).andEqualTo("name", (Object)courier.getName()).andNotEqualTo("id", (Object)courier.getId());
        List courierList = this.courierMapper.selectByExample((Object)example);
        if (courierList.size() > 0) {
            throw new CustomException("\u516c\u53f8\u540d\u79f0\u91cd\u590d");
        }
        courier.setGmtModified(new Date());
        return this.courierMapper.updateByPrimaryKeySelective((Object)courier);
    }

    public List<Courier> findByCondition(Courier courier) {
        InputValidator.checkEmpty((Object)courier.getMerchantId(), (String)"\u5546\u6237\u53f7");
        Example example = new Example(Courier.class);
        example.createCriteria().andEqualTo("merchantId", (Object)courier.getMerchantId());
        return this.courierMapper.selectByExample((Object)example);
    }
}

