/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.event.OrderEvent;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"test"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private ConfigService configService;
    @Autowired
    private OrdersService ordersService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private RefundOrderService refundOrderService;

    @Page
    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, Orders orders) {
        orders.setMerchantId(merchantId);
        List list = this.ordersService.findByCondition((Serializable)orders);
        return new PageInfo(list);
    }

    @GetMapping(value={"push"})
    public RestResult get() {
        try {
            OrderEvent event = new OrderEvent((Object)this.applicationContext, new Orders(), Integer.valueOf(1), null, null);
            this.applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return RestResult.fail();
        }
        return RestResult.success();
    }

    @PostMapping(value={"push1"})
    public RestResult push(@RequestBody Orders orders) {
        try {
            this.bizvaneInterface.notifySendOrderInfo(orders);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return RestResult.fail();
        }
        return RestResult.success();
    }

    @PostMapping(value={"operation"})
    public RestResult operationIntegral(String memberCode, Integer integral, int code, String orderNo) {
        try {
            this.bizvaneInterface.operationIntegral(memberCode, integral, code, orderNo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return RestResult.fail();
        }
        return RestResult.success();
    }

    @PutMapping(value={"refund/{id}"})
    public void updateRefundStatus(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        int result = this.refundOrderService.updateRefundStatus(merchantId, id);
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Orders orders, @PathVariable Integer id) {
        orders.setMerchantId(merchantId);
        int i = this.ordersService.update((Serializable)orders);
        return i < 1 ? RestResult.fail() : RestResult.success();
    }
}

