/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"config"})
public class ConfigController {
    @Resource
    private ConfigService configService;
    @Resource(name="commonConfigService")
    private ConfigService commonConfigService;

    @PostMapping
    public RestResult insetConfig(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Config config) {
        config.setMerchantId(merchantId);
        this.configService.add((Serializable)config);
        return RestResult.success((Object)config);
    }

    @GetMapping
    public Config getConfig(@RequestHeader(value="merchantId") Integer merchantId) {
        Config condition = new Config();
        condition.setMerchantId(merchantId);
        Config config = (Config)this.commonConfigService.findOneByCondition((Serializable)condition);
        return config;
    }

    @PutMapping(value={"{id}"})
    public RestResult updateConfig(@PathVariable(value="id") Integer id, @RequestHeader(value="merchantId", required=false) Integer merchantId, @RequestBody Config config) {
        config.setMerchantId(merchantId);
        int result = this.configService.update((Serializable)config);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }
}

