/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.service.ActivitySanService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"activitySan"})
public class ActivitySanController {
    private static final Logger log = LoggerFactory.getLogger(ActivitySanController.class);
    @Autowired
    private ActivitySanService activitySanService;

    @GetMapping(value={"/getActivitySanList"})
    @Page
    public PageInfo getActivitySanList(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="type") String type) {
        List list = this.activitySanService.getActivitySanList(type, merchantId);
        return new PageInfo(list);
    }

    @PostMapping(value={"/saveActivitySan"})
    public RestResult saveActivitySan(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Activity activity) {
        log.info("\u4fdd\u5b58\u6d3b\u52a8");
        InputValidator.checkEmpty((Collection)activity.getActivityRuleList(), (String)"\u6d3b\u52a8\u89c4\u5219");
        activity.setMerchantId(merchantId);
        if (activity.getId() == null) {
            log.info("\u65b0\u589e\u6d3b\u52a8\u3002\u3002\u3002");
            this.activitySanService.addActivitySan(activity);
        } else {
            log.info("\u4fee\u6539\u6d3b\u52a8\u3002\u3002\u3002");
            this.activitySanService.updateActivity(activity);
        }
        return RestResult.success();
    }

    @GetMapping(value={"/getActivityById"})
    public Activity getActivityById(@RequestParam(value="activityId") Integer activityId) {
        log.info("\u83b7\u53d6\u6d3b\u52a8\u8be6\u60c5,id:{}", (Object)activityId);
        return this.activitySanService.getActivityById(activityId);
    }

    @GetMapping(value={"/deleteActivityById"})
    public RestResult deleteActivityById(@RequestParam(value="activityId") Integer activityId) {
        log.info("\u5220\u9664\u6d3b\u52a8,id:{}", (Object)activityId);
        int result = this.activitySanService.deleteActivity(activityId);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }
}

