/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.OrderGift;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OperationTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.event.RefundEvent;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.open.service.MiniprogramService;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.exception.WepayException;
import me.hao0.wepay.model.enums.RefundAccount;
import me.hao0.wepay.model.refund.RefundApplyRequest;
import me.hao0.wepay.model.refund.RefundApplyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class RefundOrderServiceImpl
implements RefundOrderService {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderServiceImpl.class);
    @Autowired
    private RefundOrderMapper refundOrderMapper;
    @Autowired
    private OrderItemsMapper orderItemsMapper;
    @Autowired
    private OrderGiftMapper orderGiftMapper;
    @Resource
    private OrdersService ordersService;
    @Resource
    private WechatService wechatService;
    @Resource
    private WechatProperties wechatProperties;
    @Resource
    private MiniprogramService miniprogramService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersServiceImpl;
    @Resource
    private GoodsSkuDetailService goodsSkuDetailService;
    @Resource
    private WechatMchNewMapper wechatMchNewMapper;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private GoodsMapper goodsMapper;
    @Autowired
    private ApplicationContext applicationContext;

    public List<RefundOrder> findByCondition(RefundOrder condition) {
        return this.refundOrderMapper.findList(condition);
    }

    public int update(RefundOrder refundOrder) {
        Date date = new Date();
        refundOrder.setAuditAt(date);
        if (refundOrder.getAuditStatus() == 1) {
            Orders orders = (Orders)this.ordersService.findById(refundOrder.getOrderNo());
            if (orders.getLogisticsStatus().equals((Object)LogisticsStatusEnum.UN_SEND)) {
                Orders commonOrders = (Orders)this.commonOrdersServiceImpl.findById(orders.getId());
                List customSkuInfo = this.convertToSkuInfo(commonOrders.getItems());
                customSkuInfo.forEach(o -> o.setStock(Integer.valueOf(-o.getStock().intValue())));
                this.goodsSkuDetailService.inventoryReduction(customSkuInfo);
            }
            OrderGift orderGift = new OrderGift();
            Example example = new Example(OrderGift.class);
            example.createCriteria().andEqualTo("orderItemId", (Object)refundOrder.getItemId());
            orderGift.setHasRefund(Boolean.valueOf(refundOrder.getIsGift() == null));
            this.orderGiftMapper.updateByExampleSelective((Object)orderGift, (Object)example);
            OrderItems orderItems = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)refundOrder.getItemId());
            if (refundOrder.getRefundAmount().compareTo(orderItems.getWepayAmount()) == 1) {
                throw new CustomException("\u9000\u6b3e\u91d1\u989d\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getWepayAmount());
            }
            refundOrder.setAuditor(refundOrder.getNickName());
            if (refundOrder.getRefundIntegral() == null) {
                refundOrder.setRefundIntegral(Integer.valueOf(0));
            } else {
                if (orders.getPriceSystem().equals(0) && refundOrder.getRefundIntegral() > orderItems.getDeductionIntegral()) {
                    throw new CustomException("\u9000\u6b3e\u79ef\u5206\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getDeductionIntegral());
                }
                if (!orders.getPriceSystem().equals(0) && (long)refundOrder.getRefundIntegral().intValue() > orderItems.getPoints()) {
                    throw new CustomException("\u9000\u6b3e\u79ef\u5206\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getPoints());
                }
            }
            if (refundOrder.getRefundBalance() == null) {
                refundOrder.setRefundBalance(BigDecimal.ZERO);
            } else if (orders.getPriceSystem().equals(0) && refundOrder.getRefundBalance().compareTo(orderItems.getDeductionBalance()) == 1) {
                throw new CustomException("\u9000\u6b3e\u4f59\u989d\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getDeductionBalance());
            }
        }
        return this.refundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
    }

    public RefundOrder findById(Integer id) {
        RefundOrder refundOrder = this.refundOrderMapper.selectRefundOrderDetailById(id);
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("orderNo", (Object)refundOrder.getOrderNo());
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)example);
        if (orders == null) {
            return refundOrder;
        }
        refundOrder.setShippingFee(orders.getShippingFee());
        refundOrder.setShippingDeduction(orders.getShippingDeduction());
        return refundOrder;
    }

    public int updateRefundStatus(Integer merchantId, Integer id) {
        Goods goods;
        Integer num;
        BigDecimal banlance;
        Integer redundIntegral;
        RefundOrder refundOrder = (RefundOrder)this.refundOrderMapper.selectByPrimaryKey((Object)id);
        OrderItems orderItems = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)refundOrder.getItemId());
        Orders orders = (Orders)this.ordersService.findById(refundOrder.getOrderNo());
        if (orders != null && !orders.getPriceSystem().equals(2) && refundOrder.getRefundAmount().compareTo(BigDecimal.ZERO) == 1) {
            Example example = new Example(WechatMchNew.class);
            example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
            WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
            if (mchNew == null) {
                throw new CustomException("\u54c1\u724cID:" + merchantId + ",\u672a\u64cd\u4f5c\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
            }
            WechatMp wechatMp = new WechatMp();
            wechatMp.setAppid(mchNew.getAppId());
            WechatMch wechatMch = new WechatMch();
            wechatMch.setMchKey(mchNew.getMchKey());
            wechatMch.setMchNo(mchNew.getMchNo());
            wechatMch.setP12(mchNew.getP12());
            Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
            RefundApplyRequest refundApplyRequest = new RefundApplyRequest();
            refundApplyRequest.setOutTradeNo(refundOrder.getOrderNo());
            refundApplyRequest.setOutRefundNo(refundOrder.getRefundNo());
            refundApplyRequest.setRefundFee(Integer.valueOf(refundOrder.getRefundAmount().multiply(new BigDecimal("100")).intValue()));
            refundApplyRequest.setOpUserId(refundOrder.getAuditor());
            refundApplyRequest.setRefundDesc(refundOrder.getRefundReason());
            refundApplyRequest.setNotifyUrl((String)this.wechatProperties.getUrls().get("refund-notify"));
            refundApplyRequest.setRefundAccount(RefundAccount.REFUND_SOURCE_UNSETTLED_FUNDS);
            refundApplyRequest.setTotalFee(Integer.valueOf(orders.getPayAmount().multiply(new BigDecimal("100")).intValue()));
            log.info("\u5fae\u4fe1\u9000\u6b3e\u8bf7\u6c42\u4f53===>{}", (Object)JSONObject.toJSONString((Object)refundApplyRequest));
            try {
                RefundApplyResponse refundApplyResponse = wepay.refund().apply(refundApplyRequest);
                log.info("wexin pay refund result => {}", (Object)JSONObject.toJSONString((Object)refundApplyResponse));
            }
            catch (WepayException e2) {
                throw new CustomException(e2.getMessage());
            }
            catch (Exception e3) {
                log.error(e3.getMessage(), (Throwable)e3);
                e3.printStackTrace();
                return -1;
            }
        }
        if ((redundIntegral = refundOrder.getRefundIntegral()) > 0) {
            if (orders.getPriceSystem().equals(0) && redundIntegral > orderItems.getDeductionIntegral()) {
                redundIntegral = orderItems.getDeductionIntegral();
            } else if (!orders.getPriceSystem().equals(0) && (long)redundIntegral.intValue() > orderItems.getPoints()) {
                redundIntegral = Integer.parseInt(orderItems.getPoints() + "");
            }
            RestResult restResult = this.bizvaneInterface.operationIntegral(refundOrder.getUserNo(), redundIntegral, OperationTypeEnum.ADD.getCode(), refundOrder.getRefundNo());
            if (restResult.getCode() != 0) {
                return -1;
            }
        }
        if ((banlance = refundOrder.getRefundBalance()).compareTo(BigDecimal.ZERO) == 1) {
            RestResult restResult;
            if (banlance.compareTo(orderItems.getDeductionBalance()) == 1) {
                banlance = orderItems.getDeductionBalance();
            }
            if ((restResult = this.bizvaneInterface.operationBalance(refundOrder.getUserNo(), banlance, OperationTypeEnum.ADD.getCode(), refundOrder.getRefundNo())).getCode() != 0) {
                return -1;
            }
        }
        if (orders.getOrdersActivityType().equals("2") && (num = (goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)orderItems.getGoodsId())).getAssembleNum()) >= orderItems.getSaleQuantity()) {
            goods.setAssembleNum(Integer.valueOf(num - orderItems.getSaleQuantity()));
            this.goodsMapper.updateByPrimaryKeySelective((Object)goods);
        }
        if (orders.getPriceSystem().equals(2)) {
            orders.setOrderStatus(OrdersStatusEnum.FAIL);
            orders.setClosedAt(new Date());
            orders.setClosedReason("\u7533\u8bf7\u552e\u540e");
            this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
            RefundEvent refundEvent = new RefundEvent((Object)this.applicationContext, refundOrder);
            this.applicationContext.publishEvent((ApplicationEvent)refundEvent);
        }
        orderItems.setRefundStatus(RefundStatus.SUCCESS);
        int result = this.orderItemsMapper.updateByPrimaryKeySelective((Object)orderItems);
        if (orders.getPriceSystem().equals(0) && refundOrder.getRefundAmount().compareTo(BigDecimal.ZERO) == 0) {
            OrderItems odi = new OrderItems();
            odi.setOrderNo(orders.getOrderNo());
            List select = this.orderItemsMapper.select((Object)odi);
            RefundEvent refundEvent = new RefundEvent((Object)this.applicationContext, refundOrder);
            this.applicationContext.publishEvent((ApplicationEvent)refundEvent);
            if (!CollectionUtils.isEmpty((Collection)select)) {
                long count = select.stream().filter(e -> !e.getRefundStatus().equals((Object)RefundStatus.SUCCESS)).count();
                log.info("orderItems\u4e2d\u8fd8\u6709:[{}]\u6761\u8bb0\u5f55\u4e0d\u662fsuccess,\u4e3a0\u624d\u4f1a\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u4e3afail", (Object)count);
                if (count < 1L) {
                    Orders od = new Orders();
                    od.setId(orders.getId());
                    od.setOrderStatus(OrdersStatusEnum.FAIL);
                    od.setClosedAt(new Date());
                    od.setClosedReason("\u7533\u8bf7\u552e\u540e");
                    this.ordersMapper.updateByPrimaryKeySelective((Object)od);
                }
            }
        }
        return result;
    }

    private List<GoodsSkuDetail> convertToSkuInfo(List<OrderItems> orderItems) {
        ArrayList<GoodsSkuDetail> skuInfoList = new ArrayList<GoodsSkuDetail>();
        for (OrderItems item : orderItems) {
            GoodsSkuDetail skuInfo = new GoodsSkuDetail();
            skuInfo.setGoodsId(item.getGoodsId());
            skuInfo.setSkuNo(item.getGoodsSkuNo());
            skuInfo.setGoodsName(item.getGoodsName());
            skuInfo.setStock(item.getSaleQuantity());
            skuInfoList.add(skuInfo);
        }
        return skuInfoList;
    }
}

